/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache;

import android.content.Context;
import com.alimm.tanx.core.utils.FileUtil;
import com.alimm.tanx.ui.player.cache.videocache.HttpProxyCacheServer;
import com.alimm.tanx.ui.player.cache.videocache.file.FileNameGenerator;
import com.alimm.tanx.ui.player.cache.videocache.file.Md5FileNameGenerator;
import java.io.File;

public class ProxyCacheManager {
    public static HttpProxyCacheServer sharedProxy;
    public static final String CACHE_DIR = "video-cache";
    public static File cacheRoot;
    public static FileNameGenerator fileNameGenerator;

    public static HttpProxyCacheServer getProxy(Context context) {
        HttpProxyCacheServer httpProxyCacheServer = sharedProxy;
        if (httpProxyCacheServer == null) {
            sharedProxy = httpProxyCacheServer = ProxyCacheManager.newProxy(context);
        }
        return httpProxyCacheServer;
    }

    public static HttpProxyCacheServer newProxy(Context context) {
        cacheRoot = FileUtil.getIndividualCacheDirectory((Context)context, (String)CACHE_DIR);
        fileNameGenerator = new Md5FileNameGenerator();
        return new HttpProxyCacheServer.Builder(context).maxCacheFilesCount(5).cacheDirectory(cacheRoot).build();
    }

    public static boolean clearAllCache(Context context) {
        Context context2 = context;
        ProxyCacheManager.getProxy(context2);
        return FileUtil.deleteFiles((File)FileUtil.getIndividualCacheDirectory((Context)context2, (String)CACHE_DIR));
    }

    public static File getCacheFile(String string) {
        string = fileNameGenerator.generate(string);
        return new File(cacheRoot, string);
    }

    public static File getTempCacheFile(String string) {
        string = fileNameGenerator.generate(string) + ".download";
        return new File(cacheRoot, string);
    }
}

