/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import com.alimm.tanx.ui.player.cache.videocache.Cache;
import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheException;
import java.io.ByteArrayInputStream;
import java.util.Arrays;

public class ByteArrayCache
implements Cache {
    public volatile byte[] data;
    public volatile boolean completed;

    public ByteArrayCache() {
        this(new byte[0]);
    }

    public ByteArrayCache(byte[] byArray) {
        this.data = Preconditions.checkNotNull(byArray);
    }

    @Override
    public int read(byte[] byArray, long l, int n) throws ProxyCacheException {
        if (l >= (long)this.data.length) {
            return -1;
        }
        if (l <= Integer.MAX_VALUE) {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
            byteArrayInputStream2(this.data);
            return byteArrayInputStream.read(byArray, (int)l, n);
        }
        throw new IllegalArgumentException("Too long offset for memory cache " + l);
    }

    @Override
    public long available() throws ProxyCacheException {
        return this.data.length;
    }

    @Override
    public void append(byte[] byArray, int n) throws ProxyCacheException {
        Preconditions.checkNotNull(this.data);
        Preconditions.checkArgument(n >= 0 && n <= byArray.length);
        byte[] byArray2 = Arrays.copyOf(this.data, this.data.length + n);
        int n2 = this.data.length;
        System.arraycopy(byArray, 0, byArray2, n2, n);
        this.data = byArray2;
    }

    @Override
    public void close() throws ProxyCacheException {
    }

    @Override
    public void complete() {
        this.completed = true;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }
}

