/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import android.text.TextUtils;
import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetRequest {
    public static final Pattern RANGE_HEADER_PATTERN = Pattern.compile("[R,r]ange:[ ]?bytes=(\\d*)-");
    public static final Pattern URL_PATTERN = Pattern.compile("GET /(.*) HTTP");
    public final String uri;
    public final long rangeOffset;
    public final boolean partial;

    public GetRequest(String string) {
        String string2 = string;
        Preconditions.checkNotNull(string2);
        long l = this.findRangeOffset(string2);
        this.rangeOffset = Math.max(0L, l);
        boolean bl = l >= 0L;
        this.partial = bl;
        this.uri = this.findUri(string);
    }

    public static GetRequest read(InputStream object) throws IOException {
        String string;
        StringBuilder stringBuilder;
        BufferedReader bufferedReader;
        BufferedReader bufferedReader2 = bufferedReader;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        while (!TextUtils.isEmpty((CharSequence)(string = bufferedReader2.readLine()))) {
            ((StringBuilder)object).append(string).append('\n');
        }
        return new GetRequest(((StringBuilder)object).toString());
    }

    private long findRangeOffset(String string) {
        Matcher matcher = RANGE_HEADER_PATTERN.matcher(string);
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1));
        }
        return -1L;
    }

    private String findUri(String string) {
        Matcher matcher = URL_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Invalid request `" + string + "`: url not found!");
    }

    public String toString() {
        return "GetRequest{rangeOffset=" + this.rangeOffset + ", partial=" + this.partial + ", uri='" + this.uri + '\'' + '}';
    }
}

