/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import android.text.TextUtils;
import android.util.Log;
import com.alimm.tanx.ui.player.cache.videocache.CacheListener;
import com.alimm.tanx.ui.player.cache.videocache.GetRequest;
import com.alimm.tanx.ui.player.cache.videocache.HttpUrlSource;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCache;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.file.FileCache;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Locale;

public class HttpProxyCache
extends ProxyCache {
    public static final float NO_CACHE_BARRIER = 0.2f;
    public final HttpUrlSource source;
    public final FileCache cache;
    public CacheListener listener;

    public HttpProxyCache(HttpUrlSource httpUrlSource, FileCache fileCache) {
        super(httpUrlSource, fileCache);
        this.cache = fileCache;
        this.source = httpUrlSource;
    }

    private boolean isUseCache(GetRequest getRequest) throws ProxyCacheException {
        long l = this.source.length();
        boolean bl = l > 0L;
        long l2 = this.cache.available();
        return !bl || !getRequest.partial || (float)getRequest.rangeOffset <= (float)l2 + (float)l * 0.2f;
    }

    private String newResponseHeaders(GetRequest object) throws IOException, ProxyCacheException {
        Object object2;
        Object[] objectArray;
        Object[] objectArray2;
        HttpProxyCache httpProxyCache = object2;
        String string = httpProxyCache.source.getMime();
        boolean bl = TextUtils.isEmpty((CharSequence)string) ^ true;
        long l = httpProxyCache.cache.isCompleted() ? object2.cache.available() : object2.source.length();
        boolean bl2 = l >= 0L;
        long l2 = ((GetRequest)object).partial ? l - ((GetRequest)object).rangeOffset : l;
        boolean bl3 = bl2 && ((GetRequest)object).partial;
        Object[] objectArray3 = objectArray2;
        objectArray2 = new StringBuilder();
        String string2 = ((GetRequest)object).partial ? "HTTP/1.1 206 PARTIAL CONTENT\n" : "HTTP/1.1 200 OK\n";
        StringBuilder stringBuilder = objectArray3.append(string2).append("Accept-Ranges: bytes\n");
        if (bl2) {
            Object[] objectArray4 = new Object[1];
            objectArray3 = objectArray4;
            objectArray4[0] = l2;
            objectArray = object2.format("Content-Length: %d\n", objectArray3);
        } else {
            objectArray = "";
        }
        stringBuilder = stringBuilder.append((String)objectArray);
        if (bl3) {
            Object[] objectArray5 = new Object[3];
            objectArray = objectArray5;
            objectArray[0] = ((GetRequest)object).rangeOffset;
            objectArray[1] = l - 1L;
            objectArray5[2] = l;
            object = object2.format("Content-Range: bytes %d-%d/%d\n", objectArray);
        } else {
            object = "";
        }
        object = stringBuilder.append((String)object);
        if (bl) {
            HttpProxyCache httpProxyCache2 = object2;
            Object[] objectArray6 = new Object[1];
            object2 = objectArray6;
            objectArray6[0] = string;
            object2 = httpProxyCache2.format("Content-Type: %s\n", object2);
        } else {
            object2 = "";
        }
        return ((StringBuilder)object).append((String)object2).append("\n").toString();
    }

    private void responseWithCache(OutputStream outputStream, long l) throws ProxyCacheException, IOException {
        int n;
        Log.e((String)"\u5f00\u59cb\u8bfb\u53d6\u7f13\u5b58\u6570\u636e", (String)"\u7f13\u5b58\u6570\u636e\u8bfb\u53d6");
        byte[] byArray = new byte[8192];
        while ((n = this.read(byArray, l, byArray.length)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void responseWithoutCache(OutputStream outputStream, long l) throws ProxyCacheException, IOException {
        HttpUrlSource httpUrlSource;
        HttpUrlSource httpUrlSource2 = httpUrlSource;
        httpUrlSource2(((HttpProxyCache)object).source);
        try {
            httpUrlSource.open((int)l);
            Object object = new byte[8192];
            while (true) {
                int n;
                if ((n = httpUrlSource2.read((byte[])object)) == -1) {
                    outputStream.flush();
                    httpUrlSource2.close();
                    return;
                }
                outputStream.write((byte[])object, 0, n);
            }
        }
        catch (Throwable throwable) {
            httpUrlSource2.close();
            throw throwable;
        }
    }

    private String format(String string, Object ... objectArray) {
        return String.format(Locale.US, string, objectArray);
    }

    public void registerCacheListener(CacheListener cacheListener) {
        this.listener = cacheListener;
    }

    public void processRequest(GetRequest getRequest, Socket socket) throws IOException, ProxyCacheException {
        BufferedOutputStream bufferedOutputStream;
        GetRequest getRequest2 = getRequest;
        BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream;
        bufferedOutputStream2(socket.getOutputStream());
        bufferedOutputStream.write(this.newResponseHeaders(getRequest).getBytes("UTF-8"));
        long l = getRequest2.rangeOffset;
        if (this.isUseCache(getRequest2)) {
            this.responseWithCache(bufferedOutputStream2, l);
        } else {
            this.responseWithoutCache(bufferedOutputStream2, l);
        }
    }

    @Override
    public void onCachePercentsAvailableChanged(int n) {
        CacheListener cacheListener = this.listener;
        if (cacheListener != null) {
            cacheListener.onCacheAvailable(this.cache.file, this.source.getUrl(), n);
        }
    }
}

