/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import android.content.Context;
import android.net.Uri;
import com.alimm.tanx.ui.player.cache.videocache.CacheListener;
import com.alimm.tanx.ui.player.cache.videocache.Config;
import com.alimm.tanx.ui.player.cache.videocache.HttpProxyCacheServerClients;
import com.alimm.tanx.ui.player.cache.videocache.IgnoreHostProxySelector;
import com.alimm.tanx.ui.player.cache.videocache.Pinger;
import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheUtils;
import com.alimm.tanx.ui.player.cache.videocache.StorageUtils;
import com.alimm.tanx.ui.player.cache.videocache.file.DiskUsage;
import com.alimm.tanx.ui.player.cache.videocache.file.FileNameGenerator;
import com.alimm.tanx.ui.player.cache.videocache.file.Md5FileNameGenerator;
import com.alimm.tanx.ui.player.cache.videocache.file.TotalCountLruDiskUsage;
import com.alimm.tanx.ui.player.cache.videocache.file.TotalSizeLruDiskUsage;
import com.alimm.tanx.ui.player.cache.videocache.headers.EmptyHeadersInjector;
import com.alimm.tanx.ui.player.cache.videocache.headers.HeaderInjector;
import com.alimm.tanx.ui.player.cache.videocache.log.Logger;
import com.alimm.tanx.ui.player.cache.videocache.log.LoggerFactory;
import com.alimm.tanx.ui.player.cache.videocache.sourcestorage.SourceInfoStorage;
import com.alimm.tanx.ui.player.cache.videocache.sourcestorage.SourceInfoStorageFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HttpProxyCacheServer {
    public static final Logger LOG = LoggerFactory.getLogger("HttpProxyCacheServer");
    public static final String PROXY_HOST = "127.0.0.1";
    public final Object clientsLock = new Object();
    public final ExecutorService socketProcessor = Executors.newFixedThreadPool(8);
    public final Map<String, HttpProxyCacheServerClients> clientsMap = new ConcurrentHashMap<String, HttpProxyCacheServerClients>();
    public final ServerSocket serverSocket;
    public final int port;
    public final Thread waitConnectionThread;
    public final Config config;
    public final Pinger pinger;

    public HttpProxyCacheServer(Context context) {
        this(new Builder(context).buildConfig());
    }

    /*
     * WARNING - void declaration
     */
    public HttpProxyCacheServer(Config object) {
        void var1_4;
        CountDownLatch countDownLatch;
        this.config = Preconditions.checkNotNull(object);
        object = InetAddress.getByName(PROXY_HOST);
        this.serverSocket = new ServerSocket(0, 8, (InetAddress)object);
        this.port = this.serverSocket.getLocalPort();
        IgnoreHostProxySelector.install(PROXY_HOST, this.port);
        Object object2 = object = countDownLatch;
        ((CountDownLatch)object)(1);
        this.waitConnectionThread = new Thread(new WaitRequestsRunnable((CountDownLatch)object));
        this.waitConnectionThread.start();
        ((CountDownLatch)object2).await();
        this.pinger = new Pinger(PROXY_HOST, this.port);
        Logger logger = LOG;
        String[] stringArray = new String[1];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringArray[0] = stringBuilder.append("Proxy cache server started. Is it alive? ").append(this.isAlive()).toString();
            logger.info(stringArray);
            return;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socketProcessor.shutdown();
        throw new IllegalStateException("Error starting local proxy server", (Throwable)var1_4);
    }

    private boolean isAlive() {
        return this.pinger.ping(3, 70);
    }

    private String appendToProxyUrl(String string) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = PROXY_HOST;
        objectArray2[1] = this.port;
        objectArray[2] = ProxyCacheUtils.encode(string);
        return String.format(Locale.US, "http://%s:%d/%s", objectArray2);
    }

    private void touchFileSafely(File file) {
        try {
            this.config.diskUsage.touch(file);
        }
        catch (IOException iOException) {
            LOG.error("Error touching file " + file, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void shutdownClients() {
        HttpProxyCacheServer httpProxyCacheServer = this;
        Object object = httpProxyCacheServer.clientsLock;
        synchronized (object) {
            Iterator<HttpProxyCacheServerClients> iterator = httpProxyCacheServer.clientsMap.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.clientsMap.clear();
                    return;
                }
                iterator.next().shutdown();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForRequest() {
        while (true) {
            String[] stringArray;
            Logger logger;
            Socket socket;
            HttpProxyCacheServer httpProxyCacheServer;
            try {
                if (Thread.currentThread().isInterrupted()) return;
                HttpProxyCacheServer httpProxyCacheServer2 = this;
                httpProxyCacheServer = httpProxyCacheServer2;
                socket = httpProxyCacheServer2.serverSocket.accept();
                logger = LOG;
                stringArray = new String[1];
            }
            catch (IOException iOException) {
                this.onError(new ProxyCacheException("Error during waiting connection", iOException));
                return;
            }
            {
                stringArray[0] = "Accept new socket " + socket;
                logger.info(stringArray);
                httpProxyCacheServer.socketProcessor.submit(new SocketProcessorRunnable(socket));
                continue;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    private void processSocket(Socket var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [32 : 167->173)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpProxyCacheServerClients getClients(String string) throws ProxyCacheException {
        HttpProxyCacheServer httpProxyCacheServer = this;
        Object object = httpProxyCacheServer.clientsLock;
        synchronized (object) {
            HttpProxyCacheServerClients httpProxyCacheServerClients = httpProxyCacheServer.clientsMap.get(string);
            if (httpProxyCacheServerClients == null) {
                HttpProxyCacheServerClients httpProxyCacheServerClients2;
                httpProxyCacheServerClients = httpProxyCacheServerClients2;
                httpProxyCacheServerClients2 = new HttpProxyCacheServerClients(string, this.config);
                this.clientsMap.put(string, httpProxyCacheServerClients);
            }
            return httpProxyCacheServerClients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getClientsCount() {
        HttpProxyCacheServer httpProxyCacheServer = object;
        Object object = httpProxyCacheServer.clientsLock;
        synchronized (object) {
            int n = 0;
            Iterator<HttpProxyCacheServerClients> iterator = httpProxyCacheServer.clientsMap.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return n;
                }
                n += iterator.next().getClientsCount();
            }
        }
    }

    private void releaseSocket(Socket socket) {
        this.closeSocketInput(socket);
        this.closeSocketOutput(socket);
        this.closeSocket(socket);
    }

    private void closeSocketInput(Socket socket) {
        block4: {
            if (socket.isInputShutdown()) break block4;
            try {
                socket.shutdownInput();
            }
            catch (IOException iOException) {
                this.onError(new ProxyCacheException("Error closing socket input stream", iOException));
            }
            catch (SocketException socketException) {
                LOG.debug("Releasing input stream\u2026 Socket is closed by client.");
            }
        }
    }

    private void closeSocketOutput(Socket socket) {
        block3: {
            if (socket.isOutputShutdown()) break block3;
            try {
                socket.shutdownOutput();
            }
            catch (IOException iOException) {
                LOG.warn("Failed to close socket on proxy side: {}. It seems client have already closed connection.", iOException.getMessage());
            }
        }
    }

    private void closeSocket(Socket socket) {
        block3: {
            if (socket.isClosed()) break block3;
            try {
                socket.close();
            }
            catch (IOException iOException) {
                this.onError(new ProxyCacheException("Error closing socket", iOException));
            }
        }
    }

    private void onError(Throwable throwable) {
        LOG.error("HttpProxyCacheServer error", throwable);
    }

    public /* synthetic */ HttpProxyCacheServer(Config config, 1 var2_2) {
        this(config);
    }

    public String getProxyUrl(String string) {
        return this.getProxyUrl(string, true);
    }

    public String getProxyUrl(String string, boolean bl) {
        if (bl && ((HttpProxyCacheServer)((Object)file)).isCached(string)) {
            HttpProxyCacheServer httpProxyCacheServer = file;
            File file = httpProxyCacheServer.getCacheFile(string);
            httpProxyCacheServer.touchFileSafely(file);
            return Uri.fromFile((File)file).toString();
        }
        if (((HttpProxyCacheServer)((Object)file)).isAlive()) {
            string = ((HttpProxyCacheServer)((Object)file)).appendToProxyUrl(string);
        }
        return string;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public void registerCacheListener(CacheListener cacheListener, String string) {
        HttpProxyCacheServer httpProxyCacheServer = object;
        Preconditions.checkAllNotNull(cacheListener, string);
        Object object = ((HttpProxyCacheServer)object).clientsLock;
        synchronized (object) {
            Throwable throwable2;
            block6: {
                block5: {
                    try {
                        httpProxyCacheServer.getClients(string).registerCacheListener(cacheListener);
                        break block5;
                        catch (Throwable throwable2) {
                            break block6;
                        }
                    }
                    catch (ProxyCacheException proxyCacheException) {
                        LOG.warn("Error registering cache listener", proxyCacheException);
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public void unregisterCacheListener(CacheListener cacheListener, String string) {
        HttpProxyCacheServer httpProxyCacheServer = object;
        Preconditions.checkAllNotNull(cacheListener, string);
        Object object = ((HttpProxyCacheServer)object).clientsLock;
        synchronized (object) {
            Throwable throwable2;
            block6: {
                block5: {
                    try {
                        httpProxyCacheServer.getClients(string).unregisterCacheListener(cacheListener);
                        break block5;
                        catch (Throwable throwable2) {
                            break block6;
                        }
                    }
                    catch (ProxyCacheException proxyCacheException) {
                        LOG.warn("Error registering cache listener", proxyCacheException);
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterCacheListener(CacheListener cacheListener) {
        HttpProxyCacheServer httpProxyCacheServer = object;
        Preconditions.checkNotNull(cacheListener);
        Object object = httpProxyCacheServer.clientsLock;
        synchronized (object) {
            Iterator<HttpProxyCacheServerClients> iterator = httpProxyCacheServer.clientsMap.values().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                iterator.next().unregisterCacheListener(cacheListener);
            }
        }
    }

    public boolean isCached(String string) {
        String string2 = string;
        Preconditions.checkNotNull(string2, "Url can't be null!");
        return this.getCacheFile(string2).exists();
    }

    public void shutdown() {
        block3: {
            HttpProxyCacheServer httpProxyCacheServer = this;
            LOG.info("Shutdown proxy server");
            httpProxyCacheServer.shutdownClients();
            httpProxyCacheServer.config.sourceInfoStorage.release();
            httpProxyCacheServer.waitConnectionThread.interrupt();
            if (httpProxyCacheServer.serverSocket.isClosed()) break block3;
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                this.onError(new ProxyCacheException("Error shutting down proxy server", iOException));
            }
        }
    }

    public File getCacheFile(String string) {
        Config config = ((HttpProxyCacheServer)((Object)file)).config;
        File file = config.cacheRoot;
        string = config.fileNameGenerator.generate(string);
        return new File(file, string);
    }

    public File getTempCacheFile(String string) {
        File file = ((HttpProxyCacheServer)((Object)string2)).config.cacheRoot;
        String string2 = ((HttpProxyCacheServer)((Object)string2)).config.fileNameGenerator.generate(string) + ".download";
        return new File(file, string2);
    }

    public File getCacheRoot() {
        return this.config.cacheRoot;
    }

    public static final class Builder {
        public static final long DEFAULT_MAX_SIZE = 0x20000000L;
        public File cacheRoot;
        public FileNameGenerator fileNameGenerator;
        public DiskUsage diskUsage;
        public SourceInfoStorage sourceInfoStorage;
        public HeaderInjector headerInjector;

        public Builder(Context context) {
            Builder builder = this;
            this.sourceInfoStorage = SourceInfoStorageFactory.newSourceInfoStorage(context);
            builder.cacheRoot = StorageUtils.getIndividualCacheDirectory(context);
            builder.diskUsage = new TotalSizeLruDiskUsage(0x20000000L);
            builder.fileNameGenerator = new Md5FileNameGenerator();
            builder.headerInjector = new EmptyHeadersInjector();
        }

        private Config buildConfig() {
            return new Config(this.cacheRoot, this.fileNameGenerator, this.diskUsage, this.sourceInfoStorage, this.headerInjector);
        }

        public Builder cacheDirectory(File file) {
            this.cacheRoot = Preconditions.checkNotNull(file);
            return this;
        }

        public Builder fileNameGenerator(FileNameGenerator fileNameGenerator) {
            this.fileNameGenerator = Preconditions.checkNotNull(fileNameGenerator);
            return this;
        }

        public Builder maxCacheSize(long l) {
            this.diskUsage = new TotalSizeLruDiskUsage(l);
            return this;
        }

        public Builder maxCacheFilesCount(int n) {
            this.diskUsage = new TotalCountLruDiskUsage(n);
            return this;
        }

        public Builder diskUsage(DiskUsage diskUsage) {
            this.diskUsage = Preconditions.checkNotNull(diskUsage);
            return this;
        }

        public Builder headerInjector(HeaderInjector headerInjector) {
            this.headerInjector = Preconditions.checkNotNull(headerInjector);
            return this;
        }

        public HttpProxyCacheServer build() {
            Config config = ((Builder)((Object)config)).buildConfig();
            return new HttpProxyCacheServer(config, null);
        }
    }

    private final class SocketProcessorRunnable
    implements Runnable {
        public final Socket socket;

        public SocketProcessorRunnable(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            HttpProxyCacheServer.this.processSocket(this.socket);
        }
    }

    private final class WaitRequestsRunnable
    implements Runnable {
        public final CountDownLatch startSignal;

        public WaitRequestsRunnable(CountDownLatch countDownLatch) {
            this.startSignal = countDownLatch;
        }

        @Override
        public void run() {
            WaitRequestsRunnable waitRequestsRunnable = this;
            waitRequestsRunnable.startSignal.countDown();
            waitRequestsRunnable.HttpProxyCacheServer.this.waitForRequest();
        }
    }
}

