/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.alimm.tanx.ui.player.cache.videocache.CacheListener;
import com.alimm.tanx.ui.player.cache.videocache.Config;
import com.alimm.tanx.ui.player.cache.videocache.GetRequest;
import com.alimm.tanx.ui.player.cache.videocache.HttpProxyCache;
import com.alimm.tanx.ui.player.cache.videocache.HttpUrlSource;
import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.file.FileCache;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public final class HttpProxyCacheServerClients {
    public final AtomicInteger clientsCount;
    public final String url;
    public volatile HttpProxyCache proxyCache;
    public final List<CacheListener> listeners;
    public final CacheListener uiCacheListener;
    public final Config config;

    public HttpProxyCacheServerClients(String string, Config config) {
        HttpProxyCacheServerClients httpProxyCacheServerClients = this;
        this.clientsCount = new AtomicInteger(0);
        this.listeners = new CopyOnWriteArrayList<CacheListener>();
        this.url = Preconditions.checkNotNull(string);
        httpProxyCacheServerClients.config = Preconditions.checkNotNull(config);
        httpProxyCacheServerClients.uiCacheListener = new UiListenerHandler(string, this.listeners);
    }

    private synchronized void startProcessRequest() throws ProxyCacheException {
        HttpProxyCache httpProxyCache = this.proxyCache == null ? this.newHttpProxyCache() : this.proxyCache;
        this.proxyCache = httpProxyCache;
    }

    private synchronized void finishProcessRequest() {
        if (this.clientsCount.decrementAndGet() <= 0) {
            this.proxyCache.shutdown();
            this.proxyCache = null;
        }
    }

    private HttpProxyCache newHttpProxyCache() throws ProxyCacheException {
        FileCache fileCache;
        HttpUrlSource httpUrlSource;
        HttpUrlSource httpUrlSource2 = httpUrlSource;
        Object object = this.config;
        httpUrlSource = new HttpUrlSource(this.url, ((Config)object).sourceInfoStorage, ((Config)object).headerInjector);
        object = fileCache;
        fileCache = new FileCache(this.config.generateCacheFile(this.url), this.config.diskUsage);
        HttpProxyCache httpProxyCache = new HttpProxyCache(httpUrlSource2, (FileCache)object);
        httpProxyCache.registerCacheListener(this.uiCacheListener);
        return httpProxyCache;
    }

    public void processRequest(GetRequest getRequest, Socket socket) throws ProxyCacheException, IOException {
        HttpProxyCacheServerClients httpProxyCacheServerClients = this;
        httpProxyCacheServerClients.startProcessRequest();
        try {
            httpProxyCacheServerClients.clientsCount.incrementAndGet();
            httpProxyCacheServerClients.proxyCache.processRequest(getRequest, socket);
            httpProxyCacheServerClients.finishProcessRequest();
            return;
        }
        catch (Throwable throwable) {
            this.finishProcessRequest();
            throw throwable;
        }
    }

    public void registerCacheListener(CacheListener cacheListener) {
        this.listeners.add(cacheListener);
    }

    public void unregisterCacheListener(CacheListener cacheListener) {
        this.listeners.remove(cacheListener);
    }

    public void shutdown() {
        HttpProxyCacheServerClients httpProxyCacheServerClients = this;
        httpProxyCacheServerClients.listeners.clear();
        if (httpProxyCacheServerClients.proxyCache != null) {
            HttpProxyCacheServerClients httpProxyCacheServerClients2 = this;
            httpProxyCacheServerClients2.proxyCache.registerCacheListener(null);
            httpProxyCacheServerClients2.proxyCache.shutdown();
            httpProxyCacheServerClients2.proxyCache = null;
        }
        this.clientsCount.set(0);
    }

    public int getClientsCount() {
        return this.clientsCount.get();
    }

    private static final class UiListenerHandler
    extends Handler
    implements CacheListener {
        public final String url;
        public final List<CacheListener> listeners;

        public UiListenerHandler(String string, List<CacheListener> list) {
            super(Looper.getMainLooper());
            this.url = string;
            this.listeners = list;
        }

        @Override
        public void onCacheAvailable(File file, String string, int n) {
            UiListenerHandler uiListenerHandler = this;
            uiListenerHandler.obtainMessage().arg1 = n;
            uiListenerHandler.obtainMessage().obj = file;
            uiListenerHandler.sendMessage(uiListenerHandler.obtainMessage());
        }

        public void handleMessage(Message message) {
            Iterator<CacheListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onCacheAvailable((File)message.obj, this.url, message.arg1);
            }
        }
    }
}

