/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import android.text.TextUtils;
import com.alimm.tanx.ui.player.cache.videocache.InterruptedProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheUtils;
import com.alimm.tanx.ui.player.cache.videocache.Source;
import com.alimm.tanx.ui.player.cache.videocache.SourceInfo;
import com.alimm.tanx.ui.player.cache.videocache.headers.EmptyHeadersInjector;
import com.alimm.tanx.ui.player.cache.videocache.headers.HeaderInjector;
import com.alimm.tanx.ui.player.cache.videocache.log.Logger;
import com.alimm.tanx.ui.player.cache.videocache.log.LoggerFactory;
import com.alimm.tanx.ui.player.cache.videocache.sourcestorage.SourceInfoStorage;
import com.alimm.tanx.ui.player.cache.videocache.sourcestorage.SourceInfoStorageFactory;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class HttpUrlSource
implements Source {
    public static final Logger LOG = LoggerFactory.getLogger("HttpUrlSource");
    public static final int MAX_REDIRECTS = 5;
    public final SourceInfoStorage sourceInfoStorage;
    public final HeaderInjector headerInjector;
    public SourceInfo sourceInfo;
    public HttpURLConnection connection;
    public InputStream inputStream;

    public HttpUrlSource(String string) {
        this(string, SourceInfoStorageFactory.newEmptySourceInfoStorage());
    }

    public HttpUrlSource(String string, SourceInfoStorage sourceInfoStorage) {
        this(string, sourceInfoStorage, new EmptyHeadersInjector());
    }

    public HttpUrlSource(String string, SourceInfoStorage object, HeaderInjector headerInjector) {
        this.sourceInfoStorage = Preconditions.checkNotNull(object);
        this.headerInjector = Preconditions.checkNotNull(headerInjector);
        object = object.get(string);
        if (object == null) {
            SourceInfo sourceInfo;
            object = sourceInfo;
            String string2 = string;
            string = ProxyCacheUtils.getSupposablyMime(string2);
            sourceInfo = new SourceInfo(string2, Integer.MIN_VALUE, string);
        }
        this.sourceInfo = object;
    }

    public HttpUrlSource(HttpUrlSource httpUrlSource) {
        this.sourceInfo = httpUrlSource.sourceInfo;
        this.sourceInfoStorage = httpUrlSource.sourceInfoStorage;
        this.headerInjector = httpUrlSource.headerInjector;
    }

    private long readSourceAvailableBytes(HttpURLConnection httpURLConnection, long l, int n) throws IOException {
        long l2 = this.getContentLength(httpURLConnection);
        if (n != 200) {
            l2 = n == 206 ? (l2 += l) : this.sourceInfo.length;
        }
        return l2;
    }

    private long getContentLength(HttpURLConnection httpURLConnection) {
        String string = httpURLConnection.getHeaderField("Content-Length");
        return string == null ? -1L : Long.parseLong(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fetchContentInfo() throws ProxyCacheException {
        void var0_5;
        InputStream inputStream;
        Object object;
        block12: {
            Object object2;
            block13: {
                String[] stringArray;
                Logger logger;
                InputStream inputStream2;
                long l;
                Object object3;
                HttpURLConnection httpURLConnection;
                HttpURLConnection httpURLConnection2;
                LOG.debug("Read content info from " + this.sourceInfo.url);
                object = null;
                InputStream inputStream22 = null;
                try {
                    HttpURLConnection httpURLConnection3 = this.openConnection(0L, 10000);
                    httpURLConnection2 = httpURLConnection3;
                    httpURLConnection = httpURLConnection3;
                    object3 = object2 = httpURLConnection3;
                }
                catch (Throwable throwable) {
                    inputStream = inputStream22;
                    break block12;
                }
                catch (IOException iOException) {
                    inputStream = inputStream22;
                    break block13;
                }
                try {
                    l = this.getContentLength((HttpURLConnection)object2);
                    object = httpURLConnection2.getContentType();
                    inputStream2 = inputStream = httpURLConnection.getInputStream();
                }
                catch (Throwable throwable) {
                    object = object2;
                    inputStream = inputStream22;
                    break block12;
                }
                catch (IOException iOException) {
                    object = object2;
                    inputStream = inputStream22;
                    object2 = iOException;
                    break block13;
                }
                try {
                    this.sourceInfo = new SourceInfo(this.sourceInfo.url, l, (String)object);
                    this.sourceInfoStorage.put(this.sourceInfo.url, this.sourceInfo);
                    logger = LOG;
                    stringArray = new String[1];
                }
                catch (Throwable throwable) {
                    object = object2;
                    break block12;
                }
                catch (IOException iOException) {
                    object = object2;
                    object2 = iOException;
                    break block13;
                }
                {
                    stringArray[0] = "Source info fetched: " + this.sourceInfo;
                    logger.debug(stringArray);
                }
                ProxyCacheUtils.close(inputStream2);
                if (object3 == null) return;
                ((HttpURLConnection)object2).disconnect();
                return;
            }
            try {
                LOG.error("Error fetching info from " + this.sourceInfo.url, (Throwable)object2);
                ProxyCacheUtils.close(inputStream);
                if (object == null) return;
                ((HttpURLConnection)object).disconnect();
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ProxyCacheUtils.close(inputStream);
        if (object == null) throw var0_5;
        ((HttpURLConnection)object).disconnect();
        throw var0_5;
    }

    private HttpURLConnection openConnection(long l, int n) throws IOException, ProxyCacheException {
        int n2;
        block4: {
            Object object;
            int n3;
            n2 = 0;
            String string = this.sourceInfo.url;
            do {
                object = LOG;
                String[] stringArray = new String[1];
                int n4 = 0;
                StringBuilder stringBuilder = new StringBuilder().append("Open connection ");
                long l2 = l - 0L;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                String string2 = l3 > 0 ? " with offset " + l : "";
                stringArray[n4] = stringBuilder.append(string2).append(" to ").append(string).toString();
                ((Logger)object).debug(stringArray);
                object = (HttpURLConnection)new URL(string).openConnection();
                this.injectCustomHeaders((HttpURLConnection)object, string);
                if (l3 > 0) {
                    ((URLConnection)object).setRequestProperty("Range", "bytes=" + l + "-");
                }
                if (n > 0) {
                    ((URLConnection)object).setConnectTimeout(n);
                    ((URLConnection)object).setReadTimeout(n);
                }
                n3 = (n3 = ((HttpURLConnection)object).getResponseCode()) != 301 && n3 != 302 && n3 != 303 ? 0 : 1;
                if (n3 != 0) {
                    Object object2 = object;
                    string = ((URLConnection)object2).getHeaderField("Location");
                    ++n2;
                    ((HttpURLConnection)object2).disconnect();
                }
                if (n2 > 5) break block4;
            } while (n3 != 0);
            return object;
        }
        throw new ProxyCacheException("Too many redirects: " + n2);
    }

    private void injectCustomHeaders(HttpURLConnection httpURLConnection, String object2) {
        for (Map.Entry entry : ((HttpUrlSource)this).headerInjector.addHeaders((String)object2).entrySet()) {
            httpURLConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public synchronized long length() throws ProxyCacheException {
        if (this.sourceInfo.length == Integer.MIN_VALUE) {
            this.fetchContentInfo();
        }
        return this.sourceInfo.length;
    }

    @Override
    public void open(long l) throws ProxyCacheException {
        InputStream inputStream;
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2;
        String string;
        HttpUrlSource httpUrlSource = this;
        try {
            BufferedInputStream bufferedInputStream3;
            httpUrlSource.connection = httpUrlSource.openConnection(l, -1);
            string = httpUrlSource.connection.getContentType();
            bufferedInputStream2 = bufferedInputStream3;
            bufferedInputStream = bufferedInputStream3;
            inputStream = this.connection.getInputStream();
        }
        catch (IOException iOException) {
            throw new ProxyCacheException("Error opening connection for " + this.sourceInfo.url + " with offset " + l, iOException);
        }
        bufferedInputStream2(inputStream, 8192);
        httpUrlSource.inputStream = bufferedInputStream;
        long l2 = httpUrlSource.readSourceAvailableBytes(httpUrlSource.connection, l, this.connection.getResponseCode());
        httpUrlSource.sourceInfo = new SourceInfo(this.sourceInfo.url, l2, string);
        httpUrlSource.sourceInfoStorage.put(this.sourceInfo.url, this.sourceInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws ProxyCacheException {
        block5: {
            HttpURLConnection httpURLConnection = ((HttpUrlSource)((Object)httpURLConnection)).connection;
            if (httpURLConnection != null) {
                void var0_4;
                try {
                    httpURLConnection.disconnect();
                    break block5;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    LOG.error("Error closing connection correctly. Should happen only on Android L. If anybody know how to fix it, please visit https://github.com/danikula/AndroidVideoCache/issues/88. Until good solution is not know, just ignore this issue :(", arrayIndexOutOfBoundsException);
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                throw new RuntimeException("Wait... but why? WTF!? Really shouldn't happen any more after fixing https://github.com/danikula/AndroidVideoCache/issues/43. If you read it on your device log, please, notify me danikula@gmail.com or create issue here https://github.com/danikula/AndroidVideoCache/issues.", (Throwable)var0_4);
            }
        }
    }

    @Override
    public int read(byte[] byArray) throws ProxyCacheException {
        InputStream inputStream = this.inputStream;
        if (inputStream != null) {
            try {
                return inputStream.read(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new ProxyCacheException("Error reading data from " + this.sourceInfo.url, iOException);
            }
            catch (InterruptedIOException interruptedIOException) {
                throw new InterruptedProxyCacheException("Reading source " + this.sourceInfo.url + " is interrupted", interruptedIOException);
            }
        }
        throw new ProxyCacheException("Error reading data from " + this.sourceInfo.url + ": connection is absent!");
    }

    public synchronized String getMime() throws ProxyCacheException {
        if (TextUtils.isEmpty((CharSequence)this.sourceInfo.mime)) {
            this.fetchContentInfo();
        }
        return this.sourceInfo.mime;
    }

    public String getUrl() {
        return this.sourceInfo.url;
    }

    public String toString() {
        return "HttpUrlSource{sourceInfo='" + this.sourceInfo + "}";
    }
}

