/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

public class IgnoreHostProxySelector
extends ProxySelector {
    public static final List<Proxy> NO_PROXY_LIST = Arrays.asList(Proxy.NO_PROXY);
    public final ProxySelector defaultProxySelector;
    public final String hostToIgnore;
    public final int portToIgnore;

    public IgnoreHostProxySelector(ProxySelector proxySelector, String string, int n) {
        this.defaultProxySelector = Preconditions.checkNotNull(proxySelector);
        this.hostToIgnore = Preconditions.checkNotNull(string);
        this.portToIgnore = n;
    }

    public static void install(String string, int n) {
        ProxySelector proxySelector = ProxySelector.getDefault();
        ProxySelector.setDefault(new IgnoreHostProxySelector(proxySelector, string, n));
    }

    @Override
    public List<Proxy> select(URI uRI) {
        return this.hostToIgnore.equals(uRI.getHost()) && this.portToIgnore == uRI.getPort() ? NO_PROXY_LIST : this.defaultProxySelector.select(uRI);
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        this.defaultProxySelector.connectFailed(uRI, socketAddress, iOException);
    }
}

