/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import com.alimm.tanx.ui.player.cache.videocache.HttpUrlSource;
import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.log.Logger;
import com.alimm.tanx.ui.player.cache.videocache.log.LoggerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Pinger {
    public static final Logger LOG = LoggerFactory.getLogger("Pinger");
    public static final String PING_REQUEST = "ping";
    public static final String PING_RESPONSE = "ping ok";
    public final ExecutorService pingExecutor = Executors.newSingleThreadExecutor();
    public final String host;
    public final int port;

    public Pinger(String string, int n) {
        this.host = Preconditions.checkNotNull(string);
        this.port = n;
    }

    private List<Proxy> getDefaultProxies() {
        try {
            return ProxySelector.getDefault().select(new URI(this.getPingUrl()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean pingServer() throws ProxyCacheException {
        Throwable throwable2;
        HttpUrlSource httpUrlSource2;
        block6: {
            boolean bl;
            HttpUrlSource httpUrlSource2;
            Object object = ((Pinger)object).getPingUrl();
            httpUrlSource2 = httpUrlSource2;
            httpUrlSource2 = new HttpUrlSource((String)object);
            byte[] byArray = PING_RESPONSE.getBytes();
            {
                catch (Throwable throwable2) {
                    break block6;
                }
                catch (ProxyCacheException proxyCacheException) {}
                {
                    LOG.error("Error reading ping response", proxyCacheException);
                    httpUrlSource2.close();
                    return false;
                }
            }
            {
                boolean bl2;
                httpUrlSource2.open(0L);
                byte[] byArray2 = new byte[byArray.length];
                object = byArray2;
                httpUrlSource2.read((byte[])object);
                bl = bl2 = Arrays.equals(byArray, byArray2);
                {
                    LOG.info("Ping response: `" + new String((byte[])object) + "`, pinged? " + bl2);
                }
                httpUrlSource2.close();
            }
            return bl;
        }
        httpUrlSource2.close();
        throw throwable2;
    }

    private String getPingUrl() {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.host;
        objectArray[1] = this.port;
        objectArray[2] = PING_REQUEST;
        return String.format(Locale.US, "http://%s:%d/%s", objectArray2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ping(int n, int n2) {
        Preconditions.checkArgument(n >= 1);
        Preconditions.checkArgument(n2 > 0);
        int n3 = 0;
        while (true) {
            block9: {
                void var4_5;
                block8: {
                    ExecutorService executorService;
                    String string;
                    if (n3 >= n) {
                        Object[] objectArray = new Object[3];
                        Object[] objectArray2 = objectArray;
                        objectArray2[0] = n3;
                        objectArray2[1] = n2 / 2;
                        objectArray[2] = ((Pinger)((Object)string)).getDefaultProxies();
                        string = String.format(Locale.US, "Error pinging server (attempts: %d, max timeout: %d). If you see this message, please, report at https://github.com/danikula/AndroidVideoCache/issues/134. Default proxies are: %s", objectArray2);
                        LOG.error(string, new ProxyCacheException(string));
                        return false;
                    }
                    try {
                        executorService = ((Pinger)((Object)string)).pingExecutor;
                    }
                    catch (ExecutionException executionException) {
                        break block8;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break block8;
                    }
                    catch (TimeoutException timeoutException) {
                        LOG.warn("Error pinging server (attempt: " + n3 + ", timeout: " + n2 + "). ");
                        break block9;
                    }
                    {
                        if (executorService.submit((Pinger)((Object)string).new PingCallable(null)).get(n2, TimeUnit.MILLISECONDS).booleanValue()) {
                            return true;
                        }
                        break block9;
                    }
                }
                LOG.error("Error pinging server due to unexpected error", (Throwable)var4_5);
            }
            ++n3;
            n2 *= 2;
        }
    }

    public boolean isPingRequest(String string) {
        return PING_REQUEST.equals(string);
    }

    public void responseToPing(Socket socket) throws IOException {
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write("HTTP/1.1 200 OK\n\n".getBytes());
        outputStream.write(PING_RESPONSE.getBytes());
    }

    private class PingCallable
    implements Callable<Boolean> {
        public PingCallable() {
        }

        public /* synthetic */ PingCallable(1 var2_2) {
            this();
        }

        @Override
        public Boolean call() throws Exception {
            return Pinger.this.pingServer();
        }
    }
}

