/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import com.alimm.tanx.ui.player.cache.videocache.Cache;
import com.alimm.tanx.ui.player.cache.videocache.InterruptedProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheUtils;
import com.alimm.tanx.ui.player.cache.videocache.Source;
import com.alimm.tanx.ui.player.cache.videocache.log.Logger;
import com.alimm.tanx.ui.player.cache.videocache.log.LoggerFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ProxyCache {
    public static final Logger LOG = LoggerFactory.getLogger("ProxyCache");
    public static final int MAX_READ_SOURCE_ATTEMPTS = 1;
    public final Source source;
    public final Cache cache;
    public final Object wc;
    public final Object stopLock;
    public final AtomicInteger readSourceErrorsCount;
    public volatile Thread sourceReaderThread;
    public volatile boolean stopped;
    public volatile int percentsAvailable;

    public ProxyCache(Source source, Cache cache) {
        ProxyCache proxyCache = this;
        this.wc = new Object();
        this.stopLock = new Object();
        this.percentsAvailable = -1;
        this.source = Preconditions.checkNotNull(source);
        proxyCache.cache = Preconditions.checkNotNull(cache);
        proxyCache.readSourceErrorsCount = new AtomicInteger();
    }

    private void checkReadSourceErrorsCount() throws ProxyCacheException {
        int n = this.readSourceErrorsCount.get();
        if (n < 1) {
            return;
        }
        this.readSourceErrorsCount.set(0);
        throw new ProxyCacheException("Error reading source " + n + " times");
    }

    private synchronized void readSourceAsync() throws ProxyCacheException {
        LOG.info("\u4e00\u6b65\u8bfb\u53d6\u7f51\u7edc\u6570\u636e");
        boolean bl = this.sourceReaderThread != null && this.sourceReaderThread.getState() != Thread.State.TERMINATED;
        if (!(this.stopped || this.cache.isCompleted() || bl)) {
            this.sourceReaderThread = new Thread((Runnable)new SourceReaderRunnable(null), "Source reader for " + this.source);
            this.sourceReaderThread.start();
        }
    }

    /*
     * Exception decompiling
     */
    private void waitForSourceData() throws ProxyCacheException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 24->27)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNewCacheDataAvailable(long l, long l2) {
        ProxyCache proxyCache = this;
        proxyCache.onCacheAvailable(l, l2);
        Object object = proxyCache.wc;
        synchronized (object) {
            this.wc.notifyAll();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private void readSource() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: non catch before exception catch block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2354)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void onSourceRead() {
        ProxyCache proxyCache = this;
        proxyCache.percentsAvailable = 100;
        proxyCache.onCachePercentsAvailableChanged(proxyCache.percentsAvailable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void tryComplete() throws ProxyCacheException {
        ProxyCache proxyCache = this;
        Object object = proxyCache.stopLock;
        synchronized (object) {
            if (!proxyCache.isStopped() && this.cache.available() == this.source.length()) {
                this.cache.complete();
            }
            return;
        }
    }

    private boolean isStopped() {
        return Thread.currentThread().isInterrupted() || this.stopped;
    }

    private void closeSource() {
        try {
            this.source.close();
        }
        catch (ProxyCacheException proxyCacheException) {
            this.onError(new ProxyCacheException("Error closing source " + this.source, proxyCacheException));
        }
    }

    public int read(byte[] byArray, long l, int n) throws ProxyCacheException {
        ProxyCacheUtils.assertBuffer(byArray, l, n);
        while (!this.cache.isCompleted() && this.cache.available() < l + (long)n && !this.stopped) {
            ProxyCache proxyCache = this;
            proxyCache.readSourceAsync();
            proxyCache.waitForSourceData();
            proxyCache.checkReadSourceErrorsCount();
        }
        ProxyCache proxyCache = this;
        LOG.info("\u5f00\u59cb\u4ece\u7f13\u5b58\u4e2d\u8bfb\u53d6\u6570\u636e");
        int n2 = proxyCache.cache.read(byArray, l, n);
        if (proxyCache.cache.isCompleted() && this.percentsAvailable != 100) {
            this.percentsAvailable = 100;
            this.onCachePercentsAvailableChanged(100);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        ProxyCache proxyCache = this;
        Object object = proxyCache.stopLock;
        synchronized (object) {
            Logger logger = LOG;
            String[] stringArray = new String[1];
            {
                stringArray[0] = "Shutdown proxy for " + this.source;
                logger.info(stringArray);
                try {
                    proxyCache.stopped = true;
                    if (proxyCache.sourceReaderThread != null) {
                        this.sourceReaderThread.interrupt();
                    }
                    this.cache.close();
                }
                catch (ProxyCacheException proxyCacheException) {
                    this.onError(proxyCacheException);
                }
                return;
            }
        }
    }

    public void onCacheAvailable(long l, long l2) {
        long l3 = l2 - 0L;
        long l4 = l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
        int n = l4 == false ? 100 : (int)((float)l / (float)l2 * 100.0f);
        boolean bl = n != this.percentsAvailable;
        if (l4 >= 0 && bl) {
            this.onCachePercentsAvailableChanged(n);
        }
        this.percentsAvailable = n;
    }

    public void onCachePercentsAvailableChanged(int n) {
    }

    public final void onError(Throwable throwable) {
        if (throwable instanceof InterruptedProxyCacheException) {
            LOG.debug("ProxyCache is interrupted");
        } else {
            LOG.error("ProxyCache error", throwable);
        }
    }

    private class SourceReaderRunnable
    implements Runnable {
        public SourceReaderRunnable() {
        }

        public /* synthetic */ SourceReaderRunnable(1 var2_2) {
            this();
        }

        @Override
        public void run() {
            ProxyCache.this.readSource();
        }
    }
}

