/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.alimm.tanx.ui.player.cache.videocache.Preconditions;
import com.alimm.tanx.ui.player.cache.videocache.log.Logger;
import com.alimm.tanx.ui.player.cache.videocache.log.LoggerFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class ProxyCacheUtils {
    public static final Logger LOG = LoggerFactory.getLogger("ProxyCacheUtils");
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int MAX_ARRAY_PREVIEW = 16;

    public static String getSupposablyMime(String string) {
        String string2 = string;
        string = MimeTypeMap.getSingleton();
        String string3 = MimeTypeMap.getFileExtensionFromUrl((String)string2);
        return TextUtils.isEmpty((CharSequence)string3) ? null : string.getMimeTypeFromExtension(string3);
    }

    public static void assertBuffer(byte[] byArray, long l, int n) {
        Preconditions.checkNotNull(byArray, "Buffer must be not null!");
        Preconditions.checkArgument(l >= 0L, "Data offset must be positive!");
        Preconditions.checkArgument(n >= 0 && n <= byArray.length, "Length must be in range [0..buffer.length]");
    }

    public static String preview(byte[] object, int n) {
        int n2 = Math.min(16, Math.max(n, 0));
        object = Arrays.toString(Arrays.copyOfRange((byte[])object, 0, n2));
        if (n2 < n) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            Object object2 = object;
            stringBuilder2();
            object = stringBuilder.append(((String)object2).substring(0, ((String)object2).length() - 1)).append(", ...]").toString();
        }
        return object;
    }

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Error encoding url", unsupportedEncodingException);
        }
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Error decoding url", unsupportedEncodingException);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                LOG.error("Error closing resource", iOException);
            }
        }
    }

    public static String computeMD5(String string) {
        try {
            return ProxyCacheUtils.bytesToHexString(MessageDigest.getInstance("MD5").digest(string.getBytes()));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException(noSuchAlgorithmException);
        }
    }

    public static String bytesToHexString(byte[] byArray) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by;
            stringBuffer2.append(String.format("%02x", objectArray2));
        }
        return stringBuffer2.toString();
    }
}

