/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache;

import android.content.Context;
import android.os.Environment;
import com.alimm.tanx.ui.player.cache.videocache.log.Logger;
import com.alimm.tanx.ui.player.cache.videocache.log.LoggerFactory;
import java.io.File;

public final class StorageUtils {
    public static final Logger LOG = LoggerFactory.getLogger("StorageUtils");
    public static final String INDIVIDUAL_DIR_NAME = "video-cache";

    public static File getIndividualCacheDirectory(Context object) {
        object = StorageUtils.getCacheDirectory(object, true);
        return new File((File)object, INDIVIDUAL_DIR_NAME);
    }

    public static File getCacheDirectory(Context object, boolean bl) {
        String string;
        File file = null;
        try {
            string = Environment.getExternalStorageState();
        }
        catch (NullPointerException nullPointerException) {
            string = "";
        }
        if (bl && "mounted".equals(string)) {
            file = StorageUtils.getExternalCacheDir(object);
        }
        if (file == null) {
            file = object.getCacheDir();
        }
        if (file == null) {
            File file2;
            object = "/data/data/" + object.getPackageName() + "/cache/";
            LOG.warn("Can't define system cache directory! '" + (String)object + "%s' will be used.");
            file = file2;
            file2 = new File((String)object);
        }
        return file;
    }

    public static File getExternalCacheDir(Context context) {
        File file;
        File file2;
        File file3 = file2;
        file2 = new File(new File(Environment.getExternalStorageDirectory(), "Android"), "data");
        File file4 = file;
        if (!new File(new File(file3, context.getPackageName()), "cache").exists() && !file4.mkdirs()) {
            LOG.warn("Unable to create external cache directory");
            return null;
        }
        return file4;
    }

    public static boolean deleteFiles(File fileArray) {
        if ((fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (file.isDirectory() || !file.exists() || file.delete()) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean deleteFile(String string) {
        File file;
        File file2 = file;
        if (new File(string).exists()) {
            if (file2.isFile()) {
                return file2.delete();
            }
            String[] stringArray = file2.list();
            if (stringArray != null) {
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    StorageUtils.deleteFile(string + File.separator + stringArray[i]);
                }
            }
            return file2.delete();
        }
        return true;
    }
}

