/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache.file;

import com.alimm.tanx.ui.player.cache.videocache.Cache;
import com.alimm.tanx.ui.player.cache.videocache.ProxyCacheException;
import com.alimm.tanx.ui.player.cache.videocache.file.DiskUsage;
import com.alimm.tanx.ui.player.cache.videocache.file.Files;
import com.alimm.tanx.ui.player.cache.videocache.file.UnlimitedDiskUsage;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileCache
implements Cache {
    public static final String TEMP_POSTFIX = ".download";
    public final DiskUsage diskUsage;
    public File file;
    public RandomAccessFile dataFile;

    public FileCache(File file) throws ProxyCacheException {
        this(file, new UnlimitedDiskUsage());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileCache(File file, DiskUsage diskUsage) throws ProxyCacheException {
        if (diskUsage == null) throw new NullPointerException();
        try {
            RandomAccessFile randomAccessFile;
            File file2;
            File file3 = file;
            this.diskUsage = diskUsage;
            Files.makeDir(file3.getParentFile());
            boolean bl = file3.exists();
            if (bl) {
                file2 = file;
            } else {
                File file4;
                file2 = file4;
                file4 = new File(file.getParentFile(), file.getName() + TEMP_POSTFIX);
            }
            file2 = this.file = file2;
            String string = bl ? "r" : "rw";
            RandomAccessFile randomAccessFile2 = randomAccessFile;
            randomAccessFile2(file2, string);
            this.dataFile = randomAccessFile2;
            return;
        }
        catch (IOException iOException) {
            throw new ProxyCacheException("Error using file " + file + " as disc cache", iOException);
        }
    }

    private boolean isTempFile(File file) {
        return file.getName().endsWith(TEMP_POSTFIX);
    }

    @Override
    public synchronized long available() throws ProxyCacheException {
        try {
            return (int)this.dataFile.length();
        }
        catch (IOException iOException) {
            throw new ProxyCacheException("Error reading length of file " + this.file, iOException);
        }
    }

    @Override
    public synchronized int read(byte[] byArray, long l, int n) throws ProxyCacheException {
        RandomAccessFile randomAccessFile;
        try {
            FileCache fileCache = this;
            fileCache.dataFile.seek(l);
            randomAccessFile = fileCache.dataFile;
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[4];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n;
            objectArray2[1] = l;
            objectArray2[2] = this.available();
            objectArray[3] = byArray.length;
            throw new ProxyCacheException(String.format("Error reading %d bytes with offset %d from file[%d bytes] to buffer[%d bytes]", objectArray2), iOException);
        }
        return randomAccessFile.read(byArray, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void append(byte[] byArray, int n) throws ProxyCacheException {
        try {
            if (!this.isCompleted()) {
                FileCache fileCache = this;
                fileCache.dataFile.seek(this.available());
                fileCache.dataFile.write(byArray, 0, n);
                return;
            }
            throw new ProxyCacheException("Error append cache: cache file " + this.file + " is completed!");
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[3];
            Object[] objectArray2 = objectArray;
            objectArray2[0] = n;
            objectArray2[1] = this.dataFile;
            objectArray[2] = byArray.length;
            throw new ProxyCacheException(String.format("Error writing %d bytes to %s from buffer with size %d", objectArray2), iOException);
        }
    }

    @Override
    public synchronized void close() throws ProxyCacheException {
        try {
            FileCache fileCache = this;
            fileCache.dataFile.close();
            fileCache.diskUsage.touch(this.file);
            return;
        }
        catch (IOException iOException) {
            throw new ProxyCacheException("Error closing file " + this.file, iOException);
        }
    }

    @Override
    public synchronized void complete() throws ProxyCacheException {
        File file;
        if (this.isCompleted()) {
            return;
        }
        FileCache fileCache = this;
        fileCache.close();
        String string = fileCache.file.getName().substring(0, this.file.getName().length() - 9);
        File file2 = file;
        file = new File(this.file.getParentFile(), string);
        if (fileCache.file.renameTo(file2)) {
            File file3;
            RandomAccessFile randomAccessFile;
            RandomAccessFile randomAccessFile2;
            this.file = file2;
            try {
                RandomAccessFile randomAccessFile3;
                randomAccessFile2 = randomAccessFile3;
                randomAccessFile = randomAccessFile3;
                file3 = this.file;
            }
            catch (IOException iOException) {
                throw new ProxyCacheException("Error opening " + this.file + " as disc cache", iOException);
            }
            randomAccessFile2(file3, "r");
            this.dataFile = randomAccessFile;
            this.diskUsage.touch(this.file);
            return;
        }
        throw new ProxyCacheException("Error renaming file " + this.file + " to " + file2 + " for completion!");
    }

    @Override
    public synchronized boolean isCompleted() {
        FileCache fileCache = this;
        return fileCache.isTempFile(fileCache.file) ^ true;
    }

    public File getFile() {
        return this.file;
    }
}

