/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache.file;

import com.alimm.tanx.ui.player.cache.videocache.log.Logger;
import com.alimm.tanx.ui.player.cache.videocache.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class Files {
    public static final Logger LOG = LoggerFactory.getLogger("Files");

    public static void makeDir(File file) throws IOException {
        block7: {
            block6: {
                block5: {
                    if (!file.exists()) break block5;
                    if (!file.isDirectory()) {
                        throw new IOException("File " + file + " is not directory!");
                    }
                    break block6;
                }
                if (!file.mkdirs()) break block7;
            }
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = file.getAbsolutePath();
        throw new IOException(String.format("Directory %s can't be created", objectArray2));
    }

    public static List<File> getLruListFiles(File object) {
        LinkedList linkedList;
        File file = object;
        object = linkedList;
        linkedList = new LinkedList();
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            object = Arrays.asList(fileArray);
            Collections.sort(object, new LastModifiedComparator(null));
        }
        return object;
    }

    public static void setLastModifiedNow(File file) throws IOException {
        long l;
        if (file.exists() && !file.setLastModified(l = System.currentTimeMillis())) {
            File file2 = file;
            Files.modify(file2);
            if (file2.lastModified() < l) {
                LOG.warn("Last modified date {} is not set for file {}", new Date(file.lastModified()).toString(), file.getAbsolutePath());
            }
        }
    }

    public static void modify(File file) throws IOException {
        RandomAccessFile randomAccessFile;
        long l = file.length();
        if (l == 0L) {
            Files.recreateZeroSizeFile(file);
            return;
        }
        RandomAccessFile randomAccessFile2 = randomAccessFile;
        randomAccessFile2(file, "rwd");
        randomAccessFile.seek(--l);
        byte by = randomAccessFile.readByte();
        randomAccessFile2.seek(l);
        randomAccessFile.write(by);
        randomAccessFile.close();
    }

    public static void recreateZeroSizeFile(File file) throws IOException {
        if (file.delete() && file.createNewFile()) {
            return;
        }
        throw new IOException("Error recreate zero-size file " + file);
    }

    private static final class LastModifiedComparator
    implements Comparator<File> {
        public LastModifiedComparator() {
        }

        private int compareLong(long l, long l2) {
            long l3 = l == l2 ? 0 : (l < l2 ? -1 : 1);
            return l3 < 0 ? -1 : (l3 == false ? 0 : 1);
        }

        public /* synthetic */ LastModifiedComparator(1 var1_1) {
            this();
        }

        @Override
        public int compare(File file, File file2) {
            return this.compareLong(file.lastModified(), file2.lastModified());
        }
    }
}

