/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.cache.videocache.file;

import com.alimm.tanx.ui.player.cache.videocache.file.DiskUsage;
import com.alimm.tanx.ui.player.cache.videocache.file.Files;
import com.alimm.tanx.ui.player.cache.videocache.log.Logger;
import com.alimm.tanx.ui.player.cache.videocache.log.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class LruDiskUsage
implements DiskUsage {
    public static final Logger LOG = LoggerFactory.getLogger("LruDiskUsage");
    public final ExecutorService workerThread = Executors.newSingleThreadExecutor();

    private void touchInBackground(File file) throws IOException {
        File file2 = file;
        Files.setLastModifiedNow(file2);
        this.trim(Files.getLruListFiles(file2.getParentFile()));
    }

    private void trim(List<File> list) {
        List<File> list2 = list;
        long l = this.countTotalSize(list);
        int n = list2.size();
        for (File file : list2) {
            if (this.accept(file, l, n)) continue;
            File file2 = file;
            long l2 = file2.length();
            if (file2.delete()) {
                --n;
                l -= l2;
                LOG.info("Cache file " + file + " is deleted because it exceeds cache limit");
                continue;
            }
            LOG.error("Error deleting file " + file + " for trimming cache");
        }
    }

    private long countTotalSize(List<File> list) {
        long l = 0L;
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            l += iterator.next().length();
        }
        return l;
    }

    @Override
    public void touch(File file) throws IOException {
        this.workerThread.submit(new TouchCallable(file));
    }

    public abstract boolean accept(File var1, long var2, int var4);

    private class TouchCallable
    implements Callable<Void> {
        public final File file;

        public TouchCallable(File file) {
            this.file = file;
        }

        @Override
        public Void call() throws Exception {
            LruDiskUsage.this.touchInBackground(this.file);
            return null;
        }
    }
}

