/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.core;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.alimm.tanx.core.request.TanxPlayerError;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.ui.player.core.ITanxPlayer;
import com.alimm.tanx.ui.player.core.OnVideoBufferingListener;
import com.alimm.tanx.ui.player.core.OnVideoErrorListener;
import com.alimm.tanx.ui.player.core.OnVideoSizeChangeListener;
import com.alimm.tanx.ui.player.core.OnVideoStateChangeListener;
import com.alimm.tanx.ui.player.core.PlayerBufferingState;
import com.alimm.tanx.ui.player.core.PlayerState;
import java.util.Map;

public class TanxPlayer
implements ITanxPlayer,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnSeekCompleteListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnVideoSizeChangedListener {
    public static final String TAG = "TanxPlayer";
    public MediaPlayer mediaPlayer;
    public boolean playWhenReady;
    public PlayerState playerState;
    public int bufferPercent;
    public OnVideoErrorListener onVideoErrorListener;
    public OnVideoSizeChangeListener onVideoSizeChangeListener;
    public OnVideoStateChangeListener onVideoStateChangeListener;
    public OnVideoBufferingListener onVideoBufferingListener;

    public TanxPlayer() {
        TanxPlayer tanxPlayer = this;
        tanxPlayer.mediaPlayer = new MediaPlayer();
        tanxPlayer.playWhenReady = true;
        tanxPlayer.playerState = PlayerState.IDLE;
        tanxPlayer.mediaPlayer.setScreenOnWhilePlaying(true);
        tanxPlayer.mediaPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        tanxPlayer.mediaPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        tanxPlayer.mediaPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
        tanxPlayer.mediaPlayer.setOnSeekCompleteListener((MediaPlayer.OnSeekCompleteListener)this);
        tanxPlayer.mediaPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        tanxPlayer.mediaPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
        tanxPlayer.mediaPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
    }

    private void setPlayerState(PlayerState playerState) {
        OnVideoStateChangeListener onVideoStateChangeListener;
        PlayerState playerState2 = playerState;
        LogUtils.d((String)TAG, (String)playerState2.name());
        this.playerState = playerState2;
        if (playerState == PlayerState.PREPARED) {
            this.mediaPlayer.setVideoScalingMode(1);
        }
        if ((onVideoStateChangeListener = this.onVideoStateChangeListener) != null) {
            onVideoStateChangeListener.onStateChange(this, playerState);
        }
    }

    @Override
    public void setDataSource(Context context, String string) {
        this.setDataSource(context, Uri.parse((String)string));
    }

    @Override
    public void setDataSource(Context context, Uri uri) {
        this.setDataSource(context, uri, null);
    }

    @Override
    public void setDataSource(Context context, Uri uri, Map<String, String> map) {
        try {
            TanxPlayer tanxPlayer = this;
            tanxPlayer.mediaPlayer.setDataSource(context, uri, map);
            tanxPlayer.setPlayerState(PlayerState.INITIALIZED);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void start() {
        try {
            TanxPlayer tanxPlayer = this;
            tanxPlayer.mediaPlayer.start();
            tanxPlayer.setPlayerState(PlayerState.STARTED);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void prepare() {
        try {
            TanxPlayer tanxPlayer = this;
            tanxPlayer.mediaPlayer.prepare();
            tanxPlayer.setPlayerState(PlayerState.PREPARED);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void prepareAsync() {
        try {
            TanxPlayer tanxPlayer = this;
            tanxPlayer.mediaPlayer.prepareAsync();
            tanxPlayer.setPlayerState(PlayerState.PREPARING);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void pause() {
        try {
            TanxPlayer tanxPlayer = this;
            tanxPlayer.mediaPlayer.pause();
            tanxPlayer.setPlayerState(PlayerState.PAUSED);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void stop() {
        try {
            TanxPlayer tanxPlayer = this;
            tanxPlayer.mediaPlayer.stop();
            tanxPlayer.setPlayerState(PlayerState.STOPPED);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void release() {
        try {
            TanxPlayer tanxPlayer = this;
            tanxPlayer.mediaPlayer.release();
            tanxPlayer.setPlayerState(PlayerState.END);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void reset() {
        try {
            TanxPlayer tanxPlayer = this;
            tanxPlayer.mediaPlayer.reset();
            tanxPlayer.setPlayerState(PlayerState.IDLE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void seekTo(long l) {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mediaPlayer.seekTo(l, 3);
                return;
            }
            this.mediaPlayer.seekTo((int)l);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setPlayWhenReady(boolean bl) {
        this.playWhenReady = bl;
    }

    @Override
    public void setVolume(float f) {
        try {
            float f2 = f;
            this.mediaPlayer.setVolume(f2, f2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setLooping(boolean bl) {
        try {
            this.mediaPlayer.setLooping(bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isPlaying() {
        try {
            return this.mediaPlayer.isPlaying();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isPlayWhenReady() {
        return this.playWhenReady;
    }

    @Override
    public long getCurrentPosition() {
        try {
            return this.mediaPlayer.getCurrentPosition();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    @Override
    public long getDuration() {
        try {
            return this.mediaPlayer.getDuration();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0L;
        }
    }

    @Override
    public int getVideoWidth() {
        try {
            return this.mediaPlayer.getVideoWidth();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    @Override
    public int getVideoHeight() {
        try {
            return this.mediaPlayer.getVideoHeight();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    @Override
    public PlayerState getState() {
        return this.playerState;
    }

    @Override
    public int getBufferPercent() {
        return this.bufferPercent;
    }

    @Override
    public void setSurface(Surface surface) {
        try {
            this.mediaPlayer.setSurface(surface);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setDisplay(SurfaceHolder surfaceHolder) {
        try {
            this.mediaPlayer.setDisplay(surfaceHolder);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void setOnVideoErrorListener(OnVideoErrorListener onVideoErrorListener) {
        this.onVideoErrorListener = onVideoErrorListener;
    }

    @Override
    public void setOnVideoSizeChangeListener(OnVideoSizeChangeListener onVideoSizeChangeListener) {
        this.onVideoSizeChangeListener = onVideoSizeChangeListener;
    }

    @Override
    public void setOnVideoStateChangeListener(OnVideoStateChangeListener onVideoStateChangeListener) {
        this.onVideoStateChangeListener = onVideoStateChangeListener;
    }

    @Override
    public void setOnVideoBufferingStateChangeListener(OnVideoBufferingListener onVideoBufferingListener) {
        this.onVideoBufferingListener = onVideoBufferingListener;
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        this.setPlayerState(PlayerState.PREPARED);
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        this.setPlayerState(PlayerState.COMPLETED);
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.bufferPercent = n;
    }

    public void onSeekComplete(MediaPlayer mediaPlayer) {
    }

    public boolean onError(MediaPlayer object, int n, int n2) {
        TanxPlayer tanxPlayer = this;
        tanxPlayer.setPlayerState(PlayerState.ERROR);
        object = tanxPlayer.onVideoErrorListener;
        if (object != null) {
            object.onError(this, new TanxPlayerError("playerError", n, n2));
        }
        return true;
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        OnVideoBufferingListener onVideoBufferingListener = ((TanxPlayer)((Object)onVideoBufferingListener)).onVideoBufferingListener;
        if (onVideoBufferingListener != null) {
            if (n == 701) {
                onVideoBufferingListener.OnBufferStateChanged(PlayerBufferingState.BUFFERING_START);
            } else {
                onVideoBufferingListener.OnBufferStateChanged(PlayerBufferingState.BUFFERING_END);
            }
        }
        return false;
    }

    public void onVideoSizeChanged(MediaPlayer object, int n, int n2) {
        object = this.onVideoSizeChangeListener;
        if (object != null) {
            object.onVideoSizeChanged(this, n, n2);
        }
    }
}

