/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.core.audio;

import android.content.Context;
import android.media.AudioManager;
import com.alimm.tanx.ui.player.core.ITanxPlayer;
import com.alimm.tanx.ui.player.core.audio.IAudioManager;
import java.lang.ref.WeakReference;

public class DefaultAudioFocusChangeListener
implements AudioManager.OnAudioFocusChangeListener {
    public WeakReference<Context> contextReference;
    public IAudioManager iAudioManager;
    public ITanxPlayer iTanxPlayer;
    public boolean playOnAudioFocus;

    public DefaultAudioFocusChangeListener(WeakReference<Context> weakReference, IAudioManager iAudioManager, ITanxPlayer iTanxPlayer) {
        DefaultAudioFocusChangeListener defaultAudioFocusChangeListener = this;
        this.contextReference = weakReference;
        this.iAudioManager = iAudioManager;
        defaultAudioFocusChangeListener.iTanxPlayer = iTanxPlayer;
        defaultAudioFocusChangeListener.playOnAudioFocus = true;
    }

    public void onAudioFocusChange(int n) {
        if (this.iTanxPlayer == null) {
            return;
        }
        Context context = (Context)this.contextReference.get();
        if (context == null) {
            return;
        }
        if (1 == n) {
            if (this.playOnAudioFocus && !this.iTanxPlayer.isPlaying()) {
                this.iTanxPlayer.start();
            } else if (this.iTanxPlayer.isPlaying()) {
                this.iTanxPlayer.setVolume(this.getCurrentVolume(context));
            }
            this.playOnAudioFocus = false;
        } else if (-3 == n) {
            DefaultAudioFocusChangeListener defaultAudioFocusChangeListener = this;
            float f = (float)defaultAudioFocusChangeListener.getCurrentVolume(context) * 0.8f;
            defaultAudioFocusChangeListener.iTanxPlayer.setVolume(f);
        } else if (-2 == n) {
            if (this.iTanxPlayer.isPlaying()) {
                this.playOnAudioFocus = true;
                this.iTanxPlayer.pause();
            }
        } else if (-1 == n) {
            DefaultAudioFocusChangeListener defaultAudioFocusChangeListener = this;
            defaultAudioFocusChangeListener.iAudioManager.abandonAudioFocus();
            defaultAudioFocusChangeListener.playOnAudioFocus = false;
            defaultAudioFocusChangeListener.iTanxPlayer.stop();
        }
    }

    public int getCurrentVolume(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        int n = audioManager.getStreamVolume(3);
        return (int)((float)n * 1.0f / (float)audioManager.getStreamMaxVolume(3));
    }
}

