/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.core.audio;

import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import com.alimm.tanx.ui.player.core.ITanxPlayer;
import com.alimm.tanx.ui.player.core.audio.DefaultAudioFocusChangeListener;
import com.alimm.tanx.ui.player.core.audio.IAudioManager;
import java.lang.ref.WeakReference;

public class MediaPlayerAudioManager
implements IAudioManager {
    public Context context;
    public ITanxPlayer iTanxPlayer;
    public AudioManager audioManager;
    public AudioAttributes audioAttributes;
    public AudioFocusRequest audioFocusRequest;
    public AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener;

    public MediaPlayerAudioManager(Context context, ITanxPlayer iTanxPlayer) {
        WeakReference<Context> weakReference;
        MediaPlayerAudioManager mediaPlayerAudioManager = this;
        this.context = context;
        this.iTanxPlayer = iTanxPlayer;
        mediaPlayerAudioManager.audioManager = (AudioManager)context.getSystemService("audio");
        mediaPlayerAudioManager.audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(2).build();
        WeakReference<Context> weakReference2 = weakReference;
        weakReference2(context);
        mediaPlayerAudioManager.onAudioFocusChangeListener = new DefaultAudioFocusChangeListener(weakReference, this, iTanxPlayer);
    }

    @Override
    public void mute() {
        ITanxPlayer iTanxPlayer = ((MediaPlayerAudioManager)((Object)iTanxPlayer)).iTanxPlayer;
        if (iTanxPlayer != null) {
            iTanxPlayer.setVolume(0.0f);
        }
    }

    @Override
    public void setVolume(int n) {
        if (n >= 1) {
            this.iTanxPlayer.setVolume(1.0f);
        } else {
            this.iTanxPlayer.setVolume(n);
        }
    }

    @Override
    public int getVolume() {
        return this.audioManager.getStreamVolume(3);
    }

    @Override
    public int getMaxVolume() {
        return this.audioManager.getStreamMaxVolume(3);
    }

    @Override
    public void requestAudioFocus() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.audioFocusRequest = new AudioFocusRequest.Builder(1).setAudioAttributes(this.audioAttributes).setAcceptsDelayedFocusGain(false).setOnAudioFocusChangeListener(this.onAudioFocusChangeListener).build();
            this.audioManager.requestAudioFocus(this.audioFocusRequest);
        } else {
            this.audioManager.requestAudioFocus(this.onAudioFocusChangeListener, 3, 1);
        }
    }

    @Override
    public void abandonAudioFocus() {
        if (Build.VERSION.SDK_INT >= 26) {
            AudioFocusRequest audioFocusRequest = this.audioFocusRequest;
            if (audioFocusRequest != null) {
                this.audioManager.abandonAudioFocusRequest(audioFocusRequest);
            }
        } else {
            this.audioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        }
    }
}

