/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.player.ui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.alimm.tanx.core.request.TanxPlayerError;
import com.alimm.tanx.core.utils.LogUtils;
import com.alimm.tanx.ui.TanxSdk;
import com.alimm.tanx.ui.image.ImageConfig;
import com.alimm.tanx.ui.image.ImageLoader;
import com.alimm.tanx.ui.image.ScaleMode;
import com.alimm.tanx.ui.player.core.ITanxPlayer;
import com.alimm.tanx.ui.player.core.OnVideoBufferingListener;
import com.alimm.tanx.ui.player.core.OnVideoErrorListener;
import com.alimm.tanx.ui.player.core.OnVideoSizeChangeListener;
import com.alimm.tanx.ui.player.core.OnVideoStateChangeListener;
import com.alimm.tanx.ui.player.core.PlayerBufferingState;
import com.alimm.tanx.ui.player.core.PlayerState;
import com.alimm.tanx.ui.player.core.audio.IAudioManager;
import com.alimm.tanx.ui.player.core.audio.MediaPlayerAudioManager;
import com.alimm.tanx.ui.player.ui.ITanxPlayerView;
import java.util.Map;
import tanxu_do.tanxu_do.tanxu_do.tanxu_do.tanxu_int.tanxu_if;

public class TanxPlayerView
extends FrameLayout
implements ITanxPlayerView,
TextureView.SurfaceTextureListener {
    public static final String TAG = "TanxPlayerView";
    public ITanxPlayer iTanxPlayer;
    public ImageView coverView;
    public SurfaceTexture surfaceTexture;
    public Surface surface;
    public TextureView textureView;
    public IAudioManager audioManager;
    public OnVideoErrorListener onVideoErrorListener;
    public OnVideoStateChangeListener onVideoStateChangeListener;
    public OnVideoBufferingListener onVideoBufferingListener;
    public Matrix matrix;
    public boolean surfaceIsDestroy;

    public TanxPlayerView(@NonNull Context context) {
        this(context, null);
    }

    public TanxPlayerView(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, -1);
    }

    public TanxPlayerView(@NonNull Context context, @Nullable AttributeSet attributeSet, int n) {
        TanxPlayerView tanxPlayerView = this;
        super(context, attributeSet, n);
        tanxPlayerView.init();
    }

    private void init() {
        FrameLayout.LayoutParams layoutParams;
        TanxPlayerView tanxPlayerView = tanxPlayerView2;
        tanxPlayerView.audioManager = new MediaPlayerAudioManager(tanxPlayerView2.getContext(), tanxPlayerView2.iTanxPlayer);
        tanxPlayerView.coverView = new ImageView(tanxPlayerView2.getContext());
        tanxPlayerView.coverView.setVisibility(8);
        tanxPlayerView.textureView = new TextureView(tanxPlayerView2.getContext());
        tanxPlayerView.textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)tanxPlayerView2);
        TanxPlayerView tanxPlayerView2 = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        tanxPlayerView.addView((View)tanxPlayerView.textureView, (ViewGroup.LayoutParams)tanxPlayerView2);
        tanxPlayerView.addView((View)tanxPlayerView.coverView, (ViewGroup.LayoutParams)tanxPlayerView2);
    }

    private void registerMediaPlayerObserver(final ITanxPlayer iTanxPlayer) {
        ITanxPlayer iTanxPlayer2 = iTanxPlayer;
        iTanxPlayer2.setOnVideoStateChangeListener(new OnVideoStateChangeListener(){

            @Override
            public void onStateChange(ITanxPlayer iTanxPlayer2, PlayerState playerState) {
                if (playerState == PlayerState.PREPARED) {
                    if (iTanxPlayer.isPlayWhenReady()) {
                        iTanxPlayer.start();
                    }
                } else if (playerState == PlayerState.STARTED) {
                    2 v0 = this;
                    v0.TanxPlayerView.this.coverView.setVisibility(8);
                    v0.TanxPlayerView.this.audioManager.requestAudioFocus();
                } else if (playerState == PlayerState.COMPLETED) {
                    TanxPlayerView.this.coverView.setVisibility(0);
                } else if (playerState != PlayerState.STOPPED && playerState != PlayerState.END) {
                    if (playerState == PlayerState.ERROR) {
                        TanxPlayerView.this.audioManager.abandonAudioFocus();
                    }
                } else {
                    TanxPlayerView.this.audioManager.abandonAudioFocus();
                }
                if (TanxPlayerView.this.onVideoStateChangeListener != null) {
                    TanxPlayerView.this.onVideoStateChangeListener.onStateChange(iTanxPlayer2, playerState);
                }
            }
        });
        iTanxPlayer2.setOnVideoBufferingStateChangeListener(new OnVideoBufferingListener(){

            @Override
            public void OnBufferStateChanged(PlayerBufferingState playerBufferingState) {
                if (TanxPlayerView.this.onVideoBufferingListener != null) {
                    TanxPlayerView.this.onVideoBufferingListener.OnBufferStateChanged(playerBufferingState);
                }
            }
        });
        iTanxPlayer2.setOnVideoErrorListener(new OnVideoErrorListener(){

            @Override
            public boolean onError(ITanxPlayer iTanxPlayer, TanxPlayerError tanxPlayerError) {
                if (TanxPlayerView.this.onVideoErrorListener != null) {
                    TanxPlayerView.this.onVideoErrorListener.onError(iTanxPlayer, tanxPlayerError);
                }
                return false;
            }
        });
        iTanxPlayer2.setOnVideoSizeChangeListener(new OnVideoSizeChangeListener(){

            @Override
            public void onVideoSizeChanged(ITanxPlayer iTanxPlayer, int n, int n2) {
                TanxPlayerView.this.transformVideo(n, n2);
            }
        });
    }

    private void transformVideo(int n, int n2) {
        if (this.getHeight() != 0 && this.getWidth() != 0) {
            TanxPlayerView tanxPlayerView = this;
            float f = n;
            float f2 = (float)tanxPlayerView.getWidth() / f;
            Log.d((String)TAG, (String)("transformVideo, sx=" + f2));
            Matrix matrix = tanxPlayerView.matrix;
            if (matrix == null) {
                this.matrix = new Matrix();
            } else {
                matrix.reset();
            }
            TanxPlayerView tanxPlayerView2 = this;
            tanxPlayerView2.matrix.preTranslate((float)((this.getWidth() - n) / 2), (float)((this.getHeight() - n2) / 2));
            tanxPlayerView2.matrix.preScale(f / (float)this.getWidth(), (float)n2 / (float)this.getHeight());
            float f3 = f2;
            tanxPlayerView2.matrix.postScale(f3, f3, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
            LogUtils.d((String)TAG, (String)("transformVideo, maxScale=" + f2));
            tanxPlayerView2.textureView.setTransform(this.matrix);
            tanxPlayerView2.postInvalidate();
            LogUtils.d((String)TAG, (String)("transformVideo, videoWidth=" + n + "," + "videoHeight=" + n2));
            return;
        }
        Log.d((String)TAG, (String)("transformVideo, getHeight=" + this.getHeight() + "," + "getWidth=" + this.getWidth()));
    }

    private void removeMediaPlayerObserver(ITanxPlayer iTanxPlayer) {
        ITanxPlayer iTanxPlayer2 = iTanxPlayer;
        iTanxPlayer2.setOnVideoStateChangeListener(null);
        iTanxPlayer2.setOnVideoBufferingStateChangeListener(null);
        iTanxPlayer2.setOnVideoErrorListener(null);
        iTanxPlayer2.setOnVideoSizeChangeListener(null);
        this.audioManager.abandonAudioFocus();
    }

    private boolean inState(PlayerState ... playerStateArray) {
        Object object = object.getState();
        int n = playerStateArray.length;
        for (int i = 0; i < n; ++i) {
            if (object != playerStateArray[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setTanxPlayer(ITanxPlayer iTanxPlayer) {
        this.removeMediaPlayerObserver(iTanxPlayer);
        this.iTanxPlayer = iTanxPlayer;
        this.registerMediaPlayerObserver(iTanxPlayer);
    }

    @Override
    public void setCover(String object) {
        if (!TextUtils.isEmpty((CharSequence)object)) {
            object = ImageLoader.with(this.getContext()).tanxu_do((String)object).tanxu_do(ScaleMode.CENTER_CROP).tanxu_do();
            ImageLoader.getLoader().load((ImageConfig)object, new ImageConfig.ImageBitmapCallback((ImageConfig)object){
                public final /* synthetic */ ImageConfig val$imageConfig;
                {
                    this.val$imageConfig = imageConfig;
                }

                @Override
                public void onSuccess(Bitmap bitmap) {
                    TanxPlayerView.this.coverView.setImageDrawable((Drawable)new tanxu_if(bitmap, this.val$imageConfig.getImageConfig()));
                }

                @Override
                public void onFailure(String string) {
                    TanxPlayerView.this.coverView.setVisibility(8);
                }
            });
        }
    }

    @Override
    public void setDataSource(String string) {
        this.setDataSource(Uri.parse((String)string));
    }

    @Override
    public void setDataSource(Uri uri) {
        this.setDataSource(uri, null);
    }

    @Override
    public void setDataSource(Uri object, Map<String, String> map) {
        if (this.iTanxPlayer != null) {
            TanxPlayerView tanxPlayerView = this;
            object = object.toString();
            object = TanxSdk.getProxy(tanxPlayerView.getContext()).getProxyUrl((String)object);
            tanxPlayerView.iTanxPlayer.setDataSource(this.getContext(), Uri.parse((String)object), map);
        }
    }

    @Override
    public boolean isPlaying() {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        return iTanxPlayer != null && iTanxPlayer.isPlaying();
    }

    @Override
    public long currentPosition() {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        return iTanxPlayer == null ? 0L : iTanxPlayer.getCurrentPosition();
    }

    @Override
    public long duration() {
        if (((TanxPlayerView)((Object)iTanxPlayer)).inState(PlayerState.STARTED, PlayerState.PAUSED, PlayerState.STOPPED, PlayerState.COMPLETED)) {
            ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
            return iTanxPlayer == null ? 0L : iTanxPlayer.getDuration();
        }
        return 0L;
    }

    @Override
    public int videoHeight() {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        return iTanxPlayer == null ? 0 : iTanxPlayer.getVideoHeight();
    }

    @Override
    public int videoWidth() {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        return iTanxPlayer == null ? 0 : iTanxPlayer.getVideoWidth();
    }

    @Override
    public PlayerState getState() {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        return iTanxPlayer == null ? PlayerState.IDLE : iTanxPlayer.getState();
    }

    @Override
    public int getDuration() {
        if (((TanxPlayerView)this).inState(PlayerState.PREPARED, PlayerState.STARTED, PlayerState.PAUSED, PlayerState.STOPPED, PlayerState.COMPLETED) && (this = ((TanxPlayerView)this).iTanxPlayer) != null) {
            return (int)this.getDuration();
        }
        return 0;
    }

    @Override
    public int getCurrentPosition() {
        if (((TanxPlayerView)this).inState(PlayerState.PREPARED, PlayerState.STARTED, PlayerState.PAUSED, PlayerState.STOPPED, PlayerState.COMPLETED) && (this = ((TanxPlayerView)this).iTanxPlayer) != null) {
            return (int)this.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void prepare() {
        TanxPlayerView tanxPlayerView = this;
        tanxPlayerView.attach();
        if (tanxPlayerView.inState(PlayerState.INITIALIZED, PlayerState.STOPPED) && (this = ((TanxPlayerView)this).iTanxPlayer) != null) {
            this.prepareAsync();
        }
    }

    @Override
    public void start() {
        if (((TanxPlayerView)this).inState(PlayerState.PREPARED, PlayerState.STARTED, PlayerState.PAUSED, PlayerState.COMPLETED) && (this = ((TanxPlayerView)this).iTanxPlayer) != null) {
            this.start();
        }
    }

    @Override
    public void replay() {
        ITanxPlayer iTanxPlayer;
        if (this.inState(PlayerState.PREPARED, PlayerState.STARTED, PlayerState.PAUSED, PlayerState.COMPLETED) && (iTanxPlayer = this.iTanxPlayer) != null) {
            iTanxPlayer.seekTo(0L);
            this.iTanxPlayer.start();
        }
    }

    @Override
    public void pause() {
        if (((TanxPlayerView)this).inState(PlayerState.STARTED, PlayerState.PAUSED) && (this = ((TanxPlayerView)this).iTanxPlayer) != null) {
            this.pause();
        }
    }

    @Override
    public void stop() {
        if (((TanxPlayerView)this).inState(PlayerState.PREPARED, PlayerState.STARTED, PlayerState.PAUSED, PlayerState.STOPPED, PlayerState.COMPLETED) && (this = ((TanxPlayerView)this).iTanxPlayer) != null) {
            this.pause();
        }
    }

    @Override
    public void release() {
        TanxPlayerView tanxPlayerView = iTanxPlayer;
        tanxPlayerView.surfaceTexture.release();
        tanxPlayerView.surfaceTexture = null;
        ITanxPlayer iTanxPlayer = tanxPlayerView.iTanxPlayer;
        if (iTanxPlayer != null) {
            iTanxPlayer.release();
        }
    }

    @Override
    public void reset() {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        if (iTanxPlayer != null) {
            iTanxPlayer.reset();
        }
    }

    @Override
    public void seekTo(long l) {
        if (((TanxPlayerView)this).inState(PlayerState.PREPARED, PlayerState.STARTED, PlayerState.PAUSED, PlayerState.COMPLETED) && (this = ((TanxPlayerView)this).iTanxPlayer) != null) {
            this.seekTo(l);
        }
    }

    @Override
    public void setVolume(int n) {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        if (iTanxPlayer != null) {
            iTanxPlayer.setVolume(n);
        }
    }

    @Override
    public void mute() {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        if (iTanxPlayer != null) {
            iTanxPlayer.setVolume(0.0f);
        }
    }

    @Override
    public void resumeVolume() {
        ITanxPlayer iTanxPlayer = ((TanxPlayerView)((Object)iTanxPlayer)).iTanxPlayer;
        if (iTanxPlayer != null) {
            iTanxPlayer.setVolume(1.0f);
        }
    }

    @Override
    public void attach() {
        if (this.surfaceTexture != null) {
            Object object = this.surface;
            if (object != null) {
                object.release();
            }
            this.surface = new Surface(this.surfaceTexture);
            object = this.iTanxPlayer;
            if (object != null) {
                object.setSurface(this.surface);
            }
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        SurfaceTexture surfaceTexture2 = this.surfaceTexture;
        if (surfaceTexture2 == null) {
            this.surfaceTexture = surfaceTexture;
            this.attach();
        } else if (surfaceTexture2 != null) {
            this.textureView.setSurfaceTexture(surfaceTexture2);
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.textureView.getSurfaceTexture() != surfaceTexture) {
            this.textureView.setSurfaceTexture(surfaceTexture);
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        if (this.textureView.getSurfaceTexture() != surfaceTexture) {
            this.textureView.setSurfaceTexture(surfaceTexture);
        }
    }

    public void setOnVideoErrorListener(OnVideoErrorListener onVideoErrorListener) {
        this.onVideoErrorListener = onVideoErrorListener;
    }

    public void setOnVideoStateChangeListener(OnVideoStateChangeListener onVideoStateChangeListener) {
        this.onVideoStateChangeListener = onVideoStateChangeListener;
    }

    public void setOnVideoBufferingListener(OnVideoBufferingListener onVideoBufferingListener) {
        this.onVideoBufferingListener = onVideoBufferingListener;
    }
}

