/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import com.alimm.tanx.core.utils.LogUtils;
import java.lang.reflect.Method;

public class DeviceUtils {
    public static final String TAG = "DeviceUtils";

    public static boolean isXiaomiDevice() {
        String string = Build.BRAND.toLowerCase();
        return !TextUtils.isEmpty((CharSequence)string) && string.contains("xiaomi");
    }

    public static boolean isHuaweiDevice() {
        String string = Build.BRAND.toLowerCase();
        return !TextUtils.isEmpty((CharSequence)string) && (string.contains("huawei") || string.contains("honor"));
    }

    public static boolean isSamsungDevice() {
        String string = Build.BRAND.toLowerCase();
        return !TextUtils.isEmpty((CharSequence)string) && string.contains("samsung");
    }

    public static boolean isOppoDevice() {
        String string = Build.BRAND.toLowerCase();
        return !TextUtils.isEmpty((CharSequence)string) && string.contains("oppo");
    }

    public static boolean isVivoDevice() {
        String string = Build.BRAND.toLowerCase();
        return !TextUtils.isEmpty((CharSequence)string) && string.contains("vivo");
    }

    public static boolean isNavigationBarShow(@NonNull Context context) {
        if (DeviceUtils.isXiaomiDevice()) {
            boolean bl = false;
            boolean bl2 = Build.VERSION.SDK_INT >= 17 ? Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) == 0 : bl;
            return bl2;
        }
        if (DeviceUtils.isHuaweiDevice()) {
            return (Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0) : Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"navigationbar_is_min", (int)0)) == 0;
        }
        if (DeviceUtils.isVivoDevice()) {
            return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"navigation_gesture_on", (int)0) == 0;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            Point point;
            Point point2;
            Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            Point point3 = point2;
            point2 = new Point();
            Point point4 = point;
            point4();
            display.getSize(point3);
            display.getRealSize(point4);
            LogUtils.d((String)TAG, (String)("isNavigationBarShow: sY = " + point3.y + ", rY = " + point4.y));
            int n = point.y;
            int n2 = point3.y;
            if (n == n2) {
                return false;
            }
            return Math.abs(n - n2) >= DeviceUtils.getNavigationBarHeight(context);
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey() && !KeyCharacterMap.deviceHasKey((int)4);
    }

    public static int getNavigationBarHeight(@NonNull Context context) {
        Resources resources = context.getResources();
        return resources.getDimensionPixelSize(resources.getIdentifier("navigation_bar_height", "dimen", "android"));
    }

    public static int getStatusBarHeight(@NonNull Context context) {
        Resources resources = context.getResources();
        return resources.getDimensionPixelSize(resources.getIdentifier("status_bar_height", "dimen", "android"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point getAppWindowSize(@NonNull Context context) {
        DisplayMetrics displayMetrics;
        Point point;
        Context context2 = context;
        context = point;
        point = new Point();
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        try {
            Display display = ((WindowManager)context2.getSystemService("window")).getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getSize((Point)context);
            } else {
                display.getMetrics(displayMetrics2);
                context.x = displayMetrics2.widthPixels;
                context.y = displayMetrics2.heightPixels;
            }
        }
        catch (Exception exception) {
            LogUtils.d((String)TAG, (String)"getAppWindowSize size failed.", (Throwable)exception);
        }
        LogUtils.d((String)TAG, (String)("getAppWindowSize: appWindowSize = " + context));
        return context;
    }

    public static int getRealWidth(Context context) {
        int n;
        DisplayMetrics displayMetrics;
        int n2 = 0;
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        Class<?> clazz = Class.forName("android.view.Display");
        Class[] classArray = new Class[1];
        classArray[0] = DisplayMetrics.class;
        Method method = clazz.getMethod("getRealMetrics", classArray);
        Object[] objectArray = new Object[1];
        try {
            objectArray[0] = displayMetrics2;
            method.invoke((Object)display, objectArray);
            n = displayMetrics.widthPixels;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = n2;
        }
        return n;
    }

    public static int getRealHeight(Context context) {
        int n;
        DisplayMetrics displayMetrics;
        int n2 = 0;
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        Class<?> clazz = Class.forName("android.view.Display");
        Class[] classArray = new Class[1];
        classArray[0] = DisplayMetrics.class;
        Method method = clazz.getMethod("getRealMetrics", classArray);
        Object[] objectArray = new Object[1];
        try {
            objectArray[0] = displayMetrics2;
            method.invoke((Object)display, objectArray);
            n = displayMetrics.heightPixels;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = n2;
        }
        return n;
    }
}

