/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.util;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.alimm.tanx.core.ut.UtErrorCode;
import com.alimm.tanx.core.ut.impl.TanxBaseUt;
import com.alimm.tanx.core.utils.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static final int DIR_TYPE_FILE = 0;
    public static final int DIR_TYPE_CACHE = 1;
    public static final String TAG = "FileUtils";
    public static final int COPY_BUFFER_SIZE = 4096;

    public static String joinPath(String ... stringArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder2.append(File.separator);
                }
                stringBuilder2.append(stringArray[i]);
            }
        }
        return stringBuilder2.toString();
    }

    public static boolean exists(String string) {
        boolean bl;
        block4: {
            block3: {
                try {
                    if (TextUtils.isEmpty((CharSequence)string)) break block3;
                }
                catch (SecurityException securityException) {
                    LogUtils.d((String)TAG, (String)"call exists failed.", (Throwable)securityException);
                    return false;
                }
                if (!new File(string).exists()) break block3;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean ensureFileExists(String object) {
        File file;
        if (TextUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        File file2 = file;
        if (new File((String)object).exists()) return true;
        try {
            object = file2.getParentFile();
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                return false;
            }
            if (file2.createNewFile()) return true;
            return false;
        }
        catch (SecurityException exception) {
        }
        catch (IOException exception) {
            // empty catch block
        }
        exception.printStackTrace();
        return false;
    }

    public static void closeIO(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLines(String string) {
        Throwable throwable2;
        BufferedReader bufferedReader;
        block9: {
            BufferedReader bufferedReader2;
            LinkedList<String> linkedList;
            LinkedList<String> linkedList2 = linkedList;
            linkedList = new LinkedList<String>();
            if (!FileUtils.exists(string)) return linkedList2;
            Object var2_2 = null;
            bufferedReader = bufferedReader2;
            bufferedReader2 = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            try {
                IOException iOException2;
                block8: {
                    try {
                        while ((string = bufferedReader.readLine()) != null) {
                            linkedList2.add(string);
                        }
                    }
                    catch (IOException iOException2) {
                        break block8;
                    }
                    catch (Throwable throwable2) {
                        bufferedReader = var2_2;
                        break block9;
                    }
                    catch (IOException iOException2) {
                        bufferedReader = var2_2;
                    }
                }
                iOException2.printStackTrace();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            FileUtils.closeIO(bufferedReader);
            return linkedList2;
        }
        FileUtils.closeIO(bufferedReader);
        throw throwable2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeLine(String string, boolean bl, String string2) {
        Throwable throwable2;
        PrintWriter printWriter;
        block9: {
            IOException iOException2;
            block8: {
                PrintWriter printWriter2;
                if (!FileUtils.ensureFileExists(string)) {
                    return;
                }
                PrintWriter printWriter3 = null;
                PrintWriter printWriter4 = printWriter2;
                PrintWriter printWriter5 = printWriter = printWriter2;
                String string3 = string2;
                printWriter(new BufferedWriter(new FileWriter(string, bl)));
                try {
                    printWriter5.println(string3);
                }
                catch (IOException iOException2) {
                    break block8;
                }
                FileUtils.closeIO(printWriter4);
                return;
                catch (Throwable throwable2) {
                    printWriter = printWriter3;
                    break block9;
                }
                catch (IOException iOException2) {
                    printWriter = printWriter3;
                }
            }
            try {
                iOException2.printStackTrace();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            FileUtils.closeIO(printWriter);
            return;
        }
        FileUtils.closeIO(printWriter);
        throw throwable2;
    }

    public static void delete(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                FileUtils.deleteFile(new File(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean deleteFile(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            File[] fileArray;
            if (file.isFile()) {
                return file.delete();
            }
            if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (FileUtils.deleteFile(fileArray[i])) continue;
                    return false;
                }
            }
            return file.delete();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized boolean saveStrToFile(String var0, String var1_2) {
        block15: {
            block13: {
                block12: {
                    if (TextUtils.isEmpty((CharSequence)var0) != false) return false;
                    if (TextUtils.isEmpty((CharSequence)var1_2)) {
                        return false;
                    }
                    var2_5 = true;
                    var3_6 = null;
                    var4_7 = v0;
                    if (new File((String)var0).exists()) break block12;
                    try {
                        new File(var4_7.getParent()).mkdirs();
                        var4_7.createNewFile();
                    }
                    catch (Exception var0_1) {
                        var0 = var3_6;
                        var1_2 = var0_1;
                        ** GOTO lbl39
                    }
                }
                v1 = v2;
                v3 = v2;
                v4 = var0 = v2;
                v5 = var1_2;
                var0(var4_7);
                {
                    catch (Throwable v6) {
                        var0 = var3_6;
                        break block15;
                    }
                }
                try {
                    block14: {
                        try {
                            v1.write(v5.getBytes());
                            v3.close();
                            break block13;
                        }
                        catch (Exception var1_3) {
                            break block14;
                        }
                        catch (Exception var1_4) {
                            var0 = var3_6;
                        }
                    }
                    v4 = var0;
                    var2_5 = false;
                    var1_2.printStackTrace();
                }
                catch (Throwable v6) {
                    // empty catch block
                }
            }
            FileUtils.closeIO((Closeable)v4);
            return var2_5;
        }
        FileUtils.closeIO((Closeable)var0);
        throw v6;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized String getStrFromFile(String object) {
        Throwable throwable2;
        Object object2;
        block13: {
            Exception exception2;
            String string;
            block12: {
                FileInputStream fileInputStream;
                String string2;
                block11: {
                    string2 = "";
                    string = null;
                    if (new File((String)object).exists()) break block11;
                    FileUtils.closeIO((Closeable)((Object)string));
                    return null;
                }
                FileInputStream fileInputStream2 = fileInputStream;
                FileInputStream fileInputStream3 = fileInputStream;
                Object object3 = object2 = fileInputStream;
                fileInputStream = new FileInputStream((String)object);
                FileInputStream fileInputStream4 = fileInputStream;
                try {
                    String string3;
                    byte[] byArray = new byte[fileInputStream3.available()];
                    object = byArray;
                    ((FileInputStream)object3).read(byArray);
                    string = string3;
                    string3 = new String((byte[])object, "UTF-8");
                }
                catch (Exception exception2) {
                    string = string2;
                    break block12;
                }
                try {
                    fileInputStream4.close();
                }
                catch (Exception exception2) {
                    break block12;
                }
                FileUtils.closeIO(fileInputStream2);
                return string;
                catch (Throwable throwable2) {
                    object2 = string;
                    break block13;
                }
                catch (Exception exception2) {
                    String string4 = string;
                    string = string2;
                    object2 = string4;
                }
            }
            try {
                exception2.printStackTrace();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            FileUtils.closeIO((Closeable)object2);
            return string;
        }
        FileUtils.closeIO((Closeable)object2);
        throw throwable2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readAssetFile(@NonNull Context object, @NonNull String string) {
        Throwable throwable2;
        BufferedReader bufferedReader;
        block9: {
            Exception exception2;
            block8: {
                String string2;
                BufferedReader bufferedReader2;
                Object var2_2 = null;
                bufferedReader = bufferedReader2;
                bufferedReader2 = new BufferedReader(new InputStreamReader(object.getResources().getAssets().open(string)));
                try {
                    StringBuilder stringBuilder;
                    object = stringBuilder;
                    stringBuilder = new StringBuilder();
                    while ((string = bufferedReader.readLine()) != null) {
                        ((StringBuilder)object).append(string);
                    }
                    string2 = ((StringBuilder)object).toString();
                }
                catch (Exception exception2) {
                    break block8;
                }
                FileUtils.closeIO(bufferedReader);
                return string2;
                catch (Throwable throwable2) {
                    bufferedReader = var2_2;
                    break block9;
                }
                catch (Exception exception2) {
                    bufferedReader = var2_2;
                }
            }
            try {
                exception2.printStackTrace();
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            FileUtils.closeIO(bufferedReader);
            return "";
        }
        FileUtils.closeIO(bufferedReader);
        throw throwable2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean decompress(String string, String string2) {
        Throwable throwable2;
        Object object;
        block11: {
            boolean bl;
            block12: {
                bl = true;
                Object object2 = null;
                try {
                    ZipInputStream zipInputStream;
                    File file;
                    object = file;
                    if (!new File(string2).exists()) {
                        ((File)object).mkdirs();
                    }
                    object = zipInputStream;
                    zipInputStream = new ZipInputStream(new FileInputStream(new File(string)));
                }
                catch (Throwable throwable2) {
                    object = object2;
                    break block11;
                }
                catch (Exception exception) {
                    object = object2;
                    break block12;
                }
                try {
                    while ((object2 = ((ZipInputStream)object).getNextEntry()) != null) {
                        Object object3 = object2;
                        object2 = FileUtils.joinPath(string2, ((ZipEntry)object2).getName());
                        if (((ZipEntry)object3).isDirectory()) {
                            FileUtils.mkdir((String)object2);
                            continue;
                        }
                        bl &= FileUtils.copyTo(new File((String)object2), (InputStream)object);
                    }
                }
                catch (Exception exception) {}
                FileUtils.closeIO((Closeable)object);
                return bl;
            }
            try {
                void var2_5;
                LogUtils.d((String)TAG, (String)("decompress exception: inputFilePath = " + string + ", outputDirPath = " + string2), (Throwable)var2_5);
                bl = false;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            FileUtils.closeIO((Closeable)object);
            return bl;
        }
        FileUtils.closeIO((Closeable)object);
        throw throwable2;
    }

    public static void mkdir(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            File file;
            File file2 = file;
            if (!new File(string).exists()) {
                try {
                    file2.mkdirs();
                }
                catch (Exception exception) {
                    LogUtils.d((String)TAG, (String)("mkdir exception: folderPath = " + string), (Throwable)exception);
                }
            }
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copyTo(File file, InputStream inputStream) {
        Throwable throwable2;
        FileOutputStream fileOutputStream;
        block9: {
            block8: {
                FileOutputStream fileOutputStream2;
                byte[] byArray = null;
                fileOutputStream = fileOutputStream2;
                fileOutputStream2 = new FileOutputStream(file);
                try {
                    int n;
                    byArray = new byte[4096];
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                catch (IOException iOException) {
                    break block8;
                }
                FileUtils.closeIO(fileOutputStream);
                return true;
                catch (Throwable throwable2) {
                    fileOutputStream = byArray;
                    break block9;
                }
                catch (IOException iOException) {
                    fileOutputStream = byArray;
                }
            }
            try {
                void var1_4;
                LogUtils.d((String)TAG, (String)("copyTo exception: output = " + file), (Throwable)var1_4);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            FileUtils.closeIO(fileOutputStream);
            return false;
        }
        FileUtils.closeIO(fileOutputStream);
        throw throwable2;
    }

    public static List<File> getFiles(String fileArray, List<File> list) {
        File file;
        File file2 = file;
        if (new File((String)fileArray).isDirectory() && (fileArray = file2.listFiles()) != null) {
            for (File file3 : fileArray) {
                if (file3.isDirectory()) {
                    FileUtils.getFiles(file3.getAbsolutePath(), list);
                }
                list.add(file3);
            }
        }
        return list;
    }

    @NonNull
    public static List<File> getFiles(String string) {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            FileUtils.getFiles(string, arrayList2);
        }
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteExpiredFiles(String iterator, int n, FileKeepRule fileKeepRule) {
        try {
            iterator = FileUtils.getFiles(iterator);
            LogUtils.d((String)TAG, (String)("deleteExpiredFiles: expireDays = " + n));
            if (iterator == null || iterator.size() <= 0) return;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                if (System.currentTimeMillis() - file.lastModified() <= TimeUnit.DAYS.toMillis(n) || fileKeepRule != null && fileKeepRule.needKept(file.getName())) continue;
                LogUtils.d((String)TAG, (String)("deleteExpiredFile: file = " + file));
                FileUtils.deleteFile(file);
            }
            return;
        }
        catch (Exception exception) {
            LogUtils.e((String)TAG, (String)"deleteExpiredFiles: exception.", (Throwable)exception);
            TanxBaseUt.utError((int)UtErrorCode.CRASH_ERROR.getIntCode(), (String)TAG, (String)("deleteExpiredFiles: exception." + LogUtils.getStackTraceMessage((Throwable)exception)), (String)"");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getExternalDir(@NonNull Context object, int n) {
        Object var2_2 = null;
        if (n == 0) {
            try {
                return object.getExternalFilesDir(null);
            }
            catch (Throwable throwable) {
            }
        } else {
            if (n == 1) return object.getExternalCacheDir();
            return var2_2;
        }
        LogUtils.d((String)TAG, (String)("getExternalDir exception: type = " + n));
        return var2_2;
    }

    public static interface FileKeepRule {
        public boolean needKept(String var1);
    }
}

