/*
 * Decompiled with CFR 0.152.
 */
package com.alimm.tanx.ui.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import java.lang.ref.WeakReference;

public class VolumeChangeObserver {
    public static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    public static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    public VolumeChangeListener mVolumeChangeListener;
    public VolumeBroadcastReceiver mVolumeBroadcastReceiver;
    public Context mContext;
    public AudioManager mAudioManager;
    public boolean mRegistered = false;

    public VolumeChangeObserver(Context context) {
        this.mContext = context;
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)context.getSystemService("audio");
        }
    }

    public int getCurrentMusicVolume() {
        VolumeChangeObserver volumeChangeObserver = volumeChangeObserver.mAudioManager;
        return volumeChangeObserver != null ? volumeChangeObserver.getStreamVolume(3) : -1;
    }

    public int getMaxMusicVolume() {
        VolumeChangeObserver volumeChangeObserver = volumeChangeObserver.mAudioManager;
        return volumeChangeObserver != null ? volumeChangeObserver.getStreamMaxVolume(3) : 15;
    }

    public VolumeChangeListener getVolumeChangeListener() {
        return this.mVolumeChangeListener;
    }

    public void setVolumeChangeListener(VolumeChangeListener volumeChangeListener) {
        this.mVolumeChangeListener = volumeChangeListener;
    }

    public void registerReceiver() {
        IntentFilter intentFilter;
        this.mVolumeBroadcastReceiver = new VolumeBroadcastReceiver(this);
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction(VOLUME_CHANGED_ACTION);
        this.mContext.registerReceiver((BroadcastReceiver)this.mVolumeBroadcastReceiver, intentFilter2);
        this.mRegistered = true;
    }

    public void unregisterReceiver() {
        if (this.mRegistered) {
            VolumeChangeObserver volumeChangeObserver = this;
            VolumeChangeObserver volumeChangeObserver2 = volumeChangeObserver;
            VolumeChangeObserver volumeChangeObserver3 = volumeChangeObserver;
            volumeChangeObserver.mContext.unregisterReceiver((BroadcastReceiver)this.mVolumeBroadcastReceiver);
            volumeChangeObserver3.mVolumeChangeListener = null;
            try {
                volumeChangeObserver2.mRegistered = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class VolumeBroadcastReceiver
    extends BroadcastReceiver {
        public WeakReference<VolumeChangeObserver> mObserverWeakReference;

        public VolumeBroadcastReceiver(VolumeChangeObserver volumeChangeObserver) {
            this.mObserverWeakReference = new WeakReference<VolumeChangeObserver>(volumeChangeObserver);
        }

        public void onReceive(Context object, Intent intent) {
            int n;
            if (VolumeChangeObserver.VOLUME_CHANGED_ACTION.equals(intent.getAction()) && intent.getIntExtra(VolumeChangeObserver.EXTRA_VOLUME_STREAM_TYPE, -1) == 3 && (this = (VolumeChangeObserver)((VolumeBroadcastReceiver)((Object)this)).mObserverWeakReference.get()) != null && (object = ((VolumeChangeObserver)this).getVolumeChangeListener()) != null && (n = ((VolumeChangeObserver)this).getCurrentMusicVolume()) >= 0) {
                object.onVolumeChanged(n);
            }
        }
    }

    public static interface VolumeChangeListener {
        public void onVolumeChanged(int var1);
    }
}

