/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.MediaDrm;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.tanx.onlyid.api.IGetter;
import com.tanx.onlyid.api.IdStorageManager;
import com.tanx.onlyid.api.OAIDException;
import com.tanx.onlyid.api.OAIDLog;
import com.tanx.onlyid.api.impl.OAIDFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.UUID;

public final class DeviceID
implements IGetter {
    private Application application;
    private String clientId;
    private String oaid;

    public static void init(Application application) {
        if (application == null) {
            return;
        }
        DeviceID instance = Holder.INSTANCE;
        instance.application = application;
        String uniqueID = DeviceID.getUniqueID((Context)application);
        if (!TextUtils.isEmpty((CharSequence)uniqueID)) {
            instance.clientId = uniqueID;
            OAIDLog.print("Client id is IMEI/MEID: " + instance.clientId);
            return;
        }
        DeviceID.getOAID((Context)application, instance);
    }

    public static String getClientId() {
        String clientId = Holder.INSTANCE.clientId;
        if (clientId == null) {
            clientId = "";
        }
        return clientId;
    }

    public static String getClientIdMD5() {
        return DeviceID.calculateHash(DeviceID.getClientId(), "MD5");
    }

    public static String getClientIdSHA1() {
        return DeviceID.calculateHash(DeviceID.getClientId(), "SHA-1");
    }

    public static String getOAID() {
        String oaid = Holder.INSTANCE.oaid;
        if (oaid == null) {
            oaid = "";
        }
        return oaid;
    }

    public static void getOAID(Context context, IGetter getter) {
        OAIDFactory.create(context).doGet(getter);
    }

    public static boolean supportedOAID(Context context) {
        return OAIDFactory.create(context).supported();
    }

    public static String getUniqueID(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            OAIDLog.print("IMEI/MEID not allowed on Android 10+");
            return "";
        }
        if (context == null) {
            return "";
        }
        if (Build.VERSION.SDK_INT >= 23 && context.checkSelfPermission("android.permission.READ_PHONE_STATE") != 0) {
            OAIDLog.print("android.permission.READ_PHONE_STATE not granted");
            return "";
        }
        return DeviceID.getIMEI(context);
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    private static String getIMEI(Context context) {
        if (context == null) {
            return "";
        }
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            String imei = tm.getImei();
            if (TextUtils.isEmpty((CharSequence)imei)) {
                imei = DeviceID.getIMEI(context, 0);
            }
            return imei;
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
        catch (Error e) {
            OAIDLog.print(e);
        }
        return "";
    }

    private static String getIMEI(Context context, int slotId) {
        try {
            TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
            Method method = manager.getClass().getMethod("getImei", Integer.TYPE);
            String imei = (String)method.invoke((Object)manager, slotId);
            return imei;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return "";
        }
    }

    @SuppressLint(value={"HardwareIds"})
    public static String getAndroidID(Context context) {
        if (context == null) {
            return "";
        }
        String id = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (id == null || "9774d56d682e549c".equals(id)) {
            id = "";
        }
        return id;
    }

    public static String getWidevineID() {
        try {
            UUID WIDEVINE_UUID = new UUID(-1301668207276963122L, -6645017420763422227L);
            MediaDrm mediaDrm = new MediaDrm(WIDEVINE_UUID);
            byte[] widevineId = mediaDrm.getPropertyByteArray("deviceUniqueId");
            if (widevineId == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            for (byte aByte : widevineId) {
                sb.append(String.format("%02x", aByte));
            }
            return sb.toString();
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
        catch (Error e) {
            OAIDLog.print(e);
        }
        return "";
    }

    public static String getPseudoID() {
        int MODULUS = 10;
        StringBuilder sb = new StringBuilder();
        sb.append(Build.BOARD.length() % 10);
        if (Build.VERSION.SDK_INT >= 21) {
            sb.append(Arrays.deepToString(Build.SUPPORTED_ABIS).length() % 10);
        } else {
            sb.append(Build.CPU_ABI.length() % 10);
        }
        sb.append(Build.DEVICE.length() % 10);
        sb.append(Build.DISPLAY.length() % 10);
        sb.append(Build.HOST.length() % 10);
        sb.append(Build.ID.length() % 10);
        sb.append(Build.MANUFACTURER.length() % 10);
        sb.append(Build.BRAND.length() % 10);
        sb.append(Build.MODEL.length() % 10);
        sb.append(Build.PRODUCT.length() % 10);
        sb.append(Build.BOOTLOADER.length() % 10);
        sb.append(Build.HARDWARE.length() % 10);
        sb.append(Build.TAGS.length() % 10);
        sb.append(Build.TYPE.length() % 10);
        sb.append(Build.USER.length() % 10);
        return sb.toString();
    }

    public static String getGUID(Context context) {
        String uuid = DeviceID.getUuidFromSystemSettings(context);
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = DeviceID.getUuidFromExternalStorage(context);
        }
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = DeviceID.getUuidFromSharedPreferences(context);
        }
        if (TextUtils.isEmpty((CharSequence)uuid)) {
            uuid = UUID.randomUUID().toString();
            OAIDLog.print("Generate uuid by random: " + uuid);
            DeviceID.saveUuidToSharedPreferences(context, uuid);
            DeviceID.saveUuidToSystemSettings(context, uuid);
            DeviceID.saveUuidToExternalStorage(context, uuid);
        }
        return uuid;
    }

    private static String getUuidFromSystemSettings(Context context) {
        if (context == null) {
            return "";
        }
        String uuid = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"GUID_uuid");
        OAIDLog.print("Get uuid from system settings: " + uuid);
        return uuid;
    }

    private static void saveUuidToSystemSettings(Context context, String uuid) {
        if (context == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 23 || Settings.System.canWrite((Context)context)) {
            try {
                Settings.System.putString((ContentResolver)context.getContentResolver(), (String)"GUID_uuid", (String)uuid);
                OAIDLog.print("Save uuid to system settings: " + uuid);
            }
            catch (Exception e) {
                OAIDLog.print(e);
            }
        } else {
            OAIDLog.print("android.permission.WRITE_SETTINGS not granted");
        }
    }

    private static String getUuidFromExternalStorage(Context context) {
        if (context == null) {
            return "";
        }
        String uuid = "";
        File file = DeviceID.getGuidFile(context);
        if (file != null) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                uuid = reader.readLine();
            }
            catch (Exception e) {
                OAIDLog.print(e);
            }
        }
        OAIDLog.print("Get uuid from external storage: " + uuid);
        return uuid;
    }

    private static void saveUuidToExternalStorage(Context context, String uuid) {
        if (context == null) {
            return;
        }
        File file = DeviceID.getGuidFile(context);
        if (file == null) {
            OAIDLog.print("UUID file in external storage is null");
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            if (!file.exists()) {
                file.createNewFile();
            }
            writer.write(uuid);
            writer.flush();
            OAIDLog.print("Save uuid to external storage: " + uuid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
    }

    private static File getGuidFile(Context context) {
        boolean hasStoragePermission = false;
        if (Build.VERSION.SDK_INT < 23) {
            hasStoragePermission = true;
        } else if (Build.VERSION.SDK_INT >= 30) {
            hasStoragePermission = false;
        } else if (context != null) {
            boolean bl = hasStoragePermission = context.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        }
        if (hasStoragePermission && "mounted".equals(Environment.getExternalStorageState())) {
            return new File(Environment.getExternalStorageDirectory(), "Android/.GUID_uuid");
        }
        return null;
    }

    private static void saveUuidToSharedPreferences(Context context, String uuid) {
        if (context == null) {
            return;
        }
        SharedPreferences preferences = context.getSharedPreferences("GUID", 0);
        preferences.edit().putString("uuid", uuid).apply();
        OAIDLog.print("Save uuid to shared preferences: " + uuid);
    }

    private static String getUuidFromSharedPreferences(Context context) {
        if (context == null) {
            return "";
        }
        SharedPreferences preferences = context.getSharedPreferences("GUID", 0);
        String uuid = preferences.getString("uuid", "");
        OAIDLog.print("Get uuid from shared preferences: " + uuid);
        return uuid;
    }

    public static String calculateHash(String str, String algorithm) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        try {
            byte[] data = str.getBytes();
            byte[] bytes = MessageDigest.getInstance(algorithm).digest(data);
            StringBuilder sb = new StringBuilder();
            for (byte aByte : bytes) {
                sb.append(String.format("%02x", aByte));
            }
            return sb.toString();
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return "";
        }
    }

    private DeviceID() {
    }

    @Override
    public void oaidSucc(String result) {
        if (TextUtils.isEmpty((CharSequence)result)) {
            this.oaidError(new OAIDException("OAID is empty"));
            return;
        }
        this.clientId = result;
        this.oaid = result;
        OAIDLog.print("Client id is OAID/AAID: " + this.clientId);
        IdStorageManager.getInstance((Context)this.application).putId("KEY_OAID", this.oaid);
    }

    @Override
    public void oaidError(Exception error) {
        String id = DeviceID.getWidevineID();
        if (!TextUtils.isEmpty((CharSequence)id)) {
            this.clientId = id;
            OAIDLog.print("Client id is WidevineID: " + this.clientId);
            return;
        }
        id = DeviceID.getAndroidID((Context)this.application);
        if (!TextUtils.isEmpty((CharSequence)id)) {
            this.clientId = id;
            OAIDLog.print("Client id is AndroidID: " + this.clientId);
            return;
        }
        this.clientId = DeviceID.getGUID((Context)this.application);
        OAIDLog.print("Client id is GUID: " + this.clientId);
    }

    private static class Holder {
        static final DeviceID INSTANCE = new DeviceID();

        private Holder() {
        }
    }
}

