/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.tanx.onlyid.api.DeviceID;
import com.tanx.onlyid.api.IGetter;
import com.tanx.onlyid.api.IdStorageManager;
import com.tanx.onlyid.api.OAIDLog;

public final class DeviceIdManager {
    private static volatile DeviceIdManager instance;
    private static volatile boolean init;
    private static volatile String clientId;
    private static volatile String imei;
    private static volatile String oaid;
    private static volatile String androidId;
    private static volatile String widevineId;
    private static volatile String pseudoId;
    private static volatile String guid;
    private Application application;

    private DeviceIdManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DeviceIdManager getInstance() {
        if (null != instance) return instance;
        Class<DeviceIdManager> clazz = DeviceIdManager.class;
        synchronized (DeviceIdManager.class) {
            if (null != instance) return instance;
            instance = new DeviceIdManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init(Application application, boolean isDebug) {
        this.application = application;
        if (init) {
            return;
        }
        DeviceID.init(application);
        init = true;
        OAIDLog.enable(isDebug);
    }

    public void init(Application application) {
        this.init(application, false);
    }

    public String getClientId() {
        if (TextUtils.isEmpty((CharSequence)clientId) && TextUtils.isEmpty((CharSequence)(clientId = IdStorageManager.getInstance((Context)this.application).getString("KEY_CLIENT_ID")))) {
            clientId = DeviceID.getClientIdMD5();
            IdStorageManager.getInstance((Context)this.application).putId("KEY_CLIENT_ID", clientId);
        }
        if (clientId == null) {
            clientId = "";
        }
        return clientId;
    }

    public String getIMEI(Context context) {
        if (TextUtils.isEmpty((CharSequence)imei) && TextUtils.isEmpty((CharSequence)(imei = IdStorageManager.getInstance((Context)this.application).getString("KEY_IMEI")))) {
            imei = DeviceID.getUniqueID(context);
            IdStorageManager.getInstance((Context)this.application).putId("KEY_IMEI", imei);
        }
        if (imei == null) {
            imei = "";
        }
        return imei;
    }

    public String getOAID(Context context) {
        return this.getOAID(context, null);
    }

    public String getOAID(Context context, final IGetter iGetter) {
        if (TextUtils.isEmpty((CharSequence)oaid)) {
            oaid = DeviceID.getOAID();
            if (TextUtils.isEmpty((CharSequence)oaid)) {
                oaid = IdStorageManager.getInstance((Context)this.application).getString("KEY_OAID");
            }
            if (TextUtils.isEmpty((CharSequence)oaid)) {
                DeviceID.getOAID(context, new IGetter(){

                    @Override
                    public void oaidSucc(String result) {
                        oaid = result;
                        if (iGetter != null) {
                            iGetter.oaidSucc(oaid);
                        }
                    }

                    @Override
                    public void oaidError(Exception error) {
                        oaid = "";
                        if (iGetter != null) {
                            iGetter.oaidError(error);
                        }
                    }
                });
            }
        }
        if (oaid == null) {
            oaid = "";
        }
        if (iGetter != null) {
            iGetter.oaidSucc(oaid);
        }
        return oaid;
    }

    public String getAndroidID(Context context) {
        if (androidId == null && TextUtils.isEmpty((CharSequence)(androidId = IdStorageManager.getInstance((Context)this.application).getString("KEY_ANDROID_ID")))) {
            androidId = DeviceID.getAndroidID(context);
            IdStorageManager.getInstance((Context)this.application).putId("KEY_ANDROID_ID", androidId);
        }
        if (androidId == null) {
            androidId = "";
        }
        return androidId;
    }

    public String getWidevineID() {
        if (widevineId == null && TextUtils.isEmpty((CharSequence)(widevineId = IdStorageManager.getInstance((Context)this.application).getString("KEY_WIDEVINE_ID")))) {
            widevineId = DeviceID.getWidevineID();
            IdStorageManager.getInstance((Context)this.application).putId("KEY_WIDEVINE_ID", widevineId);
        }
        if (widevineId == null) {
            widevineId = "";
        }
        return widevineId;
    }

    public String getPseudoID() {
        if (pseudoId == null && TextUtils.isEmpty((CharSequence)(pseudoId = IdStorageManager.getInstance((Context)this.application).getString("KEY_PSEUDO_ID")))) {
            pseudoId = DeviceID.getPseudoID();
            IdStorageManager.getInstance((Context)this.application).putId("KEY_PSEUDO_ID", pseudoId);
        }
        if (pseudoId == null) {
            pseudoId = "";
        }
        return pseudoId;
    }

    public String getGUID(Context context) {
        if (guid == null && (guid = DeviceID.getGUID(context)) == null) {
            guid = "";
        }
        return guid;
    }

    static {
        init = false;
        clientId = null;
        imei = null;
        oaid = null;
        androidId = null;
        widevineId = null;
        pseudoId = null;
        guid = null;
    }
}

