/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import com.tanx.onlyid.api.ThreadPool;

public class IdStorageManager {
    private static final String TAG = IdStorageManager.class.getSimpleName();
    private SharedPreferences mPrefs;
    public static IdStorageManager instance;
    public static final String KEY_OAID = "KEY_OAID";
    public static final String KEY_IMEI = "KEY_IMEI";
    public static final String KEY_CLIENT_ID = "KEY_CLIENT_ID";
    public static final String KEY_ANDROID_ID = "KEY_ANDROID_ID";
    public static final String KEY_WIDEVINE_ID = "KEY_WIDEVINE_ID";
    public static final String KEY_PSEUDO_ID = "KEY_PSEUDO_ID";

    public IdStorageManager(Context c) {
        this.mPrefs = PreferenceManager.getDefaultSharedPreferences((Context)c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IdStorageManager getInstance(Context c) {
        if (null != instance) return instance;
        Class<IdStorageManager> clazz = IdStorageManager.class;
        synchronized (IdStorageManager.class) {
            if (null != instance) return instance;
            instance = new IdStorageManager(c);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void putString(final String k, final String v) {
        ThreadPool.post(new Runnable(){

            @Override
            public void run() {
                try {
                    SharedPreferences.Editor editor = IdStorageManager.this.mPrefs.edit();
                    editor.putString(k, v);
                    editor.apply();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("putString\u5f02\u5e38 key" + k + " value:" + v));
                }
            }
        });
    }

    public String getString(String k) {
        try {
            return this.mPrefs.getString(k, "");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getString\u5f02\u5e38 key:" + k));
            return "";
        }
    }

    public void putId(String k, String v) {
        if (TextUtils.isEmpty((CharSequence)k) || TextUtils.isEmpty((CharSequence)v)) {
            Log.e((String)"putId", (String)("key:" + k + " v" + v + " \u8fc7\u7a0b\u6709key\u6216value\u4e3a\u7a7a\uff0c\u7ec8\u6b62"));
            return;
        }
        this.putString(k, v);
    }
}

