/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api;

import android.os.Handler;
import android.os.Looper;
import com.tanx.onlyid.api.OAIDLog;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private static final String TAG = "UserReportAddThreadPool";
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAX_POOL_SIZE = 4;
    private static final int KEEP_ALIVE_SECONDS = 60;
    private static final int DEFAULT_QUEUE_SIZE = 100;
    private static long sIndex = 0L;
    private static ThreadPoolExecutor sExecutor = new ThreadPoolExecutor(2, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "UserReportAddThreadPool-" + sIndex++);
        }
    });
    private static Handler sHandler;

    public static void post(Runnable runnable) {
        try {
            sExecutor.execute(runnable);
        }
        catch (Throwable t) {
            OAIDLog.print(TAG, "post error");
        }
    }

    public static void postDelayed(final Runnable runnable, int delayTimeMills) {
        if (delayTimeMills == 0) {
            ThreadPool.post(runnable);
        } else if (delayTimeMills > 0) {
            if (sHandler == null) {
                sHandler = new Handler(Looper.getMainLooper());
            }
            sHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ThreadPool.post(runnable);
                }
            }, (long)delayTimeMills);
        }
    }

    public static void removeTask(Runnable runnable) {
        if (sHandler != null) {
            sHandler.removeCallbacks(runnable);
        }
    }

    static {
        sExecutor.allowCoreThreadTimeOut(true);
        sExecutor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            }
        });
    }
}

