/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api.impl;

import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.tanx.onlyid.api.IGetter;
import com.tanx.onlyid.api.IOAID;
import com.tanx.onlyid.api.OAIDException;
import com.tanx.onlyid.api.OAIDLog;
import com.tanx.onlyid.api.impl.OAIDService;
import com.tanx.onlyid.core.coolpad.deviceidsupport.IDeviceIdManager;

public class CoolpadImpl
implements IOAID {
    private final Context context;

    public CoolpadImpl(Context context) {
        this.context = context instanceof Application ? context : context.getApplicationContext();
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        try {
            PackageInfo pi = this.context.getPackageManager().getPackageInfo("com.coolpad.deviceidsupport", 0);
            return pi != null;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.coolpad.deviceidsupport", "com.coolpad.deviceidsupport.DeviceIdService"));
        OAIDService.bind(this.context, intent, getter, new OAIDService.RemoteCaller(){

            @Override
            public String callRemoteInterface(IBinder service) throws OAIDException, RemoteException {
                IDeviceIdManager anInterface = IDeviceIdManager.Stub.asInterface(service);
                if (anInterface == null) {
                    throw new OAIDException("IDeviceIdManager is null");
                }
                return anInterface.getOAID(CoolpadImpl.this.context.getPackageName());
            }
        });
    }
}

