/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api.impl;

import android.content.Context;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import com.tanx.onlyid.api.IGetter;
import com.tanx.onlyid.api.IOAID;
import com.tanx.onlyid.api.OAIDException;
import com.tanx.onlyid.api.OAIDLog;
import java.util.Objects;

class MeizuImpl
implements IOAID {
    private final Context context;

    public MeizuImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (this.context == null) {
            return false;
        }
        try {
            ProviderInfo pi = this.context.getPackageManager().resolveContentProvider("com.meizu.flyme.openidsdk", 0);
            return pi != null;
        }
        catch (Exception e) {
            OAIDLog.print(e);
            return false;
        }
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        Uri uri = Uri.parse((String)"content://com.meizu.flyme.openidsdk/");
        try (Cursor cursor = this.context.getContentResolver().query(uri, null, null, new String[]{"oaid"}, null);){
            Objects.requireNonNull(cursor).moveToFirst();
            String oaid = cursor.getString(cursor.getColumnIndex("value"));
            if (oaid == null || oaid.length() == 0) {
                throw new OAIDException("OAID query failed");
            }
            OAIDLog.print("OAID query success: " + oaid);
            getter.oaidSucc(oaid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
            getter.oaidError(e);
        }
    }
}

