/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api.impl;

import android.annotation.SuppressLint;
import android.content.ContentProviderClient;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import com.tanx.onlyid.api.IGetter;
import com.tanx.onlyid.api.IOAID;
import com.tanx.onlyid.api.OAIDException;
import com.tanx.onlyid.api.OAIDLog;

class NubiaImpl
implements IOAID {
    private final Context context;

    public NubiaImpl(Context context) {
        this.context = context;
    }

    @Override
    @SuppressLint(value={"AnnotateVersionCheck"})
    public boolean supported() {
        return Build.VERSION.SDK_INT >= 29;
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        if (!this.supported()) {
            String message = "Only supports Android 10.0 and above for Nubia";
            OAIDLog.print(message);
            getter.oaidError(new OAIDException(message));
            return;
        }
        String oaid = null;
        try {
            Uri uri = Uri.parse((String)"content://cn.nubia.identity/identity");
            ContentProviderClient client = this.context.getContentResolver().acquireContentProviderClient(uri);
            if (client == null) {
                return;
            }
            Bundle bundle = client.call("getOAID", null, null);
            if (Build.VERSION.SDK_INT >= 24) {
                client.close();
            } else {
                client.release();
            }
            if (bundle == null) {
                throw new OAIDException("OAID query failed: bundle is null");
            }
            if (bundle.getInt("code", -1) == 0) {
                oaid = bundle.getString("id");
            }
            if (oaid == null || oaid.length() == 0) {
                throw new OAIDException("OAID query failed: " + bundle.getString("message"));
            }
            OAIDLog.print("OAID query success: " + oaid);
            getter.oaidSucc(oaid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
            getter.oaidError(e);
        }
    }
}

