/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api.impl;

import android.app.Application;
import android.content.Context;
import com.tanx.onlyid.api.IOAID;
import com.tanx.onlyid.api.OAIDLog;
import com.tanx.onlyid.api.OAIDRom;
import com.tanx.onlyid.api.impl.AsusImpl;
import com.tanx.onlyid.api.impl.CoolpadImpl;
import com.tanx.onlyid.api.impl.CooseaImpl;
import com.tanx.onlyid.api.impl.DefaultImpl;
import com.tanx.onlyid.api.impl.FreemeImpl;
import com.tanx.onlyid.api.impl.GmsImpl;
import com.tanx.onlyid.api.impl.HuaweiImpl;
import com.tanx.onlyid.api.impl.LenovoImpl;
import com.tanx.onlyid.api.impl.MeizuImpl;
import com.tanx.onlyid.api.impl.MsaImpl;
import com.tanx.onlyid.api.impl.NubiaImpl;
import com.tanx.onlyid.api.impl.OppoImpl;
import com.tanx.onlyid.api.impl.SamsungImpl;
import com.tanx.onlyid.api.impl.VivoImpl;
import com.tanx.onlyid.api.impl.XiaomiImpl;

public final class OAIDFactory {
    private static IOAID ioaid;

    private OAIDFactory() {
    }

    public static IOAID create(Context context) {
        if (context != null && !(context instanceof Application)) {
            context = context.getApplicationContext();
        }
        if (ioaid != null) {
            return ioaid;
        }
        ioaid = OAIDFactory.createManufacturerImpl(context);
        if (ioaid != null && ioaid.supported()) {
            OAIDLog.print("Manufacturer interface has been found: " + ioaid.getClass().getName());
            return ioaid;
        }
        ioaid = OAIDFactory.createUniversalImpl(context);
        return ioaid;
    }

    private static IOAID createManufacturerImpl(Context context) {
        if (OAIDRom.isLenovo() || OAIDRom.isMotolora()) {
            return new LenovoImpl(context);
        }
        if (OAIDRom.isMeizu()) {
            return new MeizuImpl(context);
        }
        if (OAIDRom.isNubia()) {
            return new NubiaImpl(context);
        }
        if (OAIDRom.isXiaomi() || OAIDRom.isMiui() || OAIDRom.isBlackShark()) {
            return new XiaomiImpl(context);
        }
        if (OAIDRom.isSamsung()) {
            return new SamsungImpl(context);
        }
        if (OAIDRom.isVivo()) {
            return new VivoImpl(context);
        }
        if (OAIDRom.isASUS()) {
            return new AsusImpl(context);
        }
        if (OAIDRom.isHuawei() || OAIDRom.isEmui()) {
            return new HuaweiImpl(context);
        }
        if (OAIDRom.isOppo() || OAIDRom.isOnePlus()) {
            return new OppoImpl(context);
        }
        if (OAIDRom.isCoolpad(context)) {
            return new CoolpadImpl(context);
        }
        if (OAIDRom.isCoosea()) {
            return new CooseaImpl(context);
        }
        if (OAIDRom.isFreeme()) {
            return new FreemeImpl(context);
        }
        return null;
    }

    private static IOAID createUniversalImpl(Context context) {
        IOAID ioaid = new MsaImpl(context);
        if (ioaid.supported()) {
            OAIDLog.print("Mobile Security Alliance has been found: " + ioaid.getClass().getName());
            return ioaid;
        }
        ioaid = new GmsImpl(context);
        if (ioaid.supported()) {
            OAIDLog.print("Google Play Service has been found: " + ioaid.getClass().getName());
            return ioaid;
        }
        ioaid = new DefaultImpl();
        OAIDLog.print("OAID/AAID was not supported: " + ioaid.getClass().getName());
        return ioaid;
    }
}

