/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api.impl;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import com.tanx.onlyid.api.IGetter;
import com.tanx.onlyid.api.IOAID;
import com.tanx.onlyid.api.OAIDException;
import com.tanx.onlyid.api.OAIDLog;
import com.tanx.onlyid.api.OAIDRom;
import java.util.Objects;

class VivoImpl
implements IOAID {
    private final Context context;

    public VivoImpl(Context context) {
        this.context = context;
    }

    @Override
    public boolean supported() {
        if (Build.VERSION.SDK_INT < 28) {
            return false;
        }
        return OAIDRom.sysProperty("persist.sys.identifierid.supported", "0").equals("1");
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        Uri uri = Uri.parse((String)"content://com.vivo.vms.IdProvider/IdentifierId/OAID");
        try (Cursor cursor = this.context.getContentResolver().query(uri, null, null, null, null);){
            Objects.requireNonNull(cursor).moveToFirst();
            String oaid = cursor.getString(cursor.getColumnIndex("value"));
            if (oaid == null || oaid.length() == 0) {
                throw new OAIDException("OAID query failed");
            }
            OAIDLog.print("OAID query success: " + oaid);
            getter.oaidSucc(oaid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
            getter.oaidError(e);
        }
    }
}

