/*
 * Decompiled with CFR 0.152.
 */
package com.tanx.onlyid.api.impl;

import android.annotation.SuppressLint;
import android.content.Context;
import com.tanx.onlyid.api.IGetter;
import com.tanx.onlyid.api.IOAID;
import com.tanx.onlyid.api.OAIDException;
import com.tanx.onlyid.api.OAIDLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class XiaomiImpl
implements IOAID {
    private final Context context;
    private Class<?> idProviderClass;
    private Object idProviderImpl;

    @SuppressLint(value={"PrivateApi"})
    public XiaomiImpl(Context context) {
        this.context = context;
        try {
            this.idProviderClass = Class.forName("com.android.id.impl.IdProviderImpl");
            this.idProviderImpl = this.idProviderClass.newInstance();
        }
        catch (Exception e) {
            OAIDLog.print(e);
        }
    }

    @Override
    public boolean supported() {
        return this.idProviderImpl != null;
    }

    @Override
    public void doGet(IGetter getter) {
        if (this.context == null || getter == null) {
            return;
        }
        if (this.idProviderClass == null || this.idProviderImpl == null) {
            getter.oaidError(new OAIDException("Xiaomi IdProvider not exists"));
            return;
        }
        try {
            String oaid = this.getOAID();
            if (oaid == null || oaid.length() == 0) {
                throw new OAIDException("OAID query failed");
            }
            OAIDLog.print("OAID query success: " + oaid);
            getter.oaidSucc(oaid);
        }
        catch (Exception e) {
            OAIDLog.print(e);
            getter.oaidError(e);
        }
    }

    private String getOAID() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.idProviderClass.getMethod("getOAID", Context.class);
        return (String)method.invoke(this.idProviderImpl, this.context);
    }
}

