/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.reader;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONException;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.Map;

public class ObjectReaderImplDate
extends DateTimeCodec
implements ObjectReader {
    public static final ObjectReaderImplDate INSTANCE = new ObjectReaderImplDate(null, null);

    public static ObjectReaderImplDate of(String format, Locale locale) {
        if (format == null) {
            return INSTANCE;
        }
        return new ObjectReaderImplDate(format, locale);
    }

    public ObjectReaderImplDate(String format, Locale locale) {
        super(format, locale);
    }

    public Class getObjectClass() {
        return Date.class;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return this.readDate(jsonReader);
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return this.readDate(jsonReader);
    }

    private Object readDate(JSONReader jsonReader) {
        long millis;
        if (jsonReader.isInt()) {
            long millis2 = jsonReader.readInt64Value();
            if (this.formatUnixTime) {
                millis2 *= 1000L;
            }
            return new Date(millis2);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.nextIfNullOrEmptyString()) {
            return null;
        }
        if (jsonReader.current() == 'n') {
            return jsonReader.readNullOrNewDate();
        }
        if (this.useSimpleFormatter || this.locale != null) {
            String str = jsonReader.readString();
            try {
                SimpleDateFormat dateFormat = this.locale != null ? new SimpleDateFormat(this.format, this.locale) : new SimpleDateFormat(this.format);
                return dateFormat.parse(str);
            }
            catch (ParseException e) {
                throw new JSONException(jsonReader.info("parse error : " + str), e);
            }
        }
        if ((this.formatUnixTime || this.formatMillis) && jsonReader.isString()) {
            millis = jsonReader.readInt64Value();
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
        } else if (this.format != null) {
            ZonedDateTime zdt;
            if (this.yyyyMMddhhmmss19) {
                millis = jsonReader.isSupportSmartMatch() ? jsonReader.readMillisFromString() : jsonReader.readMillis19();
                if (millis != 0L || !jsonReader.wasNull()) {
                    return new Date(millis);
                }
                zdt = jsonReader.readZonedDateTime();
            } else {
                DateTimeFormatter formatter = this.getDateFormatter(jsonReader.getLocale());
                if (formatter != null) {
                    LocalDateTime ldt;
                    String str = jsonReader.readString();
                    if (str.isEmpty() || "null".equals(str)) {
                        return null;
                    }
                    if (!this.formatHasHour) {
                        if (!this.formatHasDay) {
                            TemporalAccessor parsed = formatter.parse(str);
                            int year = parsed.get(ChronoField.YEAR);
                            int month = parsed.get(ChronoField.MONTH_OF_YEAR);
                            int dayOfYear = 1;
                            ldt = LocalDateTime.of(LocalDate.of(year, month, dayOfYear), LocalTime.MIN);
                        } else if (str.length() == 19 && jsonReader.isEnabled(JSONReader.Feature.SupportSmartMatch)) {
                            ldt = DateUtils.parseLocalDateTime(str, 0, str.length());
                        } else {
                            if (this.format.indexOf(45) != -1 && str.indexOf(45) == -1 && TypeUtils.isInteger(str)) {
                                long millis3 = Long.parseLong(str);
                                return new Date(millis3);
                            }
                            LocalDate localDate = LocalDate.parse(str, formatter);
                            ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                        }
                    } else if (str.length() == 19 && (this.yyyyMMddhhmm16 || jsonReader.isEnabled(JSONReader.Feature.SupportSmartMatch) || "yyyy-MM-dd hh:mm:ss".equals(this.format))) {
                        int length = this.yyyyMMddhhmm16 ? 16 : 19;
                        ldt = DateUtils.parseLocalDateTime(str, 0, length);
                    } else {
                        ldt = LocalDateTime.parse(str, formatter);
                    }
                    zdt = ldt.atZone(jsonReader.getContext().getZoneId());
                } else {
                    zdt = jsonReader.readZonedDateTime();
                }
            }
            if (zdt == null) {
                return null;
            }
            long seconds = zdt.toEpochSecond();
            int nanos = zdt.toLocalTime().getNano();
            if (seconds < 0L && nanos > 0) {
                millis = (seconds + 1L) * 1000L;
                long adjustment = nanos / 1000000 - 1000;
                millis += adjustment;
            } else {
                millis = seconds * 1000L;
                millis += (long)(nanos / 1000000);
            }
        } else {
            if (jsonReader.isDate()) {
                return jsonReader.readDate();
            }
            if (jsonReader.isTypeRedirect() && jsonReader.nextIfMatchIdent('\"', 'v', 'a', 'l', '\"')) {
                jsonReader.nextIfMatch(':');
                millis = jsonReader.readInt64Value();
                jsonReader.nextIfObjectEnd();
                jsonReader.setTypeRedirect(false);
            } else {
                millis = jsonReader.readMillisFromString();
            }
            if (millis == 0L && jsonReader.wasNull()) {
                return null;
            }
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
        }
        return new Date(millis);
    }

    public Date createInstance(Map map, long features) {
        return TypeUtils.toDate(map);
    }
}

