/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.util;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONB;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONException;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONWriter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.support.LambdaMiscCodec;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.Fnv;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.ToIntFunction;

public class JodaSupport {
    static final long HASH_YEAR = Fnv.hashCode64("year");
    static final long HASH_MONTH = Fnv.hashCode64("month");
    static final long HASH_DAY = Fnv.hashCode64("day");
    static final long HASH_HOUR = Fnv.hashCode64("hour");
    static final long HASH_MINUTE = Fnv.hashCode64("minute");
    static final long HASH_SECOND = Fnv.hashCode64("second");
    static final long HASH_MILLIS = Fnv.hashCode64("millis");
    static final long HASH_CHRONOLOGY = Fnv.hashCode64("chronology");

    public static ObjectWriter createLocalDateTimeWriter(Class objectClass, String format) {
        return new LocalDateTimeWriter(objectClass, format);
    }

    public static ObjectWriter createLocalDateWriter(Class objectClass, String format) {
        return new LocalDateWriter(objectClass, format);
    }

    public static ObjectReader createChronologyReader(Class objectClass) {
        return new ChronologyReader(objectClass);
    }

    public static ObjectReader createLocalDateReader(Class objectClass) {
        return new LocalDateReader(objectClass);
    }

    public static ObjectReader createLocalDateTimeReader(Class objectClass) {
        return new LocalDateTimeReader(objectClass);
    }

    public static ObjectReader createInstantReader(Class objectClass) {
        return new InstantReader(objectClass);
    }

    public static ObjectWriter createGregorianChronologyWriter(Class objectClass) {
        return new GregorianChronologyWriter(objectClass);
    }

    public static ObjectWriter createISOChronologyWriter(Class objectClass) {
        return new ISOChronologyWriter(objectClass);
    }

    public static final class DateTime2ZDT
    implements Function {
        static Class CLASS;
        static ToIntFunction YEAR;
        static ToIntFunction MONTH;
        static ToIntFunction DAY_OF_MONTH;
        static ToIntFunction HOUR;
        static ToIntFunction MINUTE;
        static ToIntFunction SECOND;
        static ToIntFunction MILLIS;
        static Function GET_ZONE;
        static Function GET_ID;

        public Object apply(Object o) {
            try {
                if (CLASS == null) {
                    CLASS = Class.forName("org.joda.time.DateTime");
                }
                if (YEAR == null) {
                    YEAR = LambdaMiscCodec.createToIntFunction(CLASS.getMethod("getYear", new Class[0]));
                }
                if (MONTH == null) {
                    MONTH = LambdaMiscCodec.createToIntFunction(CLASS.getMethod("getMonthOfYear", new Class[0]));
                }
                if (DAY_OF_MONTH == null) {
                    DAY_OF_MONTH = LambdaMiscCodec.createToIntFunction(CLASS.getMethod("getDayOfMonth", new Class[0]));
                }
                if (HOUR == null) {
                    HOUR = LambdaMiscCodec.createToIntFunction(CLASS.getMethod("getHourOfDay", new Class[0]));
                }
                if (MINUTE == null) {
                    MINUTE = LambdaMiscCodec.createToIntFunction(CLASS.getMethod("getMinuteOfHour", new Class[0]));
                }
                if (SECOND == null) {
                    SECOND = LambdaMiscCodec.createToIntFunction(CLASS.getMethod("getSecondOfMinute", new Class[0]));
                }
                if (MILLIS == null) {
                    MILLIS = LambdaMiscCodec.createToIntFunction(CLASS.getMethod("getMillisOfSecond", new Class[0]));
                }
                if (GET_ZONE == null) {
                    GET_ZONE = LambdaMiscCodec.createFunction(CLASS.getMethod("getZone", new Class[0]));
                }
                if (GET_ID == null) {
                    GET_ID = LambdaMiscCodec.createFunction(Class.forName("org.joda.time.DateTimeZone").getMethod("getID", new Class[0]));
                }
                Object zone = GET_ZONE.apply(o);
                String zonIdStr = (String)GET_ID.apply(zone);
                ZoneId zoneId = ZoneId.of(zonIdStr);
                return ZonedDateTime.of(YEAR.applyAsInt(o), MONTH.applyAsInt(o), DAY_OF_MONTH.applyAsInt(o), HOUR.applyAsInt(o), MINUTE.applyAsInt(o), SECOND.applyAsInt(o), MILLIS.applyAsInt(o) * 1000000, zoneId);
            }
            catch (Exception e) {
                throw new JSONException("convert joda org.joda.time.DateTime to java.time.ZonedDateTime error", e);
            }
        }
    }

    public static final class DateTimeFromZDT
    implements Function {
        static Constructor CONS;
        static Method FOR_ID;

        public Object apply(Object o) {
            ZonedDateTime zdt = (ZonedDateTime)o;
            try {
                String zondId;
                if (FOR_ID == null) {
                    Class<?> zoneClass = Class.forName("org.joda.time.DateTimeZone");
                    FOR_ID = zoneClass.getMethod("forID", String.class);
                }
                if (CONS == null) {
                    CONS = Class.forName("org.joda.time.DateTime").getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, FOR_ID.getDeclaringClass());
                }
                if ("Z".equals(zondId = zdt.getZone().getId())) {
                    zondId = "UTC";
                }
                return CONS.newInstance(zdt.getYear(), zdt.getMonthValue(), zdt.getDayOfMonth(), zdt.getHour(), zdt.getMinute(), zdt.getSecond(), zdt.getNano() / 1000000, FOR_ID.invoke(null, zondId));
            }
            catch (Exception e) {
                throw new JSONException("build DateTime error", e);
            }
        }
    }

    static class LocalDateTimeWriter
    extends DateTimeCodec
    implements ObjectWriter {
        final Class objectClass;
        final Method getYear;
        final Method getMonthOfYear;
        final Method getDayOfMonth;
        final ToIntFunction getHourOfDay;
        final ToIntFunction getMinuteOfHour;
        final ToIntFunction getSecondOfMinute;
        final ToIntFunction getMillisOfSecond;
        final Function getChronology;
        final Class isoChronology;
        final Object utc;

        LocalDateTimeWriter(Class objectClass, String format) {
            super(format);
            this.objectClass = objectClass;
            try {
                ClassLoader classLoader = objectClass.getClassLoader();
                this.isoChronology = classLoader.loadClass("org.joda.time.chrono.ISOChronology");
                Object instance = this.isoChronology.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                this.utc = this.isoChronology.getMethod("withUTC", new Class[0]).invoke(instance, new Object[0]);
                this.getYear = objectClass.getMethod("getYear", new Class[0]);
                this.getMonthOfYear = objectClass.getMethod("getMonthOfYear", new Class[0]);
                this.getDayOfMonth = objectClass.getMethod("getDayOfMonth", new Class[0]);
                this.getHourOfDay = LambdaMiscCodec.createToIntFunction(objectClass.getMethod("getHourOfDay", new Class[0]));
                this.getMinuteOfHour = LambdaMiscCodec.createToIntFunction(objectClass.getMethod("getMinuteOfHour", new Class[0]));
                this.getSecondOfMinute = LambdaMiscCodec.createToIntFunction(objectClass.getMethod("getSecondOfMinute", new Class[0]));
                this.getMillisOfSecond = LambdaMiscCodec.createToIntFunction(objectClass.getMethod("getMillisOfSecond", new Class[0]));
                this.getChronology = LambdaMiscCodec.createFunction(objectClass.getMethod("getChronology", new Class[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create LocalDateWriter error", e);
            }
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                int year = (Integer)this.getYear.invoke(object, new Object[0]);
                int monthOfYear = (Integer)this.getMonthOfYear.invoke(object, new Object[0]);
                int dayOfMonth = (Integer)this.getDayOfMonth.invoke(object, new Object[0]);
                int hour = this.getHourOfDay.applyAsInt(object);
                int minute = this.getMinuteOfHour.applyAsInt(object);
                int second = this.getSecondOfMinute.applyAsInt(object);
                int millis = this.getMillisOfSecond.applyAsInt(object);
                Object chronology = this.getChronology.apply(object);
                if (jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
                    jsonWriter.writeTypeName(TypeUtils.getTypeName(object.getClass()));
                }
                if (chronology == this.utc || chronology == null) {
                    jsonWriter.writeLocalDateTime(LocalDateTime.of(year, monthOfYear, dayOfMonth, hour, minute, second, millis * 1000000));
                    return;
                }
                jsonWriter.startObject();
                jsonWriter.writeName("year");
                jsonWriter.writeInt32(year);
                jsonWriter.writeName("month");
                jsonWriter.writeInt32(monthOfYear);
                jsonWriter.writeName("day");
                jsonWriter.writeInt32(dayOfMonth);
                jsonWriter.writeName("hour");
                jsonWriter.writeInt32(hour);
                jsonWriter.writeName("minute");
                jsonWriter.writeInt32(minute);
                jsonWriter.writeName("second");
                jsonWriter.writeInt32(second);
                jsonWriter.writeName("millis");
                jsonWriter.writeInt32(millis);
                jsonWriter.writeName("chronology");
                jsonWriter.writeAny(chronology);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write LocalDateWriter error", e);
            }
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            try {
                int year = (Integer)this.getYear.invoke(object, new Object[0]);
                int monthOfYear = (Integer)this.getMonthOfYear.invoke(object, new Object[0]);
                int dayOfMonth = (Integer)this.getDayOfMonth.invoke(object, new Object[0]);
                int hour = this.getHourOfDay.applyAsInt(object);
                int minute = this.getMinuteOfHour.applyAsInt(object);
                int second = this.getSecondOfMinute.applyAsInt(object);
                int millis = this.getMillisOfSecond.applyAsInt(object);
                Object chronology = this.getChronology.apply(object);
                if (jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
                    jsonWriter.writeTypeName(TypeUtils.getTypeName(object.getClass()));
                }
                if (chronology == this.utc || chronology == null) {
                    int nanoOfSecond = millis * 1000000;
                    LocalDateTime ldt = LocalDateTime.of(year, monthOfYear, dayOfMonth, hour, minute, second, nanoOfSecond);
                    DateTimeFormatter formatter = this.getDateFormatter();
                    if (formatter == null) {
                        formatter = jsonWriter.context.getDateFormatter();
                    }
                    if (formatter == null) {
                        jsonWriter.writeLocalDateTime(ldt);
                        return;
                    }
                    String str = formatter.format(ldt);
                    jsonWriter.writeString(str);
                    return;
                }
                jsonWriter.startObject();
                jsonWriter.writeName("year");
                jsonWriter.writeInt32(year);
                jsonWriter.writeName("month");
                jsonWriter.writeInt32(monthOfYear);
                jsonWriter.writeName("day");
                jsonWriter.writeInt32(dayOfMonth);
                jsonWriter.writeName("hour");
                jsonWriter.writeInt32(hour);
                jsonWriter.writeName("minute");
                jsonWriter.writeInt32(minute);
                jsonWriter.writeName("second");
                jsonWriter.writeInt32(second);
                jsonWriter.writeName("millis");
                jsonWriter.writeInt32(millis);
                jsonWriter.writeName("chronology");
                jsonWriter.writeAny(chronology);
                jsonWriter.endObject();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new JSONException("write LocalDateWriter error", e);
            }
        }
    }

    static class LocalDateTimeReader
    implements ObjectReader {
        final Class objectClass;
        final Constructor constructor7;
        final Constructor constructor8;
        final Class classISOChronology;
        final Class classChronology;
        final Object utc;

        LocalDateTimeReader(Class objectClass) {
            this.objectClass = objectClass;
            try {
                ClassLoader classLoader = objectClass.getClassLoader();
                this.classChronology = classLoader.loadClass("org.joda.time.Chronology");
                this.constructor7 = objectClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.constructor8 = objectClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, this.classChronology);
                this.classISOChronology = classLoader.loadClass("org.joda.time.chrono.ISOChronology");
                this.utc = this.classISOChronology.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create LocalDateWriter error", e);
            }
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.isString() || jsonReader.isInt()) {
                LocalDateTime ldt = jsonReader.readLocalDateTime();
                if (ldt == null) {
                    return null;
                }
                try {
                    return this.constructor7.newInstance(ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNano() / 1000000);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            throw new JSONException(jsonReader.info("not support"));
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            byte type = jsonReader.getType();
            if (type == -87) {
                LocalDate localDate = jsonReader.readLocalDate();
                try {
                    return this.constructor7.newInstance(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), 0, 0, 0, 0);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            if (type == -88) {
                LocalDateTime ldt = jsonReader.readLocalDateTime();
                try {
                    return this.constructor7.newInstance(ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth(), ldt.getHour(), ldt.getMinute(), ldt.getSecond(), ldt.getNano() / 1000000);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            if (jsonReader.isObject()) {
                Integer year = null;
                Integer month = null;
                Integer day = null;
                Integer hour = null;
                Integer minute = null;
                Integer second = null;
                Integer millis = null;
                Object chronology = null;
                jsonReader.nextIfObjectStart();
                while (!jsonReader.nextIfObjectEnd()) {
                    long fieldNameHashCode = jsonReader.readFieldNameHashCode();
                    if (fieldNameHashCode == HASH_YEAR) {
                        year = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_MONTH) {
                        month = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_DAY) {
                        day = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_HOUR) {
                        hour = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_MINUTE) {
                        minute = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_SECOND) {
                        second = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_MILLIS) {
                        millis = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_CHRONOLOGY) {
                        chronology = jsonReader.read(this.classChronology);
                        continue;
                    }
                    throw new JSONException(jsonReader.info("not support fieldName " + jsonReader.getFieldName()));
                }
                try {
                    return this.constructor8.newInstance(year, month, day, hour, minute, second, millis, chronology);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            throw new JSONException(jsonReader.info("not support " + JSONB.typeName(type)));
        }
    }

    static class LocalDateWriter
    extends DateTimeCodec
    implements ObjectWriter {
        final Class objectClass;
        final ToIntFunction getYear;
        final ToIntFunction getMonthOfYear;
        final ToIntFunction getDayOfMonth;
        final Function getChronology;
        final Class isoChronology;
        final Object utc;

        LocalDateWriter(Class objectClass, String format) {
            super(format);
            this.objectClass = objectClass;
            try {
                ClassLoader classLoader = objectClass.getClassLoader();
                this.isoChronology = classLoader.loadClass("org.joda.time.chrono.ISOChronology");
                Object instance = this.isoChronology.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                this.utc = this.isoChronology.getMethod("withUTC", new Class[0]).invoke(instance, new Object[0]);
                this.getYear = LambdaMiscCodec.createToIntFunction(objectClass.getMethod("getYear", new Class[0]));
                this.getMonthOfYear = LambdaMiscCodec.createToIntFunction(objectClass.getMethod("getMonthOfYear", new Class[0]));
                this.getDayOfMonth = LambdaMiscCodec.createToIntFunction(objectClass.getMethod("getDayOfMonth", new Class[0]));
                this.getChronology = LambdaMiscCodec.createFunction(objectClass.getMethod("getChronology", new Class[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create LocalDateWriter error", e);
            }
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            int year = this.getYear.applyAsInt(object);
            int monthOfYear = this.getMonthOfYear.applyAsInt(object);
            int dayOfMonth = this.getDayOfMonth.applyAsInt(object);
            Object chronology = this.getChronology.apply(object);
            if (jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
                jsonWriter.writeTypeName(TypeUtils.getTypeName(object.getClass()));
            }
            if (chronology == this.utc || chronology == null) {
                jsonWriter.writeLocalDate(LocalDate.of(year, monthOfYear, dayOfMonth));
                return;
            }
            jsonWriter.startObject();
            jsonWriter.writeName("year");
            jsonWriter.writeInt32(year);
            jsonWriter.writeName("month");
            jsonWriter.writeInt32(monthOfYear);
            jsonWriter.writeName("day");
            jsonWriter.writeInt32(dayOfMonth);
            jsonWriter.writeName("chronology");
            jsonWriter.writeAny(chronology);
            jsonWriter.endObject();
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            int year = this.getYear.applyAsInt(object);
            int monthOfYear = this.getMonthOfYear.applyAsInt(object);
            int dayOfMonth = this.getDayOfMonth.applyAsInt(object);
            Object chronology = this.getChronology.apply(object);
            if (chronology == this.utc || chronology == null) {
                LocalDate localDate = LocalDate.of(year, monthOfYear, dayOfMonth);
                DateTimeFormatter formatter = this.getDateFormatter();
                if (formatter == null) {
                    formatter = jsonWriter.context.getDateFormatter();
                }
                if (formatter == null) {
                    jsonWriter.writeLocalDate(localDate);
                    return;
                }
                String str = formatter.format(localDate);
                jsonWriter.writeString(str);
                return;
            }
            jsonWriter.startObject();
            jsonWriter.writeName("year");
            jsonWriter.writeInt32(year);
            jsonWriter.writeName("month");
            jsonWriter.writeInt32(monthOfYear);
            jsonWriter.writeName("day");
            jsonWriter.writeInt32(dayOfMonth);
            jsonWriter.writeName("chronology");
            jsonWriter.writeAny(chronology);
            jsonWriter.endObject();
        }
    }

    static class LocalDateReader
    implements ObjectReader {
        final Class objectClass;
        final Constructor constructor3;
        final Constructor constructor4;
        final Class classISOChronology;
        final Class classChronology;
        final Object utc;

        LocalDateReader(Class objectClass) {
            this.objectClass = objectClass;
            try {
                ClassLoader classLoader = objectClass.getClassLoader();
                this.classChronology = classLoader.loadClass("org.joda.time.Chronology");
                this.constructor3 = objectClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.constructor4 = objectClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, this.classChronology);
                this.classISOChronology = classLoader.loadClass("org.joda.time.chrono.ISOChronology");
                this.utc = this.classISOChronology.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create LocalDateWriter error", e);
            }
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            LocalDate localDate = jsonReader.readLocalDate();
            if (localDate == null) {
                return null;
            }
            try {
                return this.constructor4.newInstance(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth(), null);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
            }
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            byte type = jsonReader.getType();
            if (type == -87) {
                LocalDate localDate = jsonReader.readLocalDate();
                try {
                    return this.constructor3.newInstance(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            if (jsonReader.isObject()) {
                Integer year = null;
                Integer month = null;
                Integer day = null;
                Object chronology = null;
                jsonReader.nextIfObjectStart();
                while (!jsonReader.nextIfObjectEnd()) {
                    long fieldNameHashCode = jsonReader.readFieldNameHashCode();
                    if (fieldNameHashCode == HASH_YEAR) {
                        year = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_MONTH) {
                        month = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_DAY) {
                        day = jsonReader.readInt32Value();
                        continue;
                    }
                    if (fieldNameHashCode == HASH_CHRONOLOGY) {
                        chronology = jsonReader.read(this.classChronology);
                        continue;
                    }
                    throw new JSONException(jsonReader.info("not support fieldName " + jsonReader.getFieldName()));
                }
                try {
                    return this.constructor4.newInstance(year, month, day, chronology);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new JSONException(jsonReader.info("read org.joda.time.LocalDate error"), e);
                }
            }
            throw new JSONException(jsonReader.info("not support " + JSONB.typeName(type)));
        }
    }

    static class ISOChronologyWriter
    implements ObjectWriter {
        final Class objectClass;
        final Function getZone;
        final Function getID;

        ISOChronologyWriter(Class objectClass) {
            this.objectClass = objectClass;
            try {
                Method method = objectClass.getMethod("getZone", new Class[0]);
                this.getZone = LambdaMiscCodec.createFunction(method);
                this.getID = LambdaMiscCodec.createFunction(method.getReturnType().getMethod("getID", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("getMethod error", e);
            }
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            Object zone = this.getZone.apply(object);
            String zoneId = (String)this.getID.apply(zone);
            jsonWriter.startObject();
            jsonWriter.writeName("zoneId");
            jsonWriter.writeString(zoneId);
            jsonWriter.endObject();
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            Object zone = this.getZone.apply(object);
            String zoneId = (String)this.getID.apply(zone);
            jsonWriter.startObject();
            jsonWriter.writeName("zoneId");
            jsonWriter.writeString(zoneId);
            jsonWriter.endObject();
        }
    }

    static class GregorianChronologyWriter
    implements ObjectWriter {
        final Class objectClass;
        final ToIntFunction getMinimumDaysInFirstWeek;
        final Function getZone;
        final Function getID;

        GregorianChronologyWriter(Class objectClass) {
            this.objectClass = objectClass;
            try {
                this.getMinimumDaysInFirstWeek = LambdaMiscCodec.createToIntFunction(objectClass.getMethod("getMinimumDaysInFirstWeek", new Class[0]));
                Method method = objectClass.getMethod("getZone", new Class[0]);
                this.getZone = LambdaMiscCodec.createFunction(method);
                this.getID = LambdaMiscCodec.createFunction(method.getReturnType().getMethod("getID", new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("getMethod error", e);
            }
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            Object zone = this.getZone.apply(object);
            String zoneId = (String)this.getID.apply(zone);
            int minDaysInFirstWeek = this.getMinimumDaysInFirstWeek.applyAsInt(object);
            jsonWriter.startObject();
            if (minDaysInFirstWeek != 4) {
                jsonWriter.writeName("minimumDaysInFirstWeek");
                jsonWriter.writeInt32(minDaysInFirstWeek);
            }
            jsonWriter.writeName("zoneId");
            jsonWriter.writeString(zoneId);
            jsonWriter.endObject();
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            Object zone = this.getZone.apply(object);
            String zoneId = (String)this.getID.apply(zone);
            int minDaysInFirstWeek = this.getMinimumDaysInFirstWeek.applyAsInt(object);
            jsonWriter.startObject();
            jsonWriter.writeName("minimumDaysInFirstWeek");
            jsonWriter.writeInt32(minDaysInFirstWeek);
            jsonWriter.writeName("zoneId");
            jsonWriter.writeString(zoneId);
            jsonWriter.endObject();
        }
    }

    static class ChronologyReader
    implements ObjectReader {
        static final long HASH_ZONE_ID = Fnv.hashCode64("zoneId");
        final Class objectClass;
        final Class gregorianChronology;
        final Class dateTimeZone;
        final Function forID;
        final Function getInstance;
        final Object utc;

        ChronologyReader(Class objectClass) {
            this.objectClass = objectClass;
            ClassLoader classLoader = objectClass.getClassLoader();
            try {
                this.gregorianChronology = classLoader.loadClass("org.joda.time.chrono.GregorianChronology");
                this.dateTimeZone = classLoader.loadClass("org.joda.time.DateTimeZone");
                this.utc = this.gregorianChronology.getMethod("getInstanceUTC", new Class[0]).invoke(null, new Object[0]);
                this.forID = LambdaMiscCodec.createFunction(this.dateTimeZone.getMethod("forID", String.class));
                this.getInstance = LambdaMiscCodec.createFunction(this.gregorianChronology.getMethod("getInstance", this.dateTimeZone));
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create ChronologyReader error", e);
            }
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            throw new JSONException(jsonReader.info("not support"));
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            Integer minimumDaysInFirstWeek = null;
            String zoneId = null;
            jsonReader.nextIfObjectStart();
            while (!jsonReader.nextIfObjectEnd()) {
                long HASH_MINIMUM_DAYS_IN_FIRST_WEEK = 8244232525129275563L;
                long fieldNameHashCode = jsonReader.readFieldNameHashCode();
                if (fieldNameHashCode == 8244232525129275563L) {
                    minimumDaysInFirstWeek = jsonReader.readInt32Value();
                    continue;
                }
                if (fieldNameHashCode == HASH_ZONE_ID) {
                    zoneId = jsonReader.readString();
                    continue;
                }
                throw new JSONException(jsonReader.info("not support fieldName " + jsonReader.getFieldName()));
            }
            if (minimumDaysInFirstWeek == null) {
                if ("UTC".equals(zoneId)) {
                    return this.utc;
                }
                Object datetimeZone = this.forID.apply(zoneId);
                return this.getInstance.apply(datetimeZone);
            }
            throw new JSONException(jsonReader.info("not support"));
        }
    }

    static class InstantReader
    implements ObjectReader {
        final Class objectClass;
        final LongFunction constructor;

        InstantReader(Class objectClass) {
            this.objectClass = objectClass;
            try {
                this.constructor = LambdaMiscCodec.createLongFunction(objectClass.getConstructor(Long.TYPE));
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("create joda instant reader error", e);
            }
        }

        public Class getObjectClass() {
            return this.objectClass;
        }

        public Object createInstance(Map map, long features) {
            Long millis = (Long)map.get("millis");
            if (millis != null) {
                return this.createInstanceFromMillis(millis);
            }
            Number epochSecond = (Number)map.get("epochSecond");
            if (epochSecond != null) {
                long epochMillis = epochSecond.longValue() * 1000L;
                return this.createInstanceFromMillis(epochMillis);
            }
            throw new JSONException("create joda instant error");
        }

        public Object createInstanceFromMillis(long millis) {
            return this.constructor.apply(millis);
        }

        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.nextIfNull()) {
                return null;
            }
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                return this.createInstanceFromMillis(millis);
            }
            if (jsonReader.isString()) {
                Instant jdkInstant = jsonReader.readInstant();
                if (jdkInstant == null) {
                    return null;
                }
                long millis = jdkInstant.toEpochMilli();
                return this.createInstanceFromMillis(millis);
            }
            if (jsonReader.isObject()) {
                Map<String, Object> object = jsonReader.readObject();
                return this.createInstance(object, features);
            }
            throw new JSONException(jsonReader.info("not support"));
        }

        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            return this.readObject(jsonReader, fieldType, fieldName, features);
        }
    }
}

