/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.view;

import com.taobao.arthas.core.command.klass100.RetransformCommand;
import com.taobao.arthas.core.command.model.RetransformModel;
import com.taobao.arthas.core.command.view.ClassLoaderView;
import com.taobao.arthas.core.command.view.ResultView;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.text.Decoration;
import com.taobao.text.ui.RowElement;
import com.taobao.text.ui.TableElement;
import com.taobao.text.util.RenderUtil;

public class RetransformView
extends ResultView<RetransformModel> {
    @Override
    public void draw(CommandProcess process, RetransformModel result) {
        if (result.getMatchedClassLoaders() != null) {
            process.write("Matched classloaders: \n");
            ClassLoaderView.drawClassLoaders(process, result.getMatchedClassLoaders(), false);
            process.write("\n");
            return;
        }
        if (result.getDeletedRetransformEntry() != null) {
            process.write("Delete RetransformEntry by id success. id: " + result.getDeletedRetransformEntry().getId());
            process.write("\n");
            return;
        }
        if (result.getRetransformEntries() != null) {
            TableElement table = new TableElement(1, 1, 1, 1, 1).rightCellPadding(1);
            table.add(new RowElement().style(Decoration.bold.bold()).add("Id", "ClassName", "TransformCount", "LoaderHash", "LoaderClassName"));
            for (RetransformCommand.RetransformEntry entry : result.getRetransformEntries()) {
                table.row("" + entry.getId(), "" + entry.getClassName(), "" + entry.getTransformCount(), "" + entry.getHashCode(), "" + entry.getClassLoaderClass());
            }
            process.write(RenderUtil.render(table));
            return;
        }
        if (result.getRetransformClasses() != null) {
            StringBuilder sb = new StringBuilder();
            for (String aClass : result.getRetransformClasses()) {
                sb.append(aClass).append("\n");
            }
            process.write("retransform success, size: " + result.getRetransformCount()).write(", classes:\n").write(sb.toString());
        }
    }
}

