/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFutureListener;
import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.ChannelProgressiveFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelProgressiveFutureListener;
import com.alibaba.arthas.deps.io.netty.channel.DefaultFileRegion;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.DefaultHttpResponse;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpChunkedInput;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpResponse;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpResponseStatus;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpUtil;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpVersion;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.LastHttpContent;
import com.alibaba.arthas.deps.io.netty.handler.ssl.SslHandler;
import com.alibaba.arthas.deps.io.netty.handler.stream.ChunkedFile;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.taobao.arthas.common.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DirectoryBrowser {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final long MIN_NETTY_DIRECT_SEND_SIZE = 0xA00000L;
    private static final Logger logger = LoggerFactory.getLogger(DirectoryBrowser.class);
    private static String pageHeader = "<!DOCTYPE html>\n<html>\n\n<head>\n    <title>Arthas Resouces: %s</title>\n    <meta charset=\"utf-8\" name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <style>\nbody {\n    background: #fff;\n}\n    </style>\n</head>\n\n<body>\n    <header>\n        <h1>%s</h1>\n    </header>\n    <hr/>\n    <main>\n        <pre id=\"contents\">\n";
    private static String pageFooter = "       </pre>\n    </main>\n    <hr/>\n</body>\n\n</html>";
    private static String linePart1Str = "<a href=\"%s\" title=\"%s\">";
    private static String linePart2Str = "%-60s";

    static String renderDir(File dir, boolean printParentLink) {
        Object[] listFiles = dir.listFiles();
        StringBuilder sb = new StringBuilder(8192);
        String dirName = dir.getName() + "/";
        sb.append(String.format(pageHeader, dirName, dirName));
        if (printParentLink) {
            sb.append("<a href=\"../\" title=\"../\">../</a>\n");
        }
        if (listFiles != null) {
            String modifyStr;
            SimpleDateFormat simpleDateFormat;
            String part2Format;
            String linePart2;
            String part1Format;
            String name;
            Arrays.sort(listFiles);
            for (Object f : listFiles) {
                if (!((File)f).isDirectory()) continue;
                name = ((File)f).getName() + "/";
                part1Format = String.format(linePart1Str, name, name, name);
                sb.append(part1Format);
                linePart2 = name + "</a>";
                part2Format = String.format(linePart2Str, linePart2);
                sb.append(part2Format);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                modifyStr = simpleDateFormat.format(new Date(((File)f).lastModified()));
                sb.append(modifyStr);
                sb.append("         -      ").append("\r\n");
            }
            for (Object f : listFiles) {
                if (!((File)f).isFile()) continue;
                name = ((File)f).getName();
                part1Format = String.format(linePart1Str, name, name, name);
                sb.append(part1Format);
                linePart2 = name + "</a>";
                part2Format = String.format(linePart2Str, linePart2);
                sb.append(part2Format);
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                modifyStr = simpleDateFormat.format(new Date(((File)f).lastModified()));
                sb.append(modifyStr);
                String sizeStr = String.format("%10d      ", ((File)f).length());
                sb.append(sizeStr).append("\r\n");
            }
        }
        sb.append(pageFooter);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultFullHttpResponse directView(File dir, String path, FullHttpRequest request, ChannelHandlerContext ctx) throws IOException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        File file = new File(dir.getParent(), path);
        HttpVersion version = request.protocolVersion();
        if (DirectoryBrowser.isSubFile(dir, file)) {
            ChannelFuture lastContentFuture;
            ChannelFuture sendFileFuture;
            DefaultFullHttpResponse fullResp = new DefaultFullHttpResponse(version, HttpResponseStatus.OK);
            if (file.isDirectory()) {
                if (!path.endsWith("/")) {
                    fullResp.setStatus(HttpResponseStatus.FOUND).headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)("/" + path + "/"));
                }
                String renderResult = DirectoryBrowser.renderDir(file, !DirectoryBrowser.isSameFile(dir, file));
                fullResp.content().writeBytes(renderResult.getBytes("utf-8"));
                fullResp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=utf-8");
                ctx.write(fullResp);
                ChannelFuture future = ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                future.addListener(ChannelFutureListener.CLOSE);
                return fullResp;
            }
            logger.info("get file now. file:" + file.getPath());
            if (file.isHidden() || !file.exists() || file.isDirectory() || !file.isFile()) {
                return null;
            }
            long fileLength = file.length();
            if (fileLength < 0xA00000L) {
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    byte[] content = IOUtils.getBytes(fileInputStream);
                    fullResp.content().writeBytes(content);
                    HttpUtil.setContentLength(fullResp, fullResp.content().readableBytes());
                }
                finally {
                    IOUtils.close(fileInputStream);
                }
                ctx.write(fullResp);
                ChannelFuture future = ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
                future.addListener(ChannelFutureListener.CLOSE);
                return fullResp;
            }
            logger.info("file {} size bigger than {}, send by future.", (Object)file.getName(), (Object)0xA00000L);
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpUtil.setContentLength(response, fileLength);
            DirectoryBrowser.setContentTypeHeader(response, file);
            DirectoryBrowser.setDateAndCacheHeaders(response, file);
            if (HttpUtil.isKeepAlive(request)) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            ctx.write(response);
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            if (ctx.pipeline().get(SslHandler.class) == null) {
                sendFileFuture = ctx.write(new DefaultFileRegion(raf.getChannel(), 0L, fileLength), ctx.newProgressivePromise());
                lastContentFuture = ctx.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                lastContentFuture = sendFileFuture = ctx.writeAndFlush(new HttpChunkedInput(new ChunkedFile(raf, 0L, fileLength, 8192)), ctx.newProgressivePromise());
            }
            sendFileFuture.addListener(new ChannelProgressiveFutureListener(){

                @Override
                public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                    if (total < 0L) {
                        logger.info(future.channel() + " Transfer progress: " + progress);
                    } else {
                        logger.info(future.channel() + " Transfer progress: " + progress + " / " + total);
                    }
                }

                @Override
                public void operationComplete(ChannelProgressiveFuture future) {
                    logger.info(future.channel() + " Transfer complete.");
                }
            });
            if (!HttpUtil.isKeepAlive(request)) {
                lastContentFuture.addListener(ChannelFutureListener.CLOSE);
            }
            return fullResp;
        }
        return null;
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 3600);
        response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)dateFormatter.format(time.getTime()));
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, max-age=3600");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        String contentType = "application/octet-stream";
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
    }

    public static boolean isSubFile(File parent, File child) throws IOException {
        String childPath;
        String parentPath = parent.getCanonicalPath();
        return parentPath.equals(childPath = child.getCanonicalPath()) || childPath.startsWith(parent.getCanonicalPath() + File.separator);
    }

    public static boolean isSameFile(File a, File b) {
        try {
            return a.getCanonicalPath().equals(b.getCanonicalPath());
        }
        catch (IOException e) {
            return false;
        }
    }
}

