/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.command.monitor200;

import com.taobao.arthas.core.GlobalOptions;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.command.monitor200.EnhancerCommand;
import com.taobao.arthas.core.command.monitor200.StackAdviceListener;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.util.SearchUtils;
import com.taobao.arthas.core.util.matcher.Matcher;
import com.taobao.middleware.cli.annotations.Argument;
import com.taobao.middleware.cli.annotations.Description;
import com.taobao.middleware.cli.annotations.Name;
import com.taobao.middleware.cli.annotations.Option;
import com.taobao.middleware.cli.annotations.Summary;

@Name(value="stack")
@Summary(value="Display the stack trace for the specified class and method")
@Description(value="  The express may be one of the following expression (evaluated dynamically):\n          target : the object\n           clazz : the object's class\n          method : the constructor or method\n          params : the parameters array of method\n    params[0..n] : the element of parameters array\n       returnObj : the returned object of method\n        throwExp : the throw exception of method\n        isReturn : the method ended by return\n         isThrow : the method ended by throwing exception\n           #cost : the execution time in ms of method invocation\nEXAMPLES:\n  stack org.apache.commons.lang.StringUtils isBlank\n  stack *StringUtils isBlank\n  stack *StringUtils isBlank params[0].length==1\n  stack *StringUtils isBlank '#cost>100'\n  stack -E org\\.apache\\.commons\\.lang\\.StringUtils isBlank\n\nWIKI:\n  https://arthas.aliyun.com/doc/stack")
public class StackCommand
extends EnhancerCommand {
    private String classPattern;
    private String methodPattern;
    private String conditionExpress;
    private boolean isRegEx = false;
    private int numberOfLimit = 100;

    @Argument(index=0, argName="class-pattern")
    @Description(value="Path and classname of Pattern Matching")
    public void setClassPattern(String classPattern) {
        this.classPattern = classPattern;
    }

    @Argument(index=1, argName="method-pattern", required=false)
    @Description(value="Method of Pattern Matching")
    public void setMethodPattern(String methodPattern) {
        this.methodPattern = methodPattern;
    }

    @Argument(index=2, argName="condition-express", required=false)
    @Description(value="Conditional expression in ognl style, for example:\n  TRUE  : 1==1\n  TRUE  : true\n  FALSE : false\n  TRUE  : 'params.length>=0'\n  FALSE : 1==2\n  '#cost>100'\n")
    public void setConditionExpress(String conditionExpress) {
        this.conditionExpress = conditionExpress;
    }

    @Option(shortName="E", longName="regex", flag=true)
    @Description(value="Enable regular expression to match (wildcard matching by default)")
    public void setRegEx(boolean regEx) {
        this.isRegEx = regEx;
    }

    @Option(shortName="n", longName="limits")
    @Description(value="Threshold of execution times")
    public void setNumberOfLimit(int numberOfLimit) {
        this.numberOfLimit = numberOfLimit;
    }

    public String getClassPattern() {
        return this.classPattern;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String getConditionExpress() {
        return this.conditionExpress;
    }

    public boolean isRegEx() {
        return this.isRegEx;
    }

    public int getNumberOfLimit() {
        return this.numberOfLimit;
    }

    @Override
    protected Matcher getClassNameMatcher() {
        if (this.classNameMatcher == null) {
            this.classNameMatcher = SearchUtils.classNameMatcher(this.getClassPattern(), this.isRegEx());
        }
        return this.classNameMatcher;
    }

    @Override
    protected Matcher getClassNameExcludeMatcher() {
        if (this.classNameExcludeMatcher == null && this.getExcludeClassPattern() != null) {
            this.classNameExcludeMatcher = SearchUtils.classNameMatcher(this.getExcludeClassPattern(), this.isRegEx());
        }
        return this.classNameExcludeMatcher;
    }

    @Override
    protected Matcher getMethodNameMatcher() {
        if (this.methodNameMatcher == null) {
            this.methodNameMatcher = SearchUtils.classNameMatcher(this.getMethodPattern(), this.isRegEx());
        }
        return this.methodNameMatcher;
    }

    @Override
    protected AdviceListener getAdviceListener(CommandProcess process) {
        return new StackAdviceListener(this, process, GlobalOptions.verbose || this.verbose);
    }
}

