/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.env.convert;

import com.taobao.arthas.core.env.ConversionService;
import com.taobao.arthas.core.env.convert.Converter;
import com.taobao.arthas.core.util.StringUtils;
import java.lang.reflect.Array;

final class StringToArrayConverter<T>
implements Converter<String, T[]> {
    private ConversionService conversionService;

    public StringToArrayConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public T[] convert(String source, Class<T[]> targetType) {
        String[] strings = StringUtils.tokenizeToStringArray(source, ",");
        Object[] values = (Object[])Array.newInstance(targetType.getComponentType(), strings.length);
        for (int i = 0; i < strings.length; ++i) {
            Object value = this.conversionService.convert(strings[i], targetType.getComponentType());
            values[i] = value;
        }
        return values;
    }
}

