/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.command.internal;

import com.taobao.arthas.core.shell.command.internal.CloseFunction;
import com.taobao.arthas.core.shell.command.internal.PlainTextHandler;
import com.taobao.arthas.core.util.LogUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class RedirectHandler
extends PlainTextHandler
implements CloseFunction {
    private PrintWriter out;
    private File file;

    public RedirectHandler() {
    }

    public RedirectHandler(String name, boolean append) throws IOException {
        File parentFile;
        File file = new File(name);
        if (file.isDirectory()) {
            throw new IOException(name + ": Is a directory");
        }
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            parentFile.mkdirs();
        }
        this.file = file;
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(file, append)));
    }

    @Override
    public String apply(String data) {
        data = super.apply(data);
        if (this.out != null) {
            this.out.write(data);
            this.out.flush();
        } else {
            LogUtil.getResultLogger().info(data);
        }
        return data;
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.out.close();
        }
    }

    public String getFilePath() {
        return this.file.getAbsolutePath();
    }
}

