/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.shell.term.impl.http;

import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.alibaba.arthas.deps.io.netty.channel.group.ChannelGroup;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import com.alibaba.arthas.deps.io.netty.handler.timeout.IdleStateEvent;
import com.taobao.arthas.core.shell.term.impl.http.ExtHttpTtyConnection;
import com.taobao.arthas.core.shell.term.impl.http.HttpRequestHandler;
import io.termd.core.function.Consumer;
import io.termd.core.http.HttpTtyConnection;
import io.termd.core.tty.TtyConnection;

public class TtyWebSocketFrameHandler
extends SimpleChannelInboundHandler<TextWebSocketFrame> {
    private final ChannelGroup group;
    private final Consumer<TtyConnection> handler;
    private ChannelHandlerContext context;
    private HttpTtyConnection conn;

    public TtyWebSocketFrameHandler(ChannelGroup group, Consumer<TtyConnection> handler) {
        this.group = group;
        this.handler = handler;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.context = ctx;
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == WebSocketServerProtocolHandler.ServerHandshakeStateEvent.HANDSHAKE_COMPLETE) {
            ctx.pipeline().remove(HttpRequestHandler.class);
            this.group.add(ctx.channel());
            this.conn = new ExtHttpTtyConnection(this.context);
            this.handler.accept(this.conn);
        } else if (evt instanceof IdleStateEvent) {
            ctx.writeAndFlush(new PingWebSocketFrame());
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Consumer<Void> closeHandler;
        HttpTtyConnection tmp = this.conn;
        this.context = null;
        this.conn = null;
        if (tmp != null && (closeHandler = tmp.getCloseHandler()) != null) {
            closeHandler.accept(null);
        }
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, TextWebSocketFrame msg) throws Exception {
        this.conn.writeToDecoder(msg.text());
    }
}

