/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ASTChain;
import ognl.ASTConst;
import ognl.AccessibleObjectHandler;
import ognl.AccessibleObjectHandlerJDK9Plus;
import ognl.AccessibleObjectHandlerPreJDK9;
import ognl.ArrayElementsAccessor;
import ognl.ArrayPropertyAccessor;
import ognl.ClassCacheInspector;
import ognl.ClassResolver;
import ognl.CollectionElementsAccessor;
import ognl.DefaultClassResolver;
import ognl.ElementsAccessor;
import ognl.EnumerationElementsAccessor;
import ognl.EnumerationPropertyAccessor;
import ognl.EvaluationPool;
import ognl.IteratorElementsAccessor;
import ognl.IteratorPropertyAccessor;
import ognl.ListPropertyAccessor;
import ognl.MapElementsAccessor;
import ognl.MapPropertyAccessor;
import ognl.MemberAccess;
import ognl.MethodAccessor;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.Node;
import ognl.NullHandler;
import ognl.NumberElementsAccessor;
import ognl.NumericCasts;
import ognl.NumericDefaults;
import ognl.NumericLiterals;
import ognl.NumericValues;
import ognl.ObjectElementsAccessor;
import ognl.ObjectIndexedPropertyDescriptor;
import ognl.ObjectMethodAccessor;
import ognl.ObjectNullHandler;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlCache;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.PrimitiveDefaults;
import ognl.PrimitiveTypes;
import ognl.PrimitiveWrapperClasses;
import ognl.PropertyAccessor;
import ognl.SetPropertyAccessor;
import ognl.TypeConverter;
import ognl.enhance.ExpressionCompiler;
import ognl.enhance.OgnlExpressionCompiler;
import ognl.internal.CacheException;
import ognl.internal.entry.DeclaredMethodCacheEntry;
import ognl.internal.entry.GenericMethodParameterTypeCacheEntry;
import ognl.internal.entry.PermissionCacheEntry;
import ognl.security.OgnlSecurityManagerFactory;
import ognl.security.UserMethod;

public class OgnlRuntime {
    public static final Object NotFound;
    public static final Object[] NoArguments;
    public static final Object NoConversionPossible;
    public static int INDEXED_PROPERTY_NONE;
    public static int INDEXED_PROPERTY_INT;
    public static int INDEXED_PROPERTY_OBJECT;
    public static final String NULL_STRING;
    public static final String SET_PREFIX = "set";
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    private static final Map<Integer, String> HEX_PADDING;
    private static final int HEX_LENGTH = 8;
    private static final String NULL_OBJECT_STRING = "<null>";
    static final String USE_JDK9PLUS_ACCESS_HANDLER = "ognl.UseJDK9PlusAccessHandler";
    static final String USE_STRICTER_INVOCATION = "ognl.UseStricterInvocation";
    private static final boolean _useJDK9PlusAccessHandler;
    private static final boolean _useStricterInvocation;
    private static final int _majorJavaVersion;
    private static final boolean _jdk9Plus;
    private static final AccessibleObjectHandler _accessibleObjectHandler;
    private static final Method SYS_CONSOLE_REF;
    private static final Method SYS_EXIT_REF;
    private static final Method AO_SETACCESSIBLE_REF;
    private static final Method AO_SETACCESSIBLE_ARR_REF;
    static final String OGNL_SECURITY_MANAGER = "ognl.security.manager";
    static final String OGNL_SM_FORCE_DISABLE_ON_INIT = "forceDisableOnInit";
    private static final boolean _disableOgnlSecurityManagerOnInit;
    static final String USE_FIRSTMATCH_GETSET_LOOKUP = "ognl.UseFirstMatchGetSetLookup";
    private static final boolean _useFirstMatchGetSetLookup;
    static final OgnlCache cache;
    private static final PrimitiveTypes primitiveTypes;
    private static final PrimitiveDefaults primitiveDefaults;
    static SecurityManager securityManager;
    static final EvaluationPool _evaluationPool;
    static final Map<Method, Boolean> _methodAccessCache;
    static final Map<Method, Boolean> _methodPermCache;
    static final ClassPropertyMethodCache cacheSetMethod;
    static final ClassPropertyMethodCache cacheGetMethod;
    private static OgnlExpressionCompiler _compiler;
    private static final PrimitiveWrapperClasses primitiveWrapperClasses;
    private static final NumericCasts numericCasts;
    private static final NumericValues numericValues;
    private static final NumericLiterals numericLiterals;
    private static final NumericDefaults numericDefaults;
    private static final Class<?>[] EMPTY_CLASS_ARRAY;
    public static final ArgsCompatbilityReport NoArgsReport;

    public static void clearCache() {
        cache.clear();
    }

    public static void clearAdditionalCache() {
        cacheSetMethod.clear();
        cacheGetMethod.clear();
        cache.clear();
    }

    public static int getMajorJavaVersion() {
        return _majorJavaVersion;
    }

    public static boolean isJdk9Plus() {
        return _jdk9Plus;
    }

    public static String getNumericValueGetter(Class<?> type) {
        return numericValues.get(type);
    }

    public static Class<?> getPrimitiveWrapperClass(Class<?> primitiveClass) {
        return primitiveWrapperClasses.get(primitiveClass);
    }

    public static String getNumericCast(Class<? extends Number> type) {
        return numericCasts.get(type);
    }

    public static String getNumericLiteral(Class<?> type) {
        return numericLiterals.get(type);
    }

    public static void setCompiler(OgnlExpressionCompiler compiler) {
        _compiler = compiler;
    }

    public static OgnlExpressionCompiler getCompiler() {
        return _compiler;
    }

    public static void compileExpression(OgnlContext context, Node expression, Object root) throws Exception {
        _compiler.compileExpression(context, expression, root);
    }

    public static Class<?> getTargetClass(Object o) {
        return o == null ? null : (o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String getBaseName(Object o) {
        return o == null ? null : OgnlRuntime.getClassBaseName(o.getClass());
    }

    public static String getClassBaseName(Class<?> c) {
        String s = c.getName();
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public static String getClassName(Object o, boolean fullyQualified) {
        if (!(o instanceof Class)) {
            o = o.getClass();
        }
        return OgnlRuntime.getClassName(o, fullyQualified);
    }

    public static String getClassName(Class<?> c, boolean fullyQualified) {
        return fullyQualified ? c.getName() : OgnlRuntime.getClassBaseName(c);
    }

    public static String getPackageName(Object o) {
        return o == null ? null : OgnlRuntime.getClassPackageName(o.getClass());
    }

    public static String getClassPackageName(Class<?> c) {
        String s = c.getName();
        int i = s.lastIndexOf(46);
        return i < 0 ? null : s.substring(0, i);
    }

    public static String getPointerString(int num) {
        StringBuilder result = new StringBuilder();
        String hex = Integer.toHexString(num);
        Integer l = hex.length();
        String pad = HEX_PADDING.get(l);
        if (pad == null) {
            StringBuilder pb = new StringBuilder();
            for (int i = hex.length(); i < 8; ++i) {
                pb.append('0');
            }
            pad = new String(pb);
            HEX_PADDING.put(l, pad);
        }
        result.append(pad);
        result.append(hex);
        return new String(result);
    }

    public static String getPointerString(Object o) {
        return OgnlRuntime.getPointerString(o == null ? 0 : System.identityHashCode(o));
    }

    public static String getUniqueDescriptor(Object object, boolean fullyQualified) {
        StringBuilder result = new StringBuilder();
        if (object != null) {
            if (object instanceof Proxy) {
                Class<?> interfaceClass = object.getClass().getInterfaces()[0];
                result.append(OgnlRuntime.getClassName(interfaceClass, fullyQualified));
                result.append('^');
                object = Proxy.getInvocationHandler(object);
            }
            result.append(OgnlRuntime.getClassName(object, fullyQualified));
            result.append('@');
            result.append(OgnlRuntime.getPointerString(object));
        } else {
            result.append(NULL_OBJECT_STRING);
        }
        return new String(result);
    }

    public static String getUniqueDescriptor(Object object) {
        return OgnlRuntime.getUniqueDescriptor(object, false);
    }

    public static Class<?>[] getParameterTypes(Method method) throws CacheException {
        return cache.getMethodParameterTypes(method);
    }

    public static Class<?>[] findParameterTypes(Class<?> type, Method method) {
        if (type == null || type.getGenericSuperclass() == null || !(type.getGenericSuperclass() instanceof ParameterizedType)) {
            return OgnlRuntime.getParameterTypes(method);
        }
        GenericMethodParameterTypeCacheEntry key = new GenericMethodParameterTypeCacheEntry(method, type);
        return cache.getGenericMethodParameterTypes(key);
    }

    public static Class<?>[] getParameterTypes(Constructor<?> constructor) throws CacheException {
        return cache.getParameterTypes(constructor);
    }

    public static SecurityManager getSecurityManager() {
        return securityManager;
    }

    public static void setSecurityManager(SecurityManager value) {
        securityManager = value;
    }

    public static Permission getPermission(Method method) throws CacheException {
        PermissionCacheEntry key = new PermissionCacheEntry(method);
        return cache.getInvokePermission(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invokeMethod(Object target, Method method, Object[] argsArray) throws InvocationTargetException, IllegalAccessException {
        Object result;
        boolean checkPermission;
        boolean syncInvoke;
        GenericDeclaration methodDeclaringClass;
        if (_useStricterInvocation) {
            methodDeclaringClass = method.getDeclaringClass();
            if (AO_SETACCESSIBLE_REF != null && AO_SETACCESSIBLE_REF.equals(method) || AO_SETACCESSIBLE_ARR_REF != null && AO_SETACCESSIBLE_ARR_REF.equals(method) || SYS_EXIT_REF != null && SYS_EXIT_REF.equals(method) || SYS_CONSOLE_REF != null && SYS_CONSOLE_REF.equals(method) || AccessibleObjectHandler.class.isAssignableFrom((Class<?>)methodDeclaringClass) || ClassResolver.class.isAssignableFrom((Class<?>)methodDeclaringClass) || MethodAccessor.class.isAssignableFrom((Class<?>)methodDeclaringClass) || MemberAccess.class.isAssignableFrom((Class<?>)methodDeclaringClass) || OgnlContext.class.isAssignableFrom((Class<?>)methodDeclaringClass) || Runtime.class.isAssignableFrom((Class<?>)methodDeclaringClass) || ClassLoader.class.isAssignableFrom((Class<?>)methodDeclaringClass) || ProcessBuilder.class.isAssignableFrom((Class<?>)methodDeclaringClass) || AccessibleObjectHandlerJDK9Plus.unsafeOrDescendant(methodDeclaringClass)) {
                throw new IllegalAccessException("Method [" + method + "] cannot be called from within OGNL invokeMethod() under stricter invocation mode.");
            }
        }
        methodDeclaringClass = method;
        synchronized (methodDeclaringClass) {
            Boolean methodAccessCacheValue = _methodAccessCache.get(method);
            if (methodAccessCacheValue == null) {
                if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                    if (!method.isAccessible()) {
                        methodAccessCacheValue = Boolean.TRUE;
                        _methodAccessCache.put(method, methodAccessCacheValue);
                    } else {
                        methodAccessCacheValue = Boolean.FALSE;
                        _methodAccessCache.put(method, methodAccessCacheValue);
                    }
                } else {
                    methodAccessCacheValue = Boolean.FALSE;
                    _methodAccessCache.put(method, methodAccessCacheValue);
                }
            }
            syncInvoke = Boolean.TRUE.equals(methodAccessCacheValue);
            Boolean methodPermCacheValue = _methodPermCache.get(method);
            if (methodPermCacheValue == null) {
                if (securityManager != null) {
                    try {
                        securityManager.checkPermission(OgnlRuntime.getPermission(method));
                        methodPermCacheValue = Boolean.TRUE;
                        _methodPermCache.put(method, methodPermCacheValue);
                    }
                    catch (SecurityException ex) {
                        methodPermCacheValue = Boolean.FALSE;
                        _methodPermCache.put(method, methodPermCacheValue);
                        throw new IllegalAccessException("Method [" + method + "] cannot be accessed.");
                    }
                } else {
                    methodPermCacheValue = Boolean.TRUE;
                    _methodPermCache.put(method, methodPermCacheValue);
                }
            }
            checkPermission = Boolean.FALSE.equals(methodPermCacheValue);
        }
        if (syncInvoke) {
            Method ex = method;
            synchronized (ex) {
                if (checkPermission) {
                    try {
                        securityManager.checkPermission(OgnlRuntime.getPermission(method));
                    }
                    catch (SecurityException ex2) {
                        throw new IllegalAccessException("Method [" + method + "] cannot be accessed.");
                    }
                }
                _accessibleObjectHandler.setAccessible(method, true);
                try {
                    result = OgnlRuntime.invokeMethodInsideSandbox(target, method, argsArray);
                }
                finally {
                    _accessibleObjectHandler.setAccessible(method, false);
                }
            }
        }
        if (checkPermission) {
            try {
                securityManager.checkPermission(OgnlRuntime.getPermission(method));
            }
            catch (SecurityException ex) {
                throw new IllegalAccessException("Method [" + method + "] cannot be accessed.");
            }
        }
        result = OgnlRuntime.invokeMethodInsideSandbox(target, method, argsArray);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object invokeMethodInsideSandbox(Object target, Method method, Object[] argsArray) throws InvocationTargetException, IllegalAccessException {
        Object e2;
        Long token;
        if (_disableOgnlSecurityManagerOnInit) {
            return method.invoke(target, argsArray);
        }
        try {
            if (System.getProperty(OGNL_SECURITY_MANAGER) == null) {
                return method.invoke(target, argsArray);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (ClassLoader.class.isAssignableFrom(method.getDeclaringClass())) {
            throw new IllegalAccessException("OGNL direct access to class loader denied!");
        }
        UserMethod userMethod = new UserMethod(target, method, argsArray);
        Permissions p = new Permissions();
        ProtectionDomain pd = new ProtectionDomain(null, p);
        AccessControlContext acc = new AccessControlContext(new ProtectionDomain[]{pd});
        Object ognlSecurityManager = OgnlSecurityManagerFactory.getOgnlSecurityManager();
        try {
            token = (Long)ognlSecurityManager.getClass().getMethod("enter", new Class[0]).invoke(ognlSecurityManager, new Object[0]);
        }
        catch (NoSuchMethodException e2) {
            throw new InvocationTargetException(e2);
        }
        if (token == null) {
            return method.invoke(target, argsArray);
        }
        try {
            e2 = AccessController.doPrivileged(userMethod, acc);
        }
        catch (PrivilegedActionException e2) {
            try {
                if (!(e2.getException() instanceof InvocationTargetException)) throw new InvocationTargetException(e2);
                throw (InvocationTargetException)e2.getException();
            }
            catch (Throwable throwable) {
                try {
                    ognlSecurityManager.getClass().getMethod("leave", Long.TYPE).invoke(ognlSecurityManager, token);
                    throw throwable;
                }
                catch (NoSuchMethodException e3) {
                    throw new InvocationTargetException(e3);
                }
            }
        }
        try {
            ognlSecurityManager.getClass().getMethod("leave", Long.TYPE).invoke(ognlSecurityManager, token);
            return e2;
        }
        catch (NoSuchMethodException e2) {
            throw new InvocationTargetException(e2);
        }
    }

    public static Class<?> getArgClass(Object arg) {
        if (arg == null) {
            return null;
        }
        Class<?> c = arg.getClass();
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c.getSuperclass() == Number.class) {
            if (c == Integer.class) {
                return Integer.TYPE;
            }
            if (c == Double.class) {
                return Double.TYPE;
            }
            if (c == Byte.class) {
                return Byte.TYPE;
            }
            if (c == Long.class) {
                return Long.TYPE;
            }
            if (c == Float.class) {
                return Float.TYPE;
            }
            if (c == Short.class) {
                return Short.TYPE;
            }
        } else if (c == Character.class) {
            return Character.TYPE;
        }
        return c;
    }

    public static Class<?>[] getArgClasses(Object[] args) {
        if (args == null) {
            return null;
        }
        Class[] argClasses = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argClasses[i] = OgnlRuntime.getArgClass(args[i]);
        }
        return argClasses;
    }

    public static boolean isTypeCompatible(Object object, Class<?> c) {
        if (object == null) {
            return true;
        }
        ArgsCompatbilityReport report = new ArgsCompatbilityReport(0, new boolean[1]);
        if (!OgnlRuntime.isTypeCompatible(OgnlRuntime.getArgClass(object), c, 0, report)) {
            return false;
        }
        return !report.conversionNeeded[0];
    }

    public static boolean isTypeCompatible(Class<?> parameterClass, Class<?> methodArgumentClass, int index, ArgsCompatbilityReport report) {
        if (parameterClass == null) {
            report.score += 500;
            return true;
        }
        if (parameterClass == methodArgumentClass) {
            return true;
        }
        if (methodArgumentClass.isArray()) {
            if (parameterClass.isArray()) {
                Class<?> pct = parameterClass.getComponentType();
                Class<?> mct = methodArgumentClass.getComponentType();
                if (mct.isAssignableFrom(pct)) {
                    report.score += 25;
                    return true;
                }
            }
            if (Collection.class.isAssignableFrom(parameterClass)) {
                Class<?> mct = methodArgumentClass.getComponentType();
                if (mct == Object.class) {
                    report.conversionNeeded[index] = true;
                    report.score += 30;
                    return true;
                }
                return false;
            }
        } else if (Collection.class.isAssignableFrom(methodArgumentClass)) {
            if (parameterClass.isArray()) {
                report.conversionNeeded[index] = true;
                report.score += 50;
                return true;
            }
            if (Collection.class.isAssignableFrom(parameterClass)) {
                if (methodArgumentClass.isAssignableFrom(parameterClass)) {
                    report.score += 2;
                    return true;
                }
                report.conversionNeeded[index] = true;
                report.score += 50;
                return true;
            }
        }
        if (methodArgumentClass.isAssignableFrom(parameterClass)) {
            report.score += 40;
            return true;
        }
        if (parameterClass.isPrimitive()) {
            Class<?> ptc = primitiveWrapperClasses.get(parameterClass);
            if (methodArgumentClass == ptc) {
                report.score += 2;
                return true;
            }
            if (methodArgumentClass.isAssignableFrom(ptc)) {
                report.score += 10;
                return true;
            }
        }
        return false;
    }

    public static boolean areArgsCompatible(Object[] args, Class<?>[] classes) {
        ArgsCompatbilityReport report = OgnlRuntime.areArgsCompatible(OgnlRuntime.getArgClasses(args), classes, null);
        if (report == null) {
            return false;
        }
        for (boolean conversionNeeded : report.conversionNeeded) {
            if (!conversionNeeded) continue;
            return false;
        }
        return true;
    }

    public static ArgsCompatbilityReport areArgsCompatible(Class<?>[] args, Class<?>[] classes, Method m) {
        boolean varArgs;
        boolean bl = varArgs = m != null && m.isVarArgs();
        if (args == null || args.length == 0) {
            if (classes == null || classes.length == 0) {
                return NoArgsReport;
            }
            if (varArgs) {
                return NoArgsReport;
            }
            return null;
        }
        if (args.length != classes.length && !varArgs) {
            return null;
        }
        if (varArgs) {
            ArgsCompatbilityReport report = new ArgsCompatbilityReport(1000, new boolean[args.length]);
            if (classes.length - 1 > args.length) {
                return null;
            }
            int count = classes.length - 1;
            for (int index = 0; index < count; ++index) {
                if (OgnlRuntime.isTypeCompatible(args[index], classes[index], index, report)) continue;
                return null;
            }
            Class<?> varArgsType = classes[classes.length - 1].getComponentType();
            int count2 = args.length;
            for (int index = classes.length - 1; index < count2; ++index) {
                if (OgnlRuntime.isTypeCompatible(args[index], varArgsType, index, report)) continue;
                return null;
            }
            return report;
        }
        ArgsCompatbilityReport report = new ArgsCompatbilityReport(0, new boolean[args.length]);
        int count = args.length;
        for (int index = 0; index < count; ++index) {
            if (OgnlRuntime.isTypeCompatible(args[index], classes[index], index, report)) continue;
            return null;
        }
        return report;
    }

    public static boolean isMoreSpecific(Class<?>[] classes1, Class<?>[] classes2) {
        int count = classes1.length;
        for (int index = 0; index < count; ++index) {
            Class<?> c1 = classes1[index];
            Class<?> c2 = classes2[index];
            if (c1 == c2) continue;
            if (c1.isPrimitive()) {
                return true;
            }
            if (c1.isAssignableFrom(c2)) {
                return false;
            }
            if (!c2.isAssignableFrom(c1)) continue;
            return true;
        }
        return false;
    }

    public static String getModifierString(int modifiers) {
        String result = Modifier.isPublic(modifiers) ? "public" : (Modifier.isProtected(modifiers) ? "protected" : (Modifier.isPrivate(modifiers) ? "private" : ""));
        if (Modifier.isStatic(modifiers)) {
            result = "static " + result;
        }
        if (Modifier.isFinal(modifiers)) {
            result = "final " + result;
        }
        if (Modifier.isNative(modifiers)) {
            result = "native " + result;
        }
        if (Modifier.isSynchronized(modifiers)) {
            result = "synchronized " + result;
        }
        if (Modifier.isTransient(modifiers)) {
            result = "transient " + result;
        }
        return result;
    }

    public static <T> Class<T> classForName(OgnlContext context, String className) throws ClassNotFoundException {
        Class<Object> result = primitiveTypes.get(className);
        if (result == null) {
            ClassResolver resolver;
            if (context == null || (resolver = context.getClassResolver()) == null) {
                resolver = new DefaultClassResolver();
            }
            result = resolver.classForName(className, context);
        }
        if (result == null) {
            throw new ClassNotFoundException("Unable to resolve class: " + className);
        }
        return result;
    }

    public static boolean isInstance(OgnlContext context, Object value, String className) throws OgnlException {
        try {
            Class c = OgnlRuntime.classForName(context, className);
            return c.isInstance(value);
        }
        catch (ClassNotFoundException e) {
            throw new OgnlException("No such class: " + className, e);
        }
    }

    public static Object getPrimitiveDefaultValue(Class<?> forClass) {
        return primitiveDefaults.get(forClass);
    }

    public static Object getNumericDefaultValue(Class<?> forClass) {
        return numericDefaults.get(forClass);
    }

    public static Object getConvertedType(OgnlContext context, Object target, Member member, String propertyName, Object value, Class<?> type) {
        return context.getTypeConverter().convertValue(context, target, member, propertyName, value, type);
    }

    public static boolean getConvertedTypes(OgnlContext context, Object target, Member member, String propertyName, Class<?>[] parameterTypes, Object[] args, Object[] newArgs) {
        boolean result = false;
        if (parameterTypes.length == args.length) {
            result = true;
            int ilast = parameterTypes.length - 1;
            for (int i = 0; result && i <= ilast; ++i) {
                Object arg = args[i];
                Class<?> type = parameterTypes[i];
                if (OgnlRuntime.isTypeCompatible(arg, type)) {
                    newArgs[i] = arg;
                    continue;
                }
                Object v = OgnlRuntime.getConvertedType(context, target, member, propertyName, arg, type);
                if (v == NoConversionPossible) {
                    result = false;
                    continue;
                }
                newArgs[i] = v;
            }
        }
        return result;
    }

    public static Constructor<?> getConvertedConstructorAndArgs(OgnlContext context, Object target, List<Constructor<?>> constructors, Object[] args, Object[] newArgs) {
        Constructor<?> result = null;
        TypeConverter converter = context.getTypeConverter();
        if (converter != null && constructors != null) {
            int icount = constructors.size();
            for (int i = 0; result == null && i < icount; ++i) {
                Class<?>[] parameterTypes;
                Constructor<?> ctor = constructors.get(i);
                if (!OgnlRuntime.getConvertedTypes(context, target, ctor, null, parameterTypes = OgnlRuntime.getParameterTypes(ctor), args, newArgs)) continue;
                result = ctor;
            }
        }
        return result;
    }

    public static Method getAppropriateMethod(OgnlContext context, Object source, Object target, String propertyName, String methodName, List<Method> methods, Object[] args, Object[] actualArgs) {
        Method result = null;
        if (methods != null) {
            Class<?>[] argClasses;
            MatchingMethod mm;
            Class typeClass;
            Class clazz = typeClass = target != null ? target.getClass() : null;
            if (typeClass == null && source instanceof Class) {
                typeClass = (Class)source;
            }
            if ((mm = OgnlRuntime.findBestMethod(methods, typeClass, methodName, argClasses = OgnlRuntime.getArgClasses(args))) != null) {
                result = mm.mMethod;
                Class<?>[] mParameterTypes = mm.mParameterTypes;
                System.arraycopy(args, 0, actualArgs, 0, args.length);
                if (actualArgs.length > 0) {
                    for (int j = 0; j < mParameterTypes.length; ++j) {
                        Class<?> type = mParameterTypes[j];
                        if (!mm.report.conversionNeeded[j] && (!type.isPrimitive() || actualArgs[j] != null)) continue;
                        actualArgs[j] = OgnlRuntime.getConvertedType(context, source, result, propertyName, args[j], type);
                    }
                }
            }
        }
        if (result == null) {
            result = OgnlRuntime.getConvertedMethodAndArgs(context, target, propertyName, methods, args, actualArgs);
        }
        return result;
    }

    public static Method getConvertedMethodAndArgs(OgnlContext context, Object target, String propertyName, List<Method> methods, Object[] args, Object[] newArgs) {
        Method result = null;
        TypeConverter converter = context.getTypeConverter();
        if (converter != null && methods != null) {
            int icount = methods.size();
            for (int i = 0; result == null && i < icount; ++i) {
                Class<?>[] parameterTypes;
                Method m = methods.get(i);
                if (!OgnlRuntime.getConvertedTypes(context, target, m, propertyName, parameterTypes = OgnlRuntime.findParameterTypes(target != null ? target.getClass() : null, m), args, newArgs)) continue;
                result = m;
            }
        }
        return result;
    }

    private static MatchingMethod findBestMethod(List<Method> methods, Class<?> typeClass, String name, Class<?>[] argClasses) {
        MatchingMethod mm = null;
        IllegalArgumentException failure = null;
        for (Method method : methods) {
            Class[] mParameterTypes = OgnlRuntime.findParameterTypes(typeClass, method);
            ArgsCompatbilityReport report = OgnlRuntime.areArgsCompatible(argClasses, mParameterTypes, method);
            if (report == null) continue;
            String methodName = method.getName();
            int score = report.score;
            if (!name.equals(methodName)) {
                score = name.equalsIgnoreCase(methodName) ? (score += 200) : (methodName.toLowerCase().endsWith(name.toLowerCase()) ? (score += 500) : (score += 5000));
            }
            if (mm == null || mm.score > score) {
                mm = new MatchingMethod(method, score, report, mParameterTypes);
                failure = null;
                continue;
            }
            if (mm.score != score) continue;
            if (Arrays.equals(mm.mMethod.getParameterTypes(), method.getParameterTypes()) && mm.mMethod.getName().equals(method.getName())) {
                if (Modifier.isPublic(mm.mMethod.getDeclaringClass().getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) continue;
                mm = new MatchingMethod(method, score, report, mParameterTypes);
                failure = null;
                continue;
            }
            if (method.isVarArgs() || mm.mMethod.isVarArgs()) {
                if (method.isVarArgs() && !mm.mMethod.isVarArgs()) continue;
                if (!method.isVarArgs()) {
                    mm = new MatchingMethod(method, score, report, mParameterTypes);
                    failure = null;
                    continue;
                }
                System.err.println("Two vararg methods with same score(" + score + "): \"" + mm.mMethod + "\" and \"" + method + "\" please report!");
                continue;
            }
            int scoreCurr = 0;
            int scoreOther = 0;
            for (int j = 0; j < argClasses.length; ++j) {
                Class<?> argClass = argClasses[j];
                Class<?> mcClass = mm.mParameterTypes[j];
                Class moClass = mParameterTypes[j];
                if (argClass == null) {
                    if (mcClass == moClass) continue;
                    if (mcClass.isAssignableFrom(moClass)) {
                        scoreOther += 1000;
                        continue;
                    }
                    if (moClass.isAssignableFrom(moClass)) {
                        scoreCurr += 1000;
                        continue;
                    }
                    failure = new IllegalArgumentException("Can't decide wich method to use: \"" + mm.mMethod + "\" or \"" + method + "\"");
                    continue;
                }
                if (mcClass == moClass) continue;
                if (mcClass == argClass) {
                    scoreOther += 100;
                    continue;
                }
                if (moClass == argClass) {
                    scoreCurr += 100;
                    continue;
                }
                if (mcClass.isAssignableFrom(moClass)) {
                    scoreOther += 50;
                    continue;
                }
                if (moClass.isAssignableFrom(moClass)) {
                    scoreCurr += 50;
                    continue;
                }
                failure = new IllegalArgumentException("Can't decide wich method to use: \"" + mm.mMethod + "\" or \"" + method + "\"");
            }
            if (scoreCurr == scoreOther) {
                boolean otherIsAbstract;
                boolean currentIsAbstract;
                if (failure != null || (currentIsAbstract = Modifier.isAbstract(mm.mMethod.getModifiers())) != (otherIsAbstract = Modifier.isAbstract(method.getModifiers()))) continue;
                System.err.println("Two methods with same score(" + score + "): \"" + mm.mMethod + "\" and \"" + method + "\" please report!");
                continue;
            }
            if (scoreCurr <= scoreOther) continue;
            mm = new MatchingMethod(method, score, report, mParameterTypes);
            failure = null;
        }
        if (failure != null) {
            throw failure;
        }
        return mm;
    }

    public static Object callAppropriateMethod(OgnlContext context, Object source, Object target, String methodName, String propertyName, List<Method> methods, Object[] args) throws MethodFailedException {
        Throwable reason;
        Object[] actualArgs = new Object[args.length];
        try {
            Method method = OgnlRuntime.getAppropriateMethod(context, source, target, propertyName, methodName, methods, args, actualArgs);
            if (!OgnlRuntime.isMethodAccessible(context, source, method, propertyName)) {
                StringBuilder buffer = new StringBuilder();
                String className = "";
                if (target != null) {
                    className = target.getClass().getName() + ".";
                }
                int ilast = args.length - 1;
                for (int i = 0; i <= ilast; ++i) {
                    Object arg = args[i];
                    buffer.append(arg == null ? NULL_STRING : arg.getClass().getName());
                    if (i >= ilast) continue;
                    buffer.append(", ");
                }
                throw new NoSuchMethodException(className + methodName + "(" + buffer + ")");
            }
            Object[] convertedArgs = actualArgs;
            if (method.isVarArgs()) {
                Class<?>[] parmTypes = method.getParameterTypes();
                for (int i = 0; i < parmTypes.length; ++i) {
                    Object[] varArgs;
                    if (!parmTypes[i].isArray()) continue;
                    convertedArgs = new Object[i + 1];
                    if (actualArgs.length > 0) {
                        System.arraycopy(actualArgs, 0, convertedArgs, 0, convertedArgs.length);
                    }
                    if (actualArgs.length > i) {
                        ArrayList<Object> varArgsList = new ArrayList<Object>();
                        for (int j = i; j < actualArgs.length; ++j) {
                            if (actualArgs[j] == null) continue;
                            varArgsList.add(actualArgs[j]);
                        }
                        varArgs = actualArgs.length == 1 ? (Object[])Array.newInstance(args[0].getClass(), 1) : (Object[])Array.newInstance(parmTypes[i].getComponentType(), varArgsList.size());
                        System.arraycopy(varArgsList.toArray(), 0, varArgs, 0, varArgs.length);
                    } else {
                        varArgs = new Object[]{};
                    }
                    if (actualArgs.length == 1 && args[0].getClass().isArray()) {
                        convertedArgs = varArgs;
                        break;
                    }
                    convertedArgs[i] = varArgs;
                    break;
                }
            }
            return OgnlRuntime.invokeMethod(target, method, convertedArgs);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            reason = e;
        }
        catch (InvocationTargetException e) {
            reason = e.getTargetException();
        }
        throw new MethodFailedException(source, methodName, reason);
    }

    public static Object callStaticMethod(OgnlContext context, String className, String methodName, Object[] args) throws OgnlException {
        try {
            Class targetClass = OgnlRuntime.classForName(context, className);
            MethodAccessor ma = OgnlRuntime.getMethodAccessor(targetClass);
            return ma.callStaticMethod(context, targetClass, methodName, args);
        }
        catch (ClassNotFoundException ex) {
            throw new MethodFailedException(className, methodName, ex);
        }
    }

    public static Object callMethod(OgnlContext context, Object target, String methodName, String propertyName, Object[] args) throws OgnlException {
        return OgnlRuntime.callMethod(context, target, methodName == null ? propertyName : methodName, args);
    }

    public static Object callMethod(OgnlContext context, Object target, String methodName, Object[] args) throws OgnlException {
        if (target == null) {
            throw new NullPointerException("target is null for method " + methodName);
        }
        return OgnlRuntime.getMethodAccessor(target.getClass()).callMethod(context, target, methodName, args);
    }

    public static Object callConstructor(OgnlContext context, String className, Object[] args) throws OgnlException {
        Throwable reason;
        Object[] actualArgs = args;
        try {
            Constructor<?> ctor = null;
            Class<?>[] ctorParameterTypes = null;
            Class target = OgnlRuntime.classForName(context, className);
            List<Constructor<?>> constructors = OgnlRuntime.getConstructors(target);
            for (Constructor<?> constructor : constructors) {
                Class<?>[] cParameterTypes = OgnlRuntime.getParameterTypes(constructor);
                if (!OgnlRuntime.areArgsCompatible(args, cParameterTypes) || ctor != null && !OgnlRuntime.isMoreSpecific(cParameterTypes, ctorParameterTypes)) continue;
                ctor = constructor;
                ctorParameterTypes = cParameterTypes;
            }
            if (ctor == null && (ctor = OgnlRuntime.getConvertedConstructorAndArgs(context, target, constructors, args, actualArgs = new Object[args.length])) == null) {
                throw new NoSuchMethodException();
            }
            if (!context.getMemberAccess().isAccessible(context, target, ctor, null)) {
                throw new IllegalAccessException("access denied to " + target.getName() + "()");
            }
            return ctor.newInstance(actualArgs);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            reason = e;
        }
        catch (InvocationTargetException e) {
            reason = e.getTargetException();
        }
        throw new MethodFailedException(className, "new", reason);
    }

    @Deprecated
    public static Object getMethodValue(OgnlContext context, Object target, String propertyName) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        return OgnlRuntime.getMethodValue(context, target, propertyName, false);
    }

    public static Object getMethodValue(OgnlContext context, Object target, String propertyName, boolean checkAccessAndExistence) throws OgnlException, IllegalAccessException, NoSuchMethodException {
        Object result = null;
        Method m = OgnlRuntime.getGetMethod(target == null ? null : target.getClass(), propertyName);
        if (m == null) {
            m = OgnlRuntime.getReadMethod(target == null ? null : target.getClass(), propertyName, null);
        }
        if (checkAccessAndExistence && (m == null || !context.getMemberAccess().isAccessible(context, target, m, propertyName))) {
            result = NotFound;
        }
        if (result == null) {
            if (m != null) {
                try {
                    result = OgnlRuntime.invokeMethod(target, m, NoArguments);
                }
                catch (InvocationTargetException ex) {
                    throw new OgnlException(propertyName, ex.getTargetException());
                }
            } else {
                throw new NoSuchMethodException(propertyName);
            }
        }
        return result;
    }

    @Deprecated
    public static boolean setMethodValue(OgnlContext context, Object target, String propertyName, Object value) throws OgnlException {
        return OgnlRuntime.setMethodValue(context, target, propertyName, value, false);
    }

    public static boolean setMethodValue(OgnlContext context, Object target, String propertyName, Object value, boolean checkAccessAndExistence) throws OgnlException {
        boolean result = true;
        Method m = OgnlRuntime.getSetMethod(context, target == null ? null : target.getClass(), propertyName);
        if (checkAccessAndExistence && (m == null || !context.getMemberAccess().isAccessible(context, target, m, propertyName))) {
            result = false;
        }
        if (result) {
            if (m != null) {
                Object[] args = new Object[]{value};
                OgnlRuntime.callAppropriateMethod(context, target, target, m.getName(), propertyName, Collections.nCopies(1, m), args);
            } else {
                result = false;
            }
        }
        return result;
    }

    public static List<Constructor<?>> getConstructors(Class<?> targetClass) {
        return cache.getConstructor(targetClass);
    }

    public static Map<String, List<Method>> getMethods(Class<?> targetClass, boolean staticMethods) {
        DeclaredMethodCacheEntry.MethodType type = staticMethods ? DeclaredMethodCacheEntry.MethodType.STATIC : DeclaredMethodCacheEntry.MethodType.NON_STATIC;
        DeclaredMethodCacheEntry key = new DeclaredMethodCacheEntry(targetClass, type);
        return cache.getMethod(key);
    }

    private static boolean isDefaultMethod(Method method) {
        return (method.getModifiers() & 0x409) == 1 && method.getDeclaringClass().isInterface();
    }

    private static boolean isNonDefaultPublicInterfaceMethod(Method method) {
        return (method.getModifiers() & 0x409) == 1025 && method.getDeclaringClass().isInterface();
    }

    @Deprecated
    public static Map<String, List<Method>> getAllMethods(Class<?> targetClass, boolean staticMethods) {
        return OgnlRuntime.getMethods(targetClass, staticMethods);
    }

    public static List<Method> getMethods(Class<?> targetClass, String name, boolean staticMethods) {
        return OgnlRuntime.getMethods(targetClass, staticMethods).get(name);
    }

    @Deprecated
    public static List<Method> getAllMethods(Class<?> targetClass, String name, boolean staticMethods) {
        return OgnlRuntime.getAllMethods(targetClass, staticMethods).get(name);
    }

    public static Map<String, Field> getFields(Class<?> targetClass) {
        return cache.getField(targetClass);
    }

    public static Field getField(Class<?> inClass, String name) {
        Field field = OgnlRuntime.getFields(inClass).get(name);
        if (field == null) {
            for (Class<?> superClass = inClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                field = OgnlRuntime.getFields(superClass).get(name);
                if (field == null) continue;
                return field;
            }
        }
        return field;
    }

    @Deprecated
    public static Object getFieldValue(OgnlContext context, Object target, String propertyName) throws NoSuchFieldException {
        return OgnlRuntime.getFieldValue(context, target, propertyName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFieldValue(OgnlContext context, Object target, String propertyName, boolean checkAccessAndExistence) throws NoSuchFieldException {
        Object result;
        block9: {
            result = null;
            Field f = OgnlRuntime.getField(target == null ? null : target.getClass(), propertyName);
            if (checkAccessAndExistence && (f == null || !context.getMemberAccess().isAccessible(context, target, f, propertyName))) {
                result = NotFound;
            }
            if (result == null) {
                if (f == null) {
                    throw new NoSuchFieldException(propertyName);
                }
                try {
                    if (!Modifier.isStatic(f.getModifiers())) {
                        Object state = context.getMemberAccess().setup(context, target, f, propertyName);
                        try {
                            result = f.get(target);
                            break block9;
                        }
                        finally {
                            context.getMemberAccess().restore(context, target, f, propertyName, state);
                        }
                    }
                    throw new NoSuchFieldException(propertyName);
                }
                catch (IllegalAccessException ex) {
                    throw new NoSuchFieldException(propertyName);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setFieldValue(OgnlContext context, Object target, String propertyName, Object value) throws OgnlException {
        boolean result;
        block6: {
            result = false;
            try {
                int fModifiers;
                Field f = OgnlRuntime.getField(target == null ? null : target.getClass(), propertyName);
                if (f == null || Modifier.isStatic(fModifiers = f.getModifiers()) || Modifier.isFinal(fModifiers)) break block6;
                Object state = context.getMemberAccess().setup(context, target, f, propertyName);
                try {
                    if (OgnlRuntime.isTypeCompatible(value, f.getType()) || (value = OgnlRuntime.getConvertedType(context, target, f, propertyName, value, f.getType())) != null) {
                        f.set(target, value);
                        result = true;
                    }
                }
                finally {
                    context.getMemberAccess().restore(context, target, f, propertyName, state);
                }
            }
            catch (IllegalAccessException ex) {
                throw new NoSuchPropertyException(target, propertyName, ex);
            }
        }
        return result;
    }

    public static boolean isFieldAccessible(OgnlContext context, Object target, Class<?> inClass, String propertyName) {
        return OgnlRuntime.isFieldAccessible(context, target, OgnlRuntime.getField(inClass, propertyName), propertyName);
    }

    public static boolean isFieldAccessible(OgnlContext context, Object target, Field field, String propertyName) {
        return context.getMemberAccess().isAccessible(context, target, field, propertyName);
    }

    public static boolean hasField(OgnlContext context, Object target, Class<?> inClass, String propertyName) {
        Field f = OgnlRuntime.getField(inClass, propertyName);
        return f != null && OgnlRuntime.isFieldAccessible(context, target, f, propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getStaticField(OgnlContext context, String className, String fieldName) throws OgnlException {
        try {
            Object result;
            Field f;
            Class c = OgnlRuntime.classForName(context, className);
            if (fieldName.equals("class")) {
                return c;
            }
            if (c.isEnum()) {
                try {
                    return Enum.valueOf(c, fieldName);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if ((f = OgnlRuntime.getField(c, fieldName)) == null) {
                throw new NoSuchFieldException(fieldName);
            }
            if (!Modifier.isStatic(f.getModifiers())) {
                throw new OgnlException("Field " + fieldName + " of class " + className + " is not static");
            }
            if (context.getMemberAccess().isAccessible(context, null, f, null)) {
                Object state = context.getMemberAccess().setup(context, null, f, null);
                try {
                    result = f.get(null);
                }
                finally {
                    context.getMemberAccess().restore(context, null, f, null, state);
                }
            } else {
                throw new IllegalAccessException("Access to " + fieldName + " of class " + className + " is forbidden");
            }
            return result;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | SecurityException e) {
            Exception reason = e;
            throw new OgnlException("Could not get static field " + fieldName + " from class " + className, reason);
        }
    }

    public static List<Method> getDeclaredMethods(Class<?> targetClass, String propertyName, boolean findSets) {
        String baseName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<String> methodNames = new ArrayList<String>(2);
        if (findSets) {
            methodNames.add(SET_PREFIX + baseName);
        } else {
            methodNames.add(IS_PREFIX + baseName);
            methodNames.add(GET_PREFIX + baseName);
        }
        for (String methodName : methodNames) {
            DeclaredMethodCacheEntry key = new DeclaredMethodCacheEntry(targetClass);
            List<Method> methodList = cache.getMethod(key).get(methodName);
            if (methodList == null) continue;
            methods.addAll(methodList);
        }
        return methods;
    }

    public static boolean isMethodCallable(Method m) {
        return !m.isSynthetic() && !m.isBridge();
    }

    static boolean isMethodCallable_BridgeOrNonSynthetic(Method m) {
        return !m.isSynthetic() || m.isBridge();
    }

    public static Method getGetMethod(Class<?> targetClass, String propertyName) {
        Method method = cacheGetMethod.get(targetClass, propertyName);
        if (method == ClassPropertyMethodCache.NULL_REPLACEMENT) {
            return null;
        }
        if (method != null) {
            return method;
        }
        method = OgnlRuntime._getGetMethod(targetClass, propertyName);
        cacheGetMethod.put(targetClass, propertyName, method);
        return method;
    }

    private static Method _getGetMethod(Class<?> targetClass, String propertyName) {
        List<Method> methods = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, false);
        Method firstGetter = null;
        Method firstPublicGetter = null;
        Method firstNonDefaultPublicInterfaceGetter = null;
        for (Method method : methods) {
            Class<?>[] mParameterTypes = OgnlRuntime.findParameterTypes(targetClass, method);
            if (mParameterTypes.length != 0) continue;
            boolean declaringClassIsPublic = Modifier.isPublic(method.getDeclaringClass().getModifiers());
            if (firstGetter == null) {
                firstGetter = method;
                if (_useFirstMatchGetSetLookup) break;
            }
            if (Modifier.isPublic(method.getModifiers()) && declaringClassIsPublic) {
                firstPublicGetter = method;
                break;
            }
            if (firstNonDefaultPublicInterfaceGetter != null || !OgnlRuntime.isNonDefaultPublicInterfaceMethod(method) || !declaringClassIsPublic) continue;
            firstNonDefaultPublicInterfaceGetter = method;
        }
        Method result = firstPublicGetter != null ? firstPublicGetter : (firstNonDefaultPublicInterfaceGetter != null ? firstNonDefaultPublicInterfaceGetter : firstGetter);
        return result;
    }

    public static boolean isMethodAccessible(OgnlContext context, Object target, Method method, String propertyName) {
        return method != null && context.getMemberAccess().isAccessible(context, target, method, propertyName);
    }

    public static boolean hasGetMethod(OgnlContext context, Object target, Class<?> targetClass, String propertyName) {
        return OgnlRuntime.isMethodAccessible(context, target, OgnlRuntime.getGetMethod(targetClass, propertyName), propertyName);
    }

    public static Method getSetMethod(OgnlContext context, Class<?> targetClass, String propertyName) {
        Method method = cacheSetMethod.get(targetClass, propertyName);
        if (method == ClassPropertyMethodCache.NULL_REPLACEMENT) {
            return null;
        }
        if (method != null) {
            return method;
        }
        method = OgnlRuntime._getSetMethod(context, targetClass, propertyName);
        cacheSetMethod.put(targetClass, propertyName, method);
        return method;
    }

    private static Method _getSetMethod(OgnlContext context, Class<?> targetClass, String propertyName) {
        List<Method> methods = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, true);
        Method firstSetter = null;
        Method firstPublicSetter = null;
        Method firstNonDefaultPublicInterfaceSetter = null;
        for (Method method : methods) {
            Class<?>[] mParameterTypes = OgnlRuntime.findParameterTypes(targetClass, method);
            if (mParameterTypes.length != 1) continue;
            boolean declaringClassIsPublic = Modifier.isPublic(method.getDeclaringClass().getModifiers());
            if (firstSetter == null) {
                firstSetter = method;
                if (_useFirstMatchGetSetLookup) break;
            }
            if (Modifier.isPublic(method.getModifiers()) && declaringClassIsPublic) {
                firstPublicSetter = method;
                break;
            }
            if (firstNonDefaultPublicInterfaceSetter != null || !OgnlRuntime.isNonDefaultPublicInterfaceMethod(method) || !declaringClassIsPublic) continue;
            firstNonDefaultPublicInterfaceSetter = method;
        }
        Method result = firstPublicSetter != null ? firstPublicSetter : (firstNonDefaultPublicInterfaceSetter != null ? firstNonDefaultPublicInterfaceSetter : firstSetter);
        return result;
    }

    public static boolean hasSetMethod(OgnlContext context, Object target, Class<?> targetClass, String propertyName) {
        return OgnlRuntime.isMethodAccessible(context, target, OgnlRuntime.getSetMethod(context, targetClass, propertyName), propertyName);
    }

    public static boolean hasGetProperty(OgnlContext context, Object target, Object oname) throws IntrospectionException {
        Class<?> targetClass = target == null ? null : target.getClass();
        String name = oname.toString();
        return OgnlRuntime.hasGetMethod(context, target, targetClass, name) || OgnlRuntime.hasField(context, target, targetClass, name);
    }

    public static boolean hasSetProperty(OgnlContext context, Object target, Object oname) throws IntrospectionException {
        Class<?> targetClass = target == null ? null : target.getClass();
        String name = oname.toString();
        return OgnlRuntime.hasSetMethod(context, target, targetClass, name) || OgnlRuntime.hasField(context, target, targetClass, name);
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptors(Class<?> targetClass) {
        return cache.getPropertyDescriptor(targetClass);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> targetClass, String propertyName) throws OgnlException {
        if (targetClass == null) {
            return null;
        }
        return OgnlRuntime.getPropertyDescriptors(targetClass).get(propertyName);
    }

    public static PropertyDescriptor[] getPropertyDescriptorsArray(Class<?> targetClass) {
        Collection<PropertyDescriptor> propertyDescriptors = OgnlRuntime.getPropertyDescriptors(targetClass).values();
        return propertyDescriptors.toArray(new PropertyDescriptor[0]);
    }

    public static PropertyDescriptor getPropertyDescriptorFromArray(Class<?> targetClass, String name) {
        PropertyDescriptor[] propertyDescriptors;
        PropertyDescriptor result = null;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = OgnlRuntime.getPropertyDescriptorsArray(targetClass)) {
            if (result != null) break;
            if (propertyDescriptor.getName().compareTo(name) != 0) continue;
            result = propertyDescriptor;
        }
        return result;
    }

    public static void setMethodAccessor(Class<?> clazz, MethodAccessor accessor) {
        cache.setMethodAccessor(clazz, accessor);
    }

    public static MethodAccessor getMethodAccessor(Class<?> clazz) throws OgnlException {
        return cache.getMethodAccessor(clazz);
    }

    public static void setPropertyAccessor(Class<?> clazz, PropertyAccessor accessor) {
        cache.setPropertyAccessor(clazz, accessor);
    }

    public static PropertyAccessor getPropertyAccessor(Class<?> clazz) throws OgnlException {
        return cache.getPropertyAccessor(clazz);
    }

    public static ElementsAccessor getElementsAccessor(Class<?> clazz) throws OgnlException {
        return cache.getElementsAccessor(clazz);
    }

    public static void setElementsAccessor(Class<?> clazz, ElementsAccessor accessor) {
        cache.setElementsAccessor(clazz, accessor);
    }

    public static NullHandler getNullHandler(Class<?> clazz) throws OgnlException {
        return cache.getNullHandler(clazz);
    }

    public static void setNullHandler(Class<?> clazz, NullHandler handler) {
        cache.setNullHandler(clazz, handler);
    }

    public static Object getProperty(OgnlContext context, Object source, Object name) throws OgnlException {
        if (source == null) {
            throw new OgnlException("source is null for getProperty(null, \"" + name + "\")");
        }
        PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(OgnlRuntime.getTargetClass(source));
        if (accessor == null) {
            throw new OgnlException("No property accessor for " + OgnlRuntime.getTargetClass(source).getName());
        }
        return accessor.getProperty(context, source, name);
    }

    public static void setProperty(OgnlContext context, Object target, Object name, Object value) throws OgnlException {
        if (target == null) {
            throw new OgnlException("target is null for setProperty(null, \"" + name + "\", " + value + ")");
        }
        PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(OgnlRuntime.getTargetClass(target));
        if (accessor == null) {
            throw new OgnlException("No property accessor for " + OgnlRuntime.getTargetClass(target).getName());
        }
        accessor.setProperty(context, target, name, value);
    }

    public static int getIndexedPropertyType(Class<?> sourceClass, String name) throws OgnlException {
        int result = INDEXED_PROPERTY_NONE;
        try {
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(sourceClass, name);
            if (pd != null) {
                if (pd instanceof IndexedPropertyDescriptor) {
                    result = INDEXED_PROPERTY_INT;
                } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                    result = INDEXED_PROPERTY_OBJECT;
                }
            }
        }
        catch (Exception ex) {
            throw new OgnlException("problem determining if '" + name + "' is an indexed property", ex);
        }
        return result;
    }

    public static Object getIndexedProperty(OgnlContext context, Object source, String name, Object index) throws OgnlException {
        Object[] args = new Object[]{index};
        try {
            Method m;
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(source == null ? null : source.getClass(), name);
            if (pd instanceof IndexedPropertyDescriptor) {
                m = ((IndexedPropertyDescriptor)pd).getIndexedReadMethod();
            } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                m = ((ObjectIndexedPropertyDescriptor)pd).getIndexedReadMethod();
            } else {
                throw new OgnlException("property '" + name + "' is not an indexed property");
            }
            return OgnlRuntime.callMethod(context, source, m.getName(), args);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException("getting indexed property descriptor for '" + name + "'", ex);
        }
    }

    public static void setIndexedProperty(OgnlContext context, Object source, String name, Object index, Object value) throws OgnlException {
        Object[] args = new Object[]{index, value};
        try {
            Method m;
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(source == null ? null : source.getClass(), name);
            if (pd instanceof IndexedPropertyDescriptor) {
                m = ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod();
            } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                m = ((ObjectIndexedPropertyDescriptor)pd).getIndexedWriteMethod();
            } else {
                throw new OgnlException("property '" + name + "' is not an indexed property");
            }
            OgnlRuntime.callMethod(context, source, m.getName(), args);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException("getting indexed property descriptor for '" + name + "'", ex);
        }
    }

    public static EvaluationPool getEvaluationPool() {
        return _evaluationPool;
    }

    public static void setClassCacheInspector(ClassCacheInspector inspector) {
        cache.setClassCacheInspector(inspector);
    }

    public static Method getMethod(OgnlContext context, Class<?> target, String name, Node[] children, boolean includeStatic) throws Exception {
        Class<?>[] parms;
        if (children != null && children.length > 0) {
            parms = new Class[children.length];
            Class<?> currType = context.getCurrentType();
            Class<?> currAccessor = context.getCurrentAccessor();
            Object cast = context.get("_preCast");
            context.setCurrentObject(context.getRoot());
            context.setCurrentType(context.getRoot() != null ? context.getRoot().getClass() : null);
            context.setCurrentAccessor(null);
            context.setPreviousType(null);
            for (int i = 0; i < children.length; ++i) {
                children[i].toGetSourceString(context, context.getRoot());
                parms[i] = context.getCurrentType();
            }
            context.put("_preCast", cast);
            context.setCurrentType(currType);
            context.setCurrentAccessor(currAccessor);
            context.setCurrentObject(target);
        } else {
            parms = EMPTY_CLASS_ARRAY;
        }
        List<Method> methods = OgnlRuntime.getMethods(target, name, includeStatic);
        if (methods == null) {
            return null;
        }
        for (Method method : methods) {
            boolean varArgs = method.isVarArgs();
            if (parms.length != method.getParameterTypes().length && !varArgs) continue;
            Class<?>[] mparms = method.getParameterTypes();
            boolean matched = true;
            for (int p = 0; p < mparms.length; ++p) {
                if (varArgs && mparms[p].isArray()) continue;
                if (parms[p] == null) {
                    matched = false;
                    break;
                }
                if (parms[p] == mparms[p] || mparms[p].isPrimitive() && Character.TYPE != mparms[p] && Byte.TYPE != mparms[p] && Number.class.isAssignableFrom(parms[p]) && OgnlRuntime.getPrimitiveWrapperClass(parms[p]) == mparms[p]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return method;
        }
        return null;
    }

    public static Method getReadMethod(Class<?> target, String name) {
        return OgnlRuntime.getReadMethod(target, name, null);
    }

    public static Method getReadMethod(Class<?> target, String name, Class<?>[] argClasses) {
        try {
            Method ret;
            Object mm;
            if (name.indexOf(34) >= 0) {
                name = name.replaceAll("\"", "");
            }
            name = name.toLowerCase();
            Method[] methods = target.getMethods();
            ArrayList<Method> candidates = new ArrayList<Method>();
            for (Method method : methods) {
                if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(method) || !method.getName().equalsIgnoreCase(name) && !method.getName().toLowerCase().equals(GET_PREFIX + name) && !method.getName().toLowerCase().equals("has" + name) && !method.getName().toLowerCase().equals(IS_PREFIX + name) || method.getName().startsWith(SET_PREFIX)) continue;
                candidates.add(method);
            }
            if (!candidates.isEmpty() && (mm = OgnlRuntime.findBestMethod(candidates, target, name, argClasses)) != null) {
                return mm.mMethod;
            }
            mm = methods;
            int n = ((Method[])mm).length;
            for (int i = 0; i < n; ++i) {
                Method method;
                method = mm[i];
                if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(method) || !method.getName().equalsIgnoreCase(name) || method.getName().startsWith(SET_PREFIX) || method.getName().startsWith(GET_PREFIX) || method.getName().startsWith(IS_PREFIX) || method.getName().startsWith("has") || method.getReturnType() == Void.TYPE || candidates.contains(method)) continue;
                candidates.add(method);
            }
            if (!candidates.isEmpty() && (mm = OgnlRuntime.findBestMethod(candidates, target, name, argClasses)) != null) {
                return mm.mMethod;
            }
            if (!name.startsWith(GET_PREFIX) && (ret = OgnlRuntime.getReadMethod(target, GET_PREFIX + name, argClasses)) != null) {
                return ret;
            }
            if (!candidates.isEmpty()) {
                int reqArgCount = argClasses == null ? 0 : argClasses.length;
                for (Method m : candidates) {
                    if (m.getParameterTypes().length != reqArgCount) continue;
                    return m;
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return null;
    }

    public static Method getWriteMethod(Class<?> target, String name) {
        return OgnlRuntime.getWriteMethod(target, name, null);
    }

    public static Method getWriteMethod(Class<?> target, String name, Class<?>[] argClasses) {
        try {
            Method ret;
            MatchingMethod mm;
            Method[] cmethods;
            MatchingMethod mm2;
            if (name.indexOf(34) >= 0) {
                name = name.replaceAll("\"", "");
            }
            BeanInfo info = Introspector.getBeanInfo(target);
            MethodDescriptor[] methods = info.getMethodDescriptors();
            ArrayList<Method> candidates = new ArrayList<Method>();
            for (MethodDescriptor method : methods) {
                if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(method.getMethod()) || !method.getName().equalsIgnoreCase(name) && !method.getName().toLowerCase().equals(SET_PREFIX + name.toLowerCase()) || method.getName().startsWith(GET_PREFIX)) continue;
                candidates.add(method.getMethod());
            }
            if (!candidates.isEmpty() && (mm2 = OgnlRuntime.findBestMethod(candidates, target, name, argClasses)) != null) {
                return mm2.mMethod;
            }
            for (Method cmethod : cmethods = target.getMethods()) {
                if (!OgnlRuntime.isMethodCallable_BridgeOrNonSynthetic(cmethod) || !cmethod.getName().equalsIgnoreCase(name) && !cmethod.getName().toLowerCase().equals(SET_PREFIX + name.toLowerCase()) || cmethod.getName().startsWith(GET_PREFIX) || candidates.contains(cmethod)) continue;
                candidates.add(cmethod);
            }
            if (!candidates.isEmpty() && (mm = OgnlRuntime.findBestMethod(candidates, target, name, argClasses)) != null) {
                return mm.mMethod;
            }
            if (!name.startsWith(SET_PREFIX) && (ret = OgnlRuntime.getReadMethod(target, SET_PREFIX + name, argClasses)) != null) {
                return ret;
            }
            if (!candidates.isEmpty()) {
                int reqArgCount = argClasses == null ? 0 : argClasses.length;
                for (Method m : candidates) {
                    if (m.getParameterTypes().length != reqArgCount) continue;
                    return m;
                }
                if (argClasses == null && candidates.size() == 1) {
                    return candidates.get(0);
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return null;
    }

    public static PropertyDescriptor getProperty(Class<?> target, String name) {
        try {
            PropertyDescriptor[] pds;
            BeanInfo info = Introspector.getBeanInfo(target);
            for (PropertyDescriptor pd : pds = info.getPropertyDescriptors()) {
                if (!pd.getName().equalsIgnoreCase(name) && !pd.getName().toLowerCase().endsWith(name.toLowerCase())) continue;
                return pd;
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        return null;
    }

    public static boolean isBoolean(String expression) {
        if (expression == null) {
            return false;
        }
        return "true".equals(expression) || "false".equals(expression) || "!true".equals(expression) || "!false".equals(expression) || "(true)".equals(expression) || "!(true)".equals(expression) || "(false)".equals(expression) || "!(false)".equals(expression) || expression.startsWith("ognl.OgnlOps");
    }

    public static boolean shouldConvertNumericTypes(OgnlContext context) {
        if (context.getCurrentType() == null || context.getPreviousType() == null) {
            return true;
        }
        if (context.getCurrentType() == context.getPreviousType() && context.getCurrentType().isPrimitive() && context.getPreviousType().isPrimitive()) {
            return false;
        }
        return context.getCurrentType() != null && !context.getCurrentType().isArray() && context.getPreviousType() != null && !context.getPreviousType().isArray();
    }

    public static String getChildSource(OgnlContext context, Object target, Node child) {
        String source;
        String pre = (String)context.get("_currentChain");
        if (pre == null) {
            pre = "";
        }
        try {
            child.getValue(context, target);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArithmeticException e) {
            context.setCurrentType(Integer.TYPE);
            return "0";
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        try {
            source = child.toGetSourceString(context, target);
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        if (!(child instanceof ASTConst || target != null && context.getRoot() == target)) {
            source = pre + source;
        }
        if (context.getRoot() != null) {
            source = ExpressionCompiler.getRootExpression(child, context.getRoot(), context) + source;
            context.setCurrentAccessor(context.getRoot().getClass());
        }
        if (child instanceof ASTChain) {
            String cast = (String)context.remove("_preCast");
            if (cast == null) {
                cast = "";
            }
            source = cast + source;
        }
        if (source == null || source.trim().length() < 1) {
            source = "null";
        }
        return source;
    }

    static int detectMajorJavaVersion() {
        int majorVersion = -1;
        try {
            majorVersion = OgnlRuntime.parseMajorJavaVersion(System.getProperty("java.version"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (majorVersion == -1) {
            majorVersion = 5;
        }
        return majorVersion;
    }

    static int parseMajorJavaVersion(String versionString) {
        int majorVersion = -1;
        try {
            String[] sections;
            if (versionString != null && versionString.length() > 0 && (sections = versionString.split("[.\\-+]")).length > 0 && sections[0].length() > 0) {
                int secondSection;
                int firstSection;
                if (sections.length > 1 && sections[1].length() > 0) {
                    firstSection = Integer.parseInt(sections[0]);
                    secondSection = sections[1].matches("\\d+") ? Integer.parseInt(sections[1]) : -1;
                } else {
                    firstSection = Integer.parseInt(sections[0]);
                    secondSection = -1;
                }
                majorVersion = firstSection == 1 && secondSection != -1 ? secondSection : firstSection;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (majorVersion == -1) {
            majorVersion = 5;
        }
        return majorVersion;
    }

    public static boolean getUseJDK9PlusAccessHandlerValue() {
        return _useJDK9PlusAccessHandler;
    }

    public static boolean getUseStricterInvocationValue() {
        return _useStricterInvocation;
    }

    public static boolean getDisableOgnlSecurityManagerOnInitValue() {
        return _disableOgnlSecurityManagerOnInit;
    }

    public static boolean usingJDK9PlusAccessHandler() {
        return _jdk9Plus && _useJDK9PlusAccessHandler;
    }

    public static boolean getUseFirstMatchGetSetLookupValue() {
        return _useFirstMatchGetSetLookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String propertyString2;
        NotFound = new Object();
        NoArguments = new Object[0];
        NoConversionPossible = "ognl.NoConversionPossible";
        INDEXED_PROPERTY_NONE = 0;
        INDEXED_PROPERTY_INT = 1;
        INDEXED_PROPERTY_OBJECT = 2;
        NULL_STRING = "" + null;
        HEX_PADDING = new HashMap<Integer, String>();
        boolean initialFlagState = false;
        try {
            propertyString2 = System.getProperty(USE_JDK9PLUS_ACCESS_HANDLER);
            if (propertyString2 != null && propertyString2.length() > 0) {
                initialFlagState = Boolean.parseBoolean(propertyString2);
            }
        }
        catch (Exception propertyString2) {
            // empty catch block
        }
        _useJDK9PlusAccessHandler = initialFlagState;
        initialFlagState = true;
        try {
            propertyString2 = System.getProperty(USE_STRICTER_INVOCATION);
            if (propertyString2 != null && propertyString2.length() > 0) {
                initialFlagState = Boolean.parseBoolean(propertyString2);
            }
        }
        catch (Exception propertyString3) {
            // empty catch block
        }
        _useStricterInvocation = initialFlagState;
        _majorJavaVersion = OgnlRuntime.detectMajorJavaVersion();
        _jdk9Plus = _majorJavaVersion >= 9;
        _accessibleObjectHandler = OgnlRuntime.usingJDK9PlusAccessHandler() ? AccessibleObjectHandlerJDK9Plus.createHandler() : AccessibleObjectHandlerPreJDK9.createHandler();
        Method setAccessibleMethod = null;
        Method setAccessibleMethodArray = null;
        Method systemExitMethod = null;
        Method systemConsoleMethod = null;
        try {
            setAccessibleMethod = AccessibleObject.class.getMethod("setAccessible", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            AO_SETACCESSIBLE_REF = setAccessibleMethod;
        }
        try {
            setAccessibleMethodArray = AccessibleObject.class.getMethod("setAccessible", AccessibleObject[].class, Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            AO_SETACCESSIBLE_ARR_REF = setAccessibleMethodArray;
        }
        try {
            systemExitMethod = System.class.getMethod("exit", Integer.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            SYS_EXIT_REF = systemExitMethod;
        }
        try {
            systemConsoleMethod = System.class.getMethod("console", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        finally {
            SYS_CONSOLE_REF = systemConsoleMethod;
        }
        initialFlagState = false;
        try {
            propertyString2 = System.getProperty(OGNL_SECURITY_MANAGER);
            if (propertyString2 != null && propertyString2.length() > 0) {
                initialFlagState = OGNL_SM_FORCE_DISABLE_ON_INIT.equalsIgnoreCase(propertyString2);
            }
        }
        catch (Exception propertyString4) {
            // empty catch block
        }
        _disableOgnlSecurityManagerOnInit = initialFlagState;
        initialFlagState = false;
        try {
            propertyString2 = System.getProperty(USE_FIRSTMATCH_GETSET_LOOKUP);
            if (propertyString2 != null && propertyString2.length() > 0) {
                initialFlagState = Boolean.parseBoolean(propertyString2);
            }
        }
        catch (Exception propertyString5) {
            // empty catch block
        }
        _useFirstMatchGetSetLookup = initialFlagState;
        cache = new OgnlCache();
        primitiveTypes = new PrimitiveTypes();
        primitiveDefaults = new PrimitiveDefaults();
        securityManager = System.getSecurityManager();
        _evaluationPool = new EvaluationPool();
        _methodAccessCache = new ConcurrentHashMap<Method, Boolean>();
        _methodPermCache = new ConcurrentHashMap<Method, Boolean>();
        cacheSetMethod = new ClassPropertyMethodCache();
        cacheGetMethod = new ClassPropertyMethodCache();
        primitiveWrapperClasses = new PrimitiveWrapperClasses();
        numericCasts = new NumericCasts();
        numericValues = new NumericValues();
        numericLiterals = new NumericLiterals();
        numericDefaults = new NumericDefaults();
        try {
            Class.forName("javassist.ClassPool");
            _compiler = new ExpressionCompiler();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Javassist library is missing in classpath! Please add missed dependency!", e);
        }
        catch (RuntimeException rt) {
            throw new IllegalStateException("Javassist library cannot be loaded, is it restricted by runtime environment?");
        }
        EMPTY_CLASS_ARRAY = new Class[0];
        ArrayPropertyAccessor p = new ArrayPropertyAccessor();
        OgnlRuntime.setPropertyAccessor(Object.class, new ObjectPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(byte[].class, p);
        OgnlRuntime.setPropertyAccessor(short[].class, p);
        OgnlRuntime.setPropertyAccessor(char[].class, p);
        OgnlRuntime.setPropertyAccessor(int[].class, p);
        OgnlRuntime.setPropertyAccessor(long[].class, p);
        OgnlRuntime.setPropertyAccessor(float[].class, p);
        OgnlRuntime.setPropertyAccessor(double[].class, p);
        OgnlRuntime.setPropertyAccessor(Object[].class, p);
        OgnlRuntime.setPropertyAccessor(List.class, new ListPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Map.class, new MapPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Set.class, new SetPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Iterator.class, new IteratorPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Enumeration.class, new EnumerationPropertyAccessor());
        ArrayElementsAccessor e = new ArrayElementsAccessor();
        OgnlRuntime.setElementsAccessor(Object.class, new ObjectElementsAccessor());
        OgnlRuntime.setElementsAccessor(byte[].class, e);
        OgnlRuntime.setElementsAccessor(short[].class, e);
        OgnlRuntime.setElementsAccessor(char[].class, e);
        OgnlRuntime.setElementsAccessor(int[].class, e);
        OgnlRuntime.setElementsAccessor(long[].class, e);
        OgnlRuntime.setElementsAccessor(float[].class, e);
        OgnlRuntime.setElementsAccessor(double[].class, e);
        OgnlRuntime.setElementsAccessor(Object[].class, e);
        OgnlRuntime.setElementsAccessor(Collection.class, new CollectionElementsAccessor());
        OgnlRuntime.setElementsAccessor(Map.class, new MapElementsAccessor());
        OgnlRuntime.setElementsAccessor(Iterator.class, new IteratorElementsAccessor());
        OgnlRuntime.setElementsAccessor(Enumeration.class, new EnumerationElementsAccessor());
        OgnlRuntime.setElementsAccessor(Number.class, new NumberElementsAccessor());
        ObjectNullHandler nh = new ObjectNullHandler();
        OgnlRuntime.setNullHandler(Object.class, nh);
        OgnlRuntime.setNullHandler(byte[].class, nh);
        OgnlRuntime.setNullHandler(short[].class, nh);
        OgnlRuntime.setNullHandler(char[].class, nh);
        OgnlRuntime.setNullHandler(int[].class, nh);
        OgnlRuntime.setNullHandler(long[].class, nh);
        OgnlRuntime.setNullHandler(float[].class, nh);
        OgnlRuntime.setNullHandler(double[].class, nh);
        OgnlRuntime.setNullHandler(Object[].class, nh);
        ObjectMethodAccessor ma = new ObjectMethodAccessor();
        OgnlRuntime.setMethodAccessor(Object.class, ma);
        OgnlRuntime.setMethodAccessor(byte[].class, ma);
        OgnlRuntime.setMethodAccessor(short[].class, ma);
        OgnlRuntime.setMethodAccessor(char[].class, ma);
        OgnlRuntime.setMethodAccessor(int[].class, ma);
        OgnlRuntime.setMethodAccessor(long[].class, ma);
        OgnlRuntime.setMethodAccessor(float[].class, ma);
        OgnlRuntime.setMethodAccessor(double[].class, ma);
        OgnlRuntime.setMethodAccessor(Object[].class, ma);
        NoArgsReport = new ArgsCompatbilityReport(0, new boolean[0]);
    }

    private static final class ClassPropertyMethodCache {
        private static final Method NULL_REPLACEMENT;
        private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, Method>> cache = new ConcurrentHashMap();

        ClassPropertyMethodCache() {
        }

        Method get(Class<?> clazz, String propertyName) {
            ConcurrentHashMap<String, Method> methodsByPropertyName = this.cache.get(clazz);
            if (methodsByPropertyName == null) {
                return null;
            }
            return methodsByPropertyName.get(propertyName);
        }

        void put(Class<?> clazz, String propertyName, Method method) {
            ConcurrentHashMap<String, Method> old;
            ConcurrentHashMap<String, Method> methodsByPropertyName = this.cache.get(clazz);
            if (methodsByPropertyName == null && null != (old = this.cache.putIfAbsent(clazz, methodsByPropertyName = new ConcurrentHashMap()))) {
                methodsByPropertyName = old;
            }
            methodsByPropertyName.putIfAbsent(propertyName, method == null ? NULL_REPLACEMENT : method);
        }

        void clear() {
            this.cache.clear();
        }

        static {
            try {
                NULL_REPLACEMENT = ClassPropertyMethodCache.class.getDeclaredMethod(OgnlRuntime.GET_PREFIX, Class.class, String.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class MatchingMethod {
        Method mMethod;
        int score;
        ArgsCompatbilityReport report;
        Class<?>[] mParameterTypes;

        private MatchingMethod(Method method, int score, ArgsCompatbilityReport report, Class<?>[] mParameterTypes) {
            this.mMethod = method;
            this.score = score;
            this.report = report;
            this.mParameterTypes = mParameterTypes;
        }
    }

    public static class ArgsCompatbilityReport {
        int score;
        boolean[] conversionNeeded;

        public ArgsCompatbilityReport(int score, boolean[] conversionNeeded) {
            this.score = score;
            this.conversionNeeded = conversionNeeded;
        }
    }
}

