/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.common;

import com.taobao.arthas.common.ExecutingCommand;
import com.taobao.arthas.common.OSUtils;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.Random;
import javax.net.ServerSocketFactory;

public class SocketUtils {
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    private static final Random random = new Random(System.currentTimeMillis());

    private SocketUtils() {
    }

    public static long findTcpListenProcess(int port) {
        try {
            String pid;
            if (OSUtils.isWindows()) {
                String[] command = new String[]{"netstat", "-ano", "-p", "TCP"};
                List<String> lines = ExecutingCommand.runNative(command);
                for (String line : lines) {
                    String[] strings;
                    if (!line.contains("LISTENING") || (strings = line.trim().split("\\s+")).length != 5 || !strings[1].endsWith(":" + port)) continue;
                    return Long.parseLong(strings[4]);
                }
            }
            if ((OSUtils.isLinux() || OSUtils.isMac()) && !(pid = ExecutingCommand.getFirstAnswer("lsof -t -s TCP:LISTEN -i TCP:" + port)).trim().isEmpty()) {
                return Long.parseLong(pid);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    public static boolean isTcpPortAvailable(int port) {
        try {
            ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port, 1, InetAddress.getByName("localhost"));
            serverSocket.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static int findAvailableTcpPort() {
        return SocketUtils.findAvailableTcpPort(1024);
    }

    public static int findAvailableTcpPort(int minPort) {
        return SocketUtils.findAvailableTcpPort(minPort, 65535);
    }

    public static int findAvailableTcpPort(int minPort, int maxPort) {
        return SocketUtils.findAvailablePort(minPort, maxPort);
    }

    private static int findAvailablePort(int minPort, int maxPort) {
        int candidatePort;
        int portRange = maxPort - minPort;
        int searchCounter = 0;
        do {
            if (searchCounter > portRange) {
                throw new IllegalStateException(String.format("Could not find an available tcp port in the range [%d, %d] after %d attempts", minPort, maxPort, searchCounter));
            }
            candidatePort = SocketUtils.findRandomPort(minPort, maxPort);
            ++searchCounter;
        } while (!SocketUtils.isTcpPortAvailable(candidatePort));
        return candidatePort;
    }

    private static int findRandomPort(int minPort, int maxPort) {
        int portRange = maxPort - minPort;
        return minPort + random.nextInt(portRange + 1);
    }
}

