/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.reader;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONArray;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONB;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONException;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONFactory;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONObject;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.FieldReaderAnySetter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.FieldReaderList;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectReaderAdapter<T>
extends ObjectReaderBean<T> {
    protected final String typeKey;
    protected final long typeKeyHashCode;
    protected final FieldReader[] fieldReaders;
    final long[] hashCodes;
    final short[] mapping;
    final long[] hashCodesLCase;
    final short[] mappingLCase;
    final Constructor constructor;
    volatile boolean instantiationError;
    final Class[] seeAlso;
    final String[] seeAlsoNames;
    final Class seeAlsoDefault;
    final Map<Long, Class> seeAlsoMapping;

    public ObjectReaderAdapter(Class objectClass, Supplier<T> creator, FieldReader ... fieldReaders) {
        this(objectClass, null, null, 0L, null, creator, null, fieldReaders);
    }

    public ObjectReaderAdapter(Class objectClass, String typeKey, String typeName, long features, JSONSchema schema, Supplier<T> creator, Function buildFunction, FieldReader ... fieldReaders) {
        this(objectClass, typeKey, typeName, features, schema, creator, buildFunction, (Class[])null, (String[])null, (Class)null, fieldReaders);
    }

    public ObjectReaderAdapter(Class objectClass, String typeKey, String typeName, long features, Supplier<T> creator, Function buildFunction, FieldReader ... fieldReaders) {
        this(objectClass, typeKey, typeName, features, null, creator, buildFunction, fieldReaders);
    }

    public ObjectReaderAdapter(Class objectClass, String typeKey, String typeName, long features, JSONSchema schema, Supplier<T> creator, Function buildFunction, Class[] seeAlso, String[] seeAlsoNames, FieldReader ... fieldReaders) {
        this(objectClass, typeKey, typeName, features, schema, creator, buildFunction, seeAlso, seeAlsoNames, (Class)null, fieldReaders);
    }

    public ObjectReaderAdapter(Class objectClass, String typeKey, String typeName, long features, JSONSchema schema, Supplier<T> creator, Function buildFunction, Class[] seeAlso, String[] seeAlsoNames, Class seeAlsoDefault, FieldReader ... fieldReaders) {
        super(objectClass, creator, typeName, features, schema, buildFunction);
        int index;
        int i;
        Constructor constructor = this.constructor = objectClass == null ? null : BeanUtils.getDefaultConstructor(objectClass, true);
        if (this.constructor != null) {
            this.constructor.setAccessible(true);
        }
        if (typeKey == null || typeKey.isEmpty()) {
            this.typeKey = "@type";
            this.typeKeyHashCode = HASH_TYPE;
        } else {
            this.typeKey = typeKey;
            this.typeKeyHashCode = Fnv.hashCode64(typeKey);
        }
        this.fieldReaders = fieldReaders;
        long[] hashCodes = new long[fieldReaders.length];
        long[] hashCodesLCase = new long[fieldReaders.length];
        for (i = 0; i < fieldReaders.length; ++i) {
            FieldReader fieldReader = fieldReaders[i];
            hashCodes[i] = fieldReader.fieldNameHash;
            hashCodesLCase[i] = fieldReader.fieldNameHashLCase;
            if (fieldReader.isUnwrapped() && (this.extraFieldReader == null || !(this.extraFieldReader instanceof FieldReaderAnySetter))) {
                this.extraFieldReader = fieldReader;
            }
            if (fieldReader.defaultValue == null) continue;
            this.hasDefaultValue = true;
        }
        this.hashCodes = Arrays.copyOf(hashCodes, hashCodes.length);
        Arrays.sort(this.hashCodes);
        this.mapping = new short[this.hashCodes.length];
        for (i = 0; i < hashCodes.length; ++i) {
            long hashCode = hashCodes[i];
            index = Arrays.binarySearch(this.hashCodes, hashCode);
            this.mapping[index] = (short)i;
        }
        this.hashCodesLCase = Arrays.copyOf(hashCodesLCase, hashCodesLCase.length);
        Arrays.sort(this.hashCodesLCase);
        this.mappingLCase = new short[this.hashCodesLCase.length];
        for (i = 0; i < hashCodesLCase.length; ++i) {
            long hashCode = hashCodesLCase[i];
            index = Arrays.binarySearch(this.hashCodesLCase, hashCode);
            this.mappingLCase[index] = (short)i;
        }
        this.seeAlso = seeAlso;
        if (seeAlso != null) {
            this.seeAlsoMapping = new HashMap<Long, Class>(seeAlso.length, 1.0f);
            this.seeAlsoNames = new String[seeAlso.length];
            for (i = 0; i < seeAlso.length; ++i) {
                Class seeAlsoClass = seeAlso[i];
                String seeAlsoTypeName = null;
                if (seeAlsoNames != null && seeAlsoNames.length >= i + 1) {
                    seeAlsoTypeName = seeAlsoNames[i];
                }
                if (seeAlsoTypeName == null || seeAlsoTypeName.isEmpty()) {
                    seeAlsoTypeName = seeAlsoClass.getSimpleName();
                }
                long hashCode = Fnv.hashCode64(seeAlsoTypeName);
                this.seeAlsoMapping.put(hashCode, seeAlsoClass);
                this.seeAlsoNames[i] = seeAlsoTypeName;
            }
        } else {
            this.seeAlsoMapping = null;
            this.seeAlsoNames = null;
        }
        this.seeAlsoDefault = seeAlsoDefault;
    }

    @Override
    public final String getTypeKey() {
        return this.typeKey;
    }

    @Override
    public final long getTypeKeyHash() {
        return this.typeKeyHashCode;
    }

    @Override
    public final long getFeatures() {
        return this.features;
    }

    public FieldReader[] getFieldReaders() {
        return Arrays.copyOf(this.fieldReaders, this.fieldReaders.length);
    }

    public void apply(Consumer<FieldReader> fieldReaderConsumer) {
        for (FieldReader fieldReader : this.fieldReaders) {
            fieldReaderConsumer.accept(fieldReader);
        }
    }

    public Object autoType(JSONReader jsonReader, Class expectClass, long features) {
        String typeName;
        long typeHash = jsonReader.readTypeHashCode();
        JSONReader.Context context = jsonReader.getContext();
        ObjectReader autoTypeObjectReader = null;
        if (jsonReader.isSupportAutoTypeOrHandler(features)) {
            autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
        }
        if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), expectClass, this.features | features | context.getFeatures())) == null) {
            if (expectClass == this.objectClass) {
                autoTypeObjectReader = this;
            } else {
                throw new JSONException(jsonReader.info("autoType not support : " + typeName));
            }
        }
        return autoTypeObjectReader.readObject(jsonReader, null, null, features);
    }

    @Override
    public final Function getBuildFunction() {
        return this.buildFunction;
    }

    @Override
    public T readArrayMappingObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        jsonReader.nextIfArrayStart();
        Object object = this.creator.get();
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            this.fieldReaders[i].readFieldValue(jsonReader, object);
        }
        if (!jsonReader.nextIfArrayEnd()) {
            throw new JSONException(jsonReader.info("array to bean end error"));
        }
        jsonReader.nextIfComma();
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    @Override
    public T readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        ObjectReader autoTypeReader;
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if ((autoTypeReader = this.checkAutoType(jsonReader, features)) != null) {
            return autoTypeReader.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        T object = this.createInstance(0L);
        int entryCnt = jsonReader.startArray();
        if (entryCnt == this.fieldReaders.length) {
            for (int i = 0; i < this.fieldReaders.length; ++i) {
                FieldReader fieldReader = this.fieldReaders[i];
                fieldReader.readFieldValue(jsonReader, object);
            }
        } else {
            this.readArrayMappingJSONBObject0(jsonReader, object, entryCnt);
        }
        if (this.buildFunction != null) {
            return (T)this.buildFunction.apply(object);
        }
        return object;
    }

    protected void readArrayMappingJSONBObject0(JSONReader jsonReader, Object object, int entryCnt) {
        int i;
        for (i = 0; i < this.fieldReaders.length; ++i) {
            if (i >= entryCnt) continue;
            FieldReader fieldReader = this.fieldReaders[i];
            fieldReader.readFieldValue(jsonReader, object);
        }
        for (i = this.fieldReaders.length; i < entryCnt; ++i) {
            jsonReader.skipValue();
        }
    }

    protected Object createInstance0(long features) {
        if ((features & JSONReader.Feature.UseDefaultConstructorAsPossible.mask) != 0L && this.constructor != null && this.constructor.getParameterCount() == 0) {
            Object object;
            try {
                object = this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new JSONException("create instance error, " + this.objectClass, ex);
            }
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            return object;
        }
        if (this.creator == null) {
            throw new JSONException("create instance error, " + this.objectClass);
        }
        return this.creator.get();
    }

    @Override
    protected void initDefaultValue(T object) {
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            FieldReader fieldReader = this.fieldReaders[i];
            Object defaultValue = fieldReader.defaultValue;
            if (defaultValue == null) continue;
            fieldReader.accept(object, defaultValue);
        }
    }

    @Override
    public T createInstance(Collection collection, long features) {
        T object = this.createInstance(0L);
        int index = 0;
        for (Object fieldValue : collection) {
            if (index >= this.fieldReaders.length) break;
            FieldReader fieldReader = this.fieldReaders[index];
            fieldReader.accept(object, fieldValue);
            ++index;
        }
        return object;
    }

    @Override
    public T createInstance(long features) {
        if (this.instantiationError && this.constructor != null) {
            Object object;
            try {
                object = this.constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new JSONException("create instance error, " + this.objectClass, ex);
            }
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            return object;
        }
        try {
            Object object = this.createInstance0(features);
            if (this.hasDefaultValue) {
                this.initDefaultValue(object);
            }
            return (T)object;
        }
        catch (Exception ex) {
            Exception error = ex;
            this.instantiationError = true;
            if (this.constructor != null) {
                try {
                    Object object = this.constructor.newInstance(new Object[0]);
                    if (this.hasDefaultValue) {
                        this.initDefaultValue(object);
                    }
                    return object;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex2) {
                    throw new JSONException("create instance error, " + this.objectClass, ex2);
                }
            }
            throw new JSONException("create instance error, " + this.objectClass, error);
        }
    }

    @Override
    public FieldReader getFieldReader(long hashCode) {
        int m = Arrays.binarySearch(this.hashCodes, hashCode);
        if (m < 0) {
            return null;
        }
        short index = this.mapping[m];
        return this.fieldReaders[index];
    }

    public int getFieldOrdinal(long hashCode) {
        int m = Arrays.binarySearch(this.hashCodes, hashCode);
        return m < 0 ? -1 : this.mapping[m];
    }

    protected final FieldReader getFieldReaderUL(long hashCode, JSONReader jsonReader, long features) {
        FieldReader fieldReader = this.getFieldReader(hashCode);
        if (fieldReader == null && jsonReader.isSupportSmartMatch(this.features | features)) {
            long hashCodeL = jsonReader.getNameHashCodeLCase();
            fieldReader = this.getFieldReaderLCase(hashCodeL == hashCode ? hashCode : hashCodeL);
        }
        return fieldReader;
    }

    protected final void readFieldValue(long hashCode, JSONReader jsonReader, long features, Object object) {
        FieldReader fieldReader = this.getFieldReader(hashCode);
        if (fieldReader == null && jsonReader.isSupportSmartMatch(this.features | features)) {
            long hashCodeL = jsonReader.getNameHashCodeLCase();
            fieldReader = this.getFieldReaderLCase(hashCodeL == hashCode ? hashCode : hashCodeL);
        }
        if (fieldReader != null) {
            if (jsonReader.jsonb) {
                fieldReader.readFieldValueJSONB(jsonReader, object);
            } else {
                fieldReader.readFieldValue(jsonReader, object);
            }
        } else {
            this.processExtra(jsonReader, object);
        }
    }

    @Override
    public FieldReader getFieldReaderLCase(long hashCode) {
        int m = Arrays.binarySearch(this.hashCodesLCase, hashCode);
        if (m < 0) {
            return null;
        }
        short index = this.mappingLCase[m];
        return this.fieldReaders[index];
    }

    protected T autoType(JSONReader jsonReader) {
        String typeName;
        long typeHash = jsonReader.readTypeHashCode();
        JSONReader.Context context = jsonReader.getContext();
        ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
        if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
            throw new JSONException(jsonReader.info("autoType not support : " + typeName));
        }
        return autoTypeObjectReader.readJSONBObject(jsonReader, null, null, this.features);
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.nextIfNull()) {
            return null;
        }
        ObjectReader autoTypeReader = jsonReader.checkAutoType(this.objectClass, this.typeNameHash, this.features | features);
        if (autoTypeReader != null && autoTypeReader.getObjectClass() != this.objectClass) {
            return autoTypeReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        if (!this.serializable) {
            jsonReader.errorOnNoneSerializable(this.objectClass);
        }
        if (jsonReader.isArray()) {
            if (jsonReader.isSupportBeanArray()) {
                return this.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
            }
            throw new JSONException(jsonReader.info("expect object, but " + JSONB.typeName(jsonReader.getType())));
        }
        boolean objectStart = jsonReader.nextIfObjectStart();
        Object object = null;
        int i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.typeKeyHashCode && i == 0) {
                String typeName;
                long typeHash = jsonReader.readValueHashCode();
                JSONReader.Context context = jsonReader.getContext();
                ObjectReader autoTypeObjectReader = this.autoType(context, typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException(jsonReader.info("autoType not support : " + typeName));
                }
                if (autoTypeObjectReader != this) {
                    jsonReader.setTypeRedirect(true);
                    return autoTypeObjectReader.readJSONBObject(jsonReader, fieldType, fieldName, features);
                }
            } else if (hash != 0L) {
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.features)) {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    this.processExtra(jsonReader, object);
                } else {
                    if (object == null) {
                        object = this.createInstance(jsonReader.getContext().getFeatures() | features);
                    }
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        if (object == null) {
            object = this.createInstance(jsonReader.getContext().getFeatures() | features);
        }
        if (this.schema != null) {
            this.schema.assertValidate(object);
        }
        return object;
    }

    @Override
    public ObjectReader autoType(ObjectReaderProvider provider, long typeHash) {
        if (this.seeAlsoMapping != null && this.seeAlsoMapping.size() > 0) {
            Class seeAlsoClass = this.seeAlsoMapping.get(typeHash);
            if (seeAlsoClass == null) {
                return null;
            }
            return provider.getObjectReader(seeAlsoClass);
        }
        return provider.getObjectReader(typeHash);
    }

    @Override
    public ObjectReader autoType(JSONReader.Context context, long typeHash) {
        if (this.seeAlsoMapping != null && this.seeAlsoMapping.size() > 0) {
            Class seeAlsoClass = this.seeAlsoMapping.get(typeHash);
            if (seeAlsoClass == null) {
                return null;
            }
            return context.getObjectReader(seeAlsoClass);
        }
        return context.getObjectReaderAutoType(typeHash);
    }

    @Override
    protected void initStringFieldAsEmpty(Object object) {
        for (int i = 0; i < this.fieldReaders.length; ++i) {
            FieldReader fieldReader = this.fieldReaders[i];
            if (fieldReader.fieldClass != String.class) continue;
            fieldReader.accept(object, "");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T createInstance(Map map, long features) {
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        Object typeKey = map.get(this.typeKey);
        long features2 = features | this.features;
        if (typeKey instanceof String) {
            String typeName = (String)typeKey;
            long typeHash = Fnv.hashCode64(typeName);
            ObjectReader reader = null;
            if ((features & JSONReader.Feature.SupportAutoType.mask) != 0L || this instanceof ObjectReaderSeeAlso) {
                reader = this.autoType(provider, typeHash);
            }
            if (reader == null) {
                reader = provider.getObjectReader(typeName, this.getObjectClass(), features2);
            }
            if (reader != this && reader != null) {
                return reader.createInstance(map, features);
            }
        }
        T object = this.createInstance(features);
        if (this.extraFieldReader == null && (features2 & (JSONReader.Feature.SupportSmartMatch.mask | JSONReader.Feature.ErrorOnUnknownProperties.mask)) == 0L) {
            void var10_12;
            boolean fieldBased = (features2 & JSONReader.Feature.FieldBased.mask) != 0L;
            boolean bl = false;
            while (var10_12 < this.fieldReaders.length) {
                FieldReader fieldReader = this.fieldReaders[var10_12];
                Object fieldValue = map.get(fieldReader.fieldName);
                if (fieldValue != null) {
                    if (fieldValue.getClass() == fieldReader.fieldType) {
                        fieldReader.accept(object, fieldValue);
                    } else if (fieldReader instanceof FieldReaderList && fieldValue instanceof JSONArray) {
                        ObjectReader objectReader = fieldReader.getObjectReader(provider);
                        Object fieldValueList = objectReader.createInstance((Collection)((JSONArray)fieldValue), features);
                        fieldReader.accept(object, fieldValueList);
                    } else if (fieldValue instanceof JSONObject && fieldReader.fieldType != JSONObject.class) {
                        JSONObject jsonObject = (JSONObject)fieldValue;
                        Object fieldValueJavaBean = provider.getObjectReader(fieldReader.fieldType, fieldBased).createInstance((Map)jsonObject, features);
                        fieldReader.accept(object, fieldValueJavaBean);
                    } else {
                        fieldReader.acceptAny(object, fieldValue, features);
                    }
                }
                ++var10_12;
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String entryKey = entry.getKey().toString();
                Object fieldValue = entry.getValue();
                FieldReader fieldReader = this.getFieldReader(entryKey);
                if (fieldReader == null) {
                    this.acceptExtra(object, entryKey, entry.getValue(), features);
                    continue;
                }
                if (fieldValue != null && fieldValue.getClass() == fieldReader.fieldType) {
                    fieldReader.accept(object, fieldValue);
                    continue;
                }
                fieldReader.acceptAny(object, fieldValue, features);
            }
        }
        return (T)(this.buildFunction != null ? this.buildFunction.apply(object) : object);
    }
}

