/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.schema;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.schema.ValidateResult;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

final class Not
extends JSONSchema {
    final JSONSchema schema;
    final JSONSchema.Type[] types;
    final Boolean result;

    public Not(JSONSchema schema, JSONSchema.Type[] types, Boolean result) {
        super(null, null);
        this.schema = schema;
        this.types = types;
        this.result = result;
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.AllOf;
    }

    @Override
    public ValidateResult validate(Object value) {
        if (this.schema != null && this.schema.validate(value).isSuccess()) {
            return FAIL_NOT;
        }
        if (this.types != null) {
            block10: for (JSONSchema.Type type : this.types) {
                switch (type) {
                    case String: {
                        if (!(value instanceof String)) continue block10;
                        return FAIL_NOT;
                    }
                    case Integer: {
                        if (!(value instanceof Byte) && !(value instanceof Short) && !(value instanceof Integer) && !(value instanceof Long) && !(value instanceof BigInteger) && !(value instanceof AtomicInteger) && !(value instanceof AtomicLong)) continue block10;
                        return FAIL_NOT;
                    }
                    case Number: {
                        if (!(value instanceof Number)) continue block10;
                        return FAIL_NOT;
                    }
                    case Null: {
                        if (value != null) continue block10;
                        return FAIL_NOT;
                    }
                    case Array: {
                        if (!(value instanceof Object[]) && !(value instanceof Collection) && (value == null || !value.getClass().isArray())) continue block10;
                        return FAIL_NOT;
                    }
                    case Object: {
                        if (value instanceof Map) {
                            return FAIL_NOT;
                        }
                        if (value == null || !(JSONSchema.CONTEXT.getObjectReader(value.getClass()) instanceof ObjectReaderBean)) continue block10;
                        return FAIL_NOT;
                    }
                    case Boolean: {
                        if (!(value instanceof Boolean)) continue block10;
                        return FAIL_NOT;
                    }
                    case Any: {
                        return FAIL_NOT;
                    }
                }
            }
        }
        if (this.result != null) {
            return this.result != false ? FAIL_NOT : SUCCESS;
        }
        return SUCCESS;
    }
}

