/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.io.netty.buffer;

import com.alibaba.arthas.deps.io.netty.buffer.AbstractByteBufAllocator;
import com.alibaba.arthas.deps.io.netty.buffer.AdaptivePoolingAllocator;
import com.alibaba.arthas.deps.io.netty.buffer.ByteBuf;
import com.alibaba.arthas.deps.io.netty.buffer.ByteBufAllocator;
import com.alibaba.arthas.deps.io.netty.buffer.ByteBufAllocatorMetric;
import com.alibaba.arthas.deps.io.netty.buffer.ByteBufAllocatorMetricProvider;
import com.alibaba.arthas.deps.io.netty.buffer.UnpooledDirectByteBuf;
import com.alibaba.arthas.deps.io.netty.buffer.UnpooledHeapByteBuf;
import com.alibaba.arthas.deps.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import com.alibaba.arthas.deps.io.netty.buffer.UnsafeByteBufUtil;
import com.alibaba.arthas.deps.io.netty.util.internal.PlatformDependent;
import com.alibaba.arthas.deps.io.netty.util.internal.SystemPropertyUtil;
import com.alibaba.arthas.deps.io.netty.util.internal.logging.InternalLogger;
import com.alibaba.arthas.deps.io.netty.util.internal.logging.InternalLoggerFactory;

public final class AdaptiveByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetricProvider,
ByteBufAllocatorMetric {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AdaptiveByteBufAllocator.class);
    private static final boolean DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS = SystemPropertyUtil.getBoolean("com.alibaba.arthas.deps.io.netty.allocator.useCachedMagazinesForNonEventLoopThreads", false);
    private final AdaptiveAllocatorApi direct;
    private final AdaptiveAllocatorApi heap;

    public AdaptiveByteBufAllocator() {
        this(PlatformDependent.directBufferPreferred());
    }

    public AdaptiveByteBufAllocator(boolean preferDirect) {
        this(preferDirect, DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }

    public AdaptiveByteBufAllocator(boolean preferDirect, boolean useCacheForNonEventLoopThreads) {
        super(preferDirect);
        if (PlatformDependent.javaVersion() < 8) {
            throw new IllegalStateException("This allocator require Java 8 or newer.");
        }
        AdaptivePoolingAllocator.MagazineCaching magazineCaching = useCacheForNonEventLoopThreads ? AdaptivePoolingAllocator.MagazineCaching.FastThreadLocalThreads : AdaptivePoolingAllocator.MagazineCaching.EventLoopThreads;
        this.direct = new AdaptivePoolingAllocator(new DirectChunkAllocator(this), magazineCaching);
        this.heap = new AdaptivePoolingAllocator(new HeapChunkAllocator(this), magazineCaching);
    }

    @Override
    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return this.heap.allocate(initialCapacity, maxCapacity);
    }

    @Override
    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        return this.direct.allocate(initialCapacity, maxCapacity);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return true;
    }

    @Override
    public long usedHeapMemory() {
        return this.heap.usedMemory();
    }

    @Override
    public long usedDirectMemory() {
        return this.direct.usedMemory();
    }

    @Override
    public ByteBufAllocatorMetric metric() {
        return this;
    }

    static {
        logger.debug("-Dio.netty.allocator.useCachedMagazinesForNonEventLoopThreads: {}", (Object)DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }

    private static final class DirectChunkAllocator
    implements AdaptivePoolingAllocator.ChunkAllocator {
        private final ByteBufAllocator allocator;

        private DirectChunkAllocator(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public ByteBuf allocate(int initialCapacity, int maxCapacity) {
            return PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this.allocator, initialCapacity, maxCapacity) : new UnpooledDirectByteBuf(this.allocator, initialCapacity, maxCapacity);
        }
    }

    private static final class HeapChunkAllocator
    implements AdaptivePoolingAllocator.ChunkAllocator {
        private final ByteBufAllocator allocator;

        private HeapChunkAllocator(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        @Override
        public ByteBuf allocate(int initialCapacity, int maxCapacity) {
            return PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf(this.allocator, initialCapacity, maxCapacity) : new UnpooledHeapByteBuf(this.allocator, initialCapacity, maxCapacity);
        }
    }

    static interface AdaptiveAllocatorApi {
        public ByteBuf allocate(int var1, int var2);

        public long usedMemory();
    }
}

