/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.tunnel.client;

import com.alibaba.arthas.deps.io.netty.bootstrap.Bootstrap;
import com.alibaba.arthas.deps.io.netty.channel.Channel;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFuture;
import com.alibaba.arthas.deps.io.netty.channel.ChannelFutureListener;
import com.alibaba.arthas.deps.io.netty.channel.ChannelHandlerContext;
import com.alibaba.arthas.deps.io.netty.channel.ChannelInitializer;
import com.alibaba.arthas.deps.io.netty.channel.ChannelOption;
import com.alibaba.arthas.deps.io.netty.channel.ChannelPipeline;
import com.alibaba.arthas.deps.io.netty.channel.ChannelPromise;
import com.alibaba.arthas.deps.io.netty.channel.EventLoopGroup;
import com.alibaba.arthas.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.alibaba.arthas.deps.io.netty.channel.local.LocalAddress;
import com.alibaba.arthas.deps.io.netty.channel.local.LocalChannel;
import com.alibaba.arthas.deps.io.netty.channel.nio.NioEventLoopGroup;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.HttpObjectAggregator;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import com.alibaba.arthas.deps.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.alibaba.arthas.deps.io.netty.util.concurrent.DefaultThreadFactory;
import com.alibaba.arthas.deps.io.netty.util.concurrent.Future;
import com.alibaba.arthas.deps.io.netty.util.concurrent.GenericFutureListener;
import com.alibaba.arthas.deps.org.slf4j.Logger;
import com.alibaba.arthas.deps.org.slf4j.LoggerFactory;
import com.alibaba.arthas.tunnel.client.LocalFrameHandler;
import com.alibaba.arthas.tunnel.client.RelayHandler;
import java.net.URISyntaxException;

public class ForwardClientSocketClientHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private static final Logger logger = LoggerFactory.getLogger(ForwardClientSocketClientHandler.class);
    private ChannelPromise handshakeFuture;

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        logger.info("WebSocket Client disconnected!");
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt.equals((Object)WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE)) {
            try {
                this.connectLocalServer(ctx);
            }
            catch (Throwable e) {
                logger.error("ForwardClientSocketClientHandler connect local arthas server error", e);
            }
        } else {
            ctx.fireUserEventTriggered(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectLocalServer(final ChannelHandlerContext ctx) throws InterruptedException, URISyntaxException {
        block5: {
            NioEventLoopGroup group;
            block4: {
                group = new NioEventLoopGroup(1, new DefaultThreadFactory("arthas-forward-client-connect-local", true));
                ChannelFuture closeFuture = null;
                try {
                    logger.info("ForwardClientSocketClientHandler star connect local arthas server");
                    WebSocketClientProtocolConfig clientProtocolConfig = WebSocketClientProtocolConfig.newBuilder().webSocketUri("ws://127.0.0.1:8563/ws").maxFramePayloadLength(0xA00000).build();
                    final WebSocketClientProtocolHandler websocketClientHandler = new WebSocketClientProtocolHandler(clientProtocolConfig);
                    final LocalFrameHandler localFrameHandler = new LocalFrameHandler();
                    Bootstrap b = new Bootstrap();
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000);
                    ((Bootstrap)((Bootstrap)b.group(group)).channel(LocalChannel.class)).handler(new ChannelInitializer<LocalChannel>(){

                        @Override
                        protected void initChannel(LocalChannel ch) {
                            ChannelPipeline p = ch.pipeline();
                            p.addLast(new HttpClientCodec(), new HttpObjectAggregator(0xA00000), websocketClientHandler, localFrameHandler);
                        }
                    });
                    LocalAddress localAddress = new LocalAddress("arthas-netty-LocalAddress");
                    Channel localChannel = b.connect(localAddress).sync().channel();
                    this.handshakeFuture = localFrameHandler.handshakeFuture();
                    this.handshakeFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            ChannelPipeline pipeline = future.channel().pipeline();
                            pipeline.remove(localFrameHandler);
                            pipeline.addLast(new RelayHandler(ctx.channel()));
                        }
                    });
                    this.handshakeFuture.sync();
                    ctx.pipeline().remove(this);
                    ctx.pipeline().addLast(new RelayHandler(localChannel));
                    logger.info("ForwardClientSocketClientHandler connect local arthas server success");
                    closeFuture = localChannel.closeFuture();
                    if (closeFuture == null) break block4;
                    closeFuture.addListener(new ChannelFutureListener(){
                        final /* synthetic */ EventLoopGroup val$group;
                        {
                            this.val$group = eventLoopGroup;
                        }

                        @Override
                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            this.val$group.shutdownGracefully();
                        }
                    });
                }
                catch (Throwable throwable) {
                    if (closeFuture != null) {
                        closeFuture.addListener(new /* invalid duplicate definition of identical inner class */);
                    } else {
                        group.shutdownGracefully();
                    }
                    throw throwable;
                }
                break block5;
            }
            group.shutdownGracefully();
        }
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) {
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("ForwardClientSocketClient channel: {}", (Object)ctx.channel(), (Object)cause);
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        ctx.close();
    }
}

