/*
 * Decompiled with CFR 0.152.
 */
package io.termd.core.term;

import io.termd.core.term.Capability;
import io.termd.core.term.Feature;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Device {
    final String name;
    final List<String> synonyms;
    final String longname;
    final Map<Capability<?>, Feature<?>> features;

    public Device(List<String> names) {
        this.name = names.get(0);
        this.synonyms = names.size() > 2 ? names.subList(1, names.size() - 1) : Collections.emptyList();
        this.longname = names.size() > 1 ? names.get(names.size() - 1) : null;
        this.features = new HashMap();
    }

    public Device(String name, List<String> synonyms, String longname) {
        this.name = name;
        this.synonyms = synonyms;
        this.features = new HashMap();
        this.longname = longname;
    }

    public Collection<Feature<?>> getFeatures() {
        return this.features.values();
    }

    public <T> T getFeature(Capability<T> capability) {
        return this.getFeature(capability, null);
    }

    public <T> T getFeature(Capability<T> capability, T def) {
        Feature<?> feature = this.features.get(capability);
        if (feature != null) {
            return capability.type.cast(feature.value);
        }
        return def;
    }

    public void addFeature(Feature<?> feature) {
        this.features.put(feature.capability, feature);
    }

    public void addFeature(String name, Object value) {
        this.addFeature(Feature.create(name, value));
    }

    public void addFeatures(Iterable<Feature<?>> features) {
        for (Feature<?> feature : features) {
            this.addFeature(feature);
        }
    }

    public String toString() {
        return "Device[name=" + this.name + "]";
    }
}

