/*
 * Decompiled with CFR 0.152.
 */
package java.arthas;

public class SpyAPI {
    public static final AbstractSpy NOPSPY;
    private static volatile AbstractSpy spyInstance;
    public static volatile boolean INITED;

    public static AbstractSpy getSpy() {
        return spyInstance;
    }

    public static void setSpy(AbstractSpy spy) {
        spyInstance = spy;
    }

    public static void setNopSpy() {
        SpyAPI.setSpy(NOPSPY);
    }

    public static boolean isNopSpy() {
        return NOPSPY == spyInstance;
    }

    public static void init() {
        INITED = true;
    }

    public static boolean isInited() {
        return INITED;
    }

    public static void destroy() {
        SpyAPI.setNopSpy();
        INITED = false;
    }

    public static void atEnter(Class<?> clazz, String methodInfo, Object target, Object[] args) {
        spyInstance.atEnter(clazz, methodInfo, target, args);
    }

    public static void atExit(Class<?> clazz, String methodInfo, Object target, Object[] args, Object returnObject) {
        spyInstance.atExit(clazz, methodInfo, target, args, returnObject);
    }

    public static void atExceptionExit(Class<?> clazz, String methodInfo, Object target, Object[] args, Throwable throwable) {
        spyInstance.atExceptionExit(clazz, methodInfo, target, args, throwable);
    }

    public static void atBeforeInvoke(Class<?> clazz, String invokeInfo, Object target) {
        spyInstance.atBeforeInvoke(clazz, invokeInfo, target);
    }

    public static void atAfterInvoke(Class<?> clazz, String invokeInfo, Object target) {
        spyInstance.atAfterInvoke(clazz, invokeInfo, target);
    }

    public static void atInvokeException(Class<?> clazz, String invokeInfo, Object target, Throwable throwable) {
        spyInstance.atInvokeException(clazz, invokeInfo, target, throwable);
    }

    static {
        spyInstance = NOPSPY = new NopSpy();
    }

    public static abstract class AbstractSpy {
        public abstract void atEnter(Class<?> var1, String var2, Object var3, Object[] var4);

        public abstract void atExit(Class<?> var1, String var2, Object var3, Object[] var4, Object var5);

        public abstract void atExceptionExit(Class<?> var1, String var2, Object var3, Object[] var4, Throwable var5);

        public abstract void atBeforeInvoke(Class<?> var1, String var2, Object var3);

        public abstract void atAfterInvoke(Class<?> var1, String var2, Object var3);

        public abstract void atInvokeException(Class<?> var1, String var2, Object var3, Throwable var4);
    }

    static class NopSpy
    extends AbstractSpy {
        NopSpy() {
        }

        @Override
        public void atEnter(Class<?> clazz, String methodInfo, Object target, Object[] args) {
        }

        @Override
        public void atExit(Class<?> clazz, String methodInfo, Object target, Object[] args, Object returnObject) {
        }

        @Override
        public void atExceptionExit(Class<?> clazz, String methodInfo, Object target, Object[] args, Throwable throwable) {
        }

        @Override
        public void atBeforeInvoke(Class<?> clazz, String invokeInfo, Object target) {
        }

        @Override
        public void atAfterInvoke(Class<?> clazz, String invokeInfo, Object target) {
        }

        @Override
        public void atInvokeException(Class<?> clazz, String invokeInfo, Object target, Throwable throwable) {
        }
    }
}

