/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONException;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.ByteVector;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.FieldWriter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.MethodWriter;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.internal.asm.SymbolTable;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.util.TypeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class ClassWriter {
    private final Function<String, Class> typeProvider;
    private int version;
    private final SymbolTable symbolTable = new SymbolTable(this);
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int interfaceCount;
    private int[] interfaces;
    private FieldWriter firstField;
    private FieldWriter lastField;
    private MethodWriter firstMethod;
    private MethodWriter lastMethod;

    public ClassWriter(Function<String, Class> typeProvider) {
        this.typeProvider = typeProvider;
    }

    public final void visit(int version, int access, String name, String superName, String[] interfaces) {
        this.version = version;
        this.accessFlags = access;
        this.thisClass = this.symbolTable.setMajorVersionAndClassName(version & 0xFFFF, name);
        int n = this.superClass = superName == null ? 0 : this.symbolTable.addConstantUtf8Reference((int)7, (String)superName).index;
        if (interfaces != null && interfaces.length > 0) {
            this.interfaceCount = interfaces.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i = 0; i < this.interfaceCount; ++i) {
                this.interfaces[i] = this.symbolTable.addConstantUtf8Reference((int)7, (String)interfaces[i]).index;
            }
        }
    }

    public final FieldWriter visitField(int access, String name, String descriptor) {
        FieldWriter fieldWriter = new FieldWriter(this.symbolTable, access, name, descriptor);
        if (this.firstField == null) {
            this.firstField = fieldWriter;
        } else {
            this.lastField.fv = fieldWriter;
        }
        this.lastField = fieldWriter;
        return this.lastField;
    }

    public final MethodWriter visitMethod(int access, String name, String descriptor, int codeInitCapacity) {
        MethodWriter methodWriter = new MethodWriter(this.symbolTable, access, name, descriptor, codeInitCapacity);
        if (this.firstMethod == null) {
            this.firstMethod = methodWriter;
        } else {
            this.lastMethod.mv = methodWriter;
        }
        this.lastMethod = methodWriter;
        return this.lastMethod;
    }

    public byte[] toByteArray() {
        int size = 24 + 2 * this.interfaceCount;
        int fieldsCount = 0;
        FieldWriter fieldWriter = this.firstField;
        while (fieldWriter != null) {
            ++fieldsCount;
            size += 8;
            fieldWriter = fieldWriter.fv;
        }
        int methodsCount = 0;
        MethodWriter methodWriter = this.firstMethod;
        while (methodWriter != null) {
            ++methodsCount;
            size += methodWriter.computeMethodInfoSize();
            methodWriter = methodWriter.mv;
        }
        int attributesCount = 0;
        size += this.symbolTable.constantPool.length;
        int constantPoolCount = this.symbolTable.constantPoolCount;
        if (constantPoolCount > 65535) {
            throw new JSONException("Class too large: " + this.symbolTable.className + ", constantPoolCount " + constantPoolCount);
        }
        ByteVector result = new ByteVector(size);
        result.putInt(-889275714).putInt(this.version);
        result.putShort(constantPoolCount).putByteArray(this.symbolTable.constantPool.data, 0, this.symbolTable.constantPool.length);
        int mask = 0;
        result.putShort(this.accessFlags & ~mask).putShort(this.thisClass).putShort(this.superClass);
        result.putShort(this.interfaceCount);
        for (int i = 0; i < this.interfaceCount; ++i) {
            result.putShort(this.interfaces[i]);
        }
        result.putShort(fieldsCount);
        fieldWriter = this.firstField;
        while (fieldWriter != null) {
            fieldWriter.putFieldInfo(result);
            fieldWriter = fieldWriter.fv;
        }
        result.putShort(methodsCount);
        boolean hasFrames = false;
        boolean hasAsmInstructions = false;
        methodWriter = this.firstMethod;
        while (methodWriter != null) {
            hasFrames |= methodWriter.stackMapTableNumberOfEntries > 0;
            hasAsmInstructions |= methodWriter.hasAsmInstructions;
            methodWriter.putMethodInfo(result);
            methodWriter = methodWriter.mv;
        }
        result.putShort(attributesCount);
        if (hasAsmInstructions) {
            throw new UnsupportedOperationException();
        }
        return result.data;
    }

    protected Class loadClass(String type) {
        switch (type) {
            case "java/util/List": {
                return List.class;
            }
            case "java/util/ArrayList": {
                return ArrayList.class;
            }
            case "java/lang/Object": {
                return Object.class;
            }
        }
        String className1 = type.replace('/', '.');
        Class clazz = null;
        if (this.typeProvider != null) {
            clazz = this.typeProvider.apply(className1);
        }
        if (clazz == null) {
            clazz = TypeUtils.loadClass(className1);
        }
        return clazz;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        Class class1 = this.loadClass(type1);
        if (class1 == null) {
            throw new JSONException("class not found " + type1);
        }
        Class class2 = this.loadClass(type2);
        if (class2 == null) {
            return "java/lang/Object";
        }
        if (class1.isAssignableFrom(class2)) {
            return type1;
        }
        if (class2.isAssignableFrom(class1)) {
            return type2;
        }
        if (class1.isInterface() || class2.isInterface()) {
            return "java/lang/Object";
        }
        while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
        }
        return class1.getName().replace('.', '/');
    }
}

