/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.arthas.deps.com.alibaba.fastjson2.reader;

import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONException;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.JSONReader;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.arthas.deps.com.alibaba.fastjson2.schema.JSONSchema;
import java.lang.reflect.Field;

final class FieldReaderCharValueField<T>
extends FieldReaderObjectField<T> {
    FieldReaderCharValueField(String fieldName, int ordinal, long features, String format, Character defaultValue, JSONSchema schema, Field field) {
        super(fieldName, Character.TYPE, Character.TYPE, ordinal, features, format, null, defaultValue, schema, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        char ch = jsonReader.readCharValue();
        if (ch == '\u0000' && jsonReader.wasNull()) {
            return;
        }
        this.accept(object, ch);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        String str = jsonReader.readString();
        return Character.valueOf(str == null || str.isEmpty() ? (char)'\u0000' : str.charAt(0));
    }

    @Override
    public void accept(T object, Object value) {
        char charValue;
        if (value instanceof String) {
            charValue = ((String)value).charAt(0);
        } else if (value instanceof Character) {
            charValue = ((Character)value).charValue();
        } else {
            throw new JSONException("cast to char error");
        }
        this.accept(object, charValue);
    }
}

